/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.internal.IconicsView;
import com.mikepenz.iconics.internal.IconicsViewsAttrsApplier;

public class IconicsImageView
extends AppCompatImageView
implements IconicsView {
    public IconicsImageView(Context context) {
        this(context, null);
    }

    public IconicsImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public IconicsImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.initialize(context, attrs, defStyle);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(Context context, AttributeSet attrs, int defStyle) {
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.applyAttr(context, attrs, defStyle);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void applyAttr(Context context, AttributeSet attrs, int defStyle) {
        this.setIcon(IconicsViewsAttrsApplier.getIconicsImageViewDrawable(context, attrs));
    }

    public void setIcon(@Nullable IconicsDrawable icon) {
        this.setImageDrawable((Drawable)icon);
    }

    public IconicsDrawable getIcon() {
        if (this.getDrawable() instanceof IconicsDrawable) {
            return (IconicsDrawable)this.getDrawable();
        }
        return null;
    }
}

