/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.iconics.view;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.widget.TextView;
import com.mikepenz.iconics.Iconics;
import com.mikepenz.iconics.IconicsDrawable;
import com.mikepenz.iconics.internal.CompoundIconicsDrawables;
import com.mikepenz.iconics.internal.CompoundIconsBundle;
import com.mikepenz.iconics.internal.IconicsView;
import com.mikepenz.iconics.internal.IconicsViewsAttrsApplier;

public class IconicsTextView
extends AppCompatTextView
implements CompoundIconicsDrawables,
IconicsView {
    protected final CompoundIconsBundle mIconsBundle = new CompoundIconsBundle();

    public IconicsTextView(Context context) {
        this(context, null);
    }

    public IconicsTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842884);
    }

    public IconicsTextView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!this.isInEditMode()) {
            this.initialize(context, attrs, defStyle);
        }
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void initialize(Context context, AttributeSet attrs, int defStyle) {
        this.applyAttr(context, attrs, defStyle);
        this.setIcons();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void applyAttr(Context context, AttributeSet attrs, int defStyle) {
        IconicsViewsAttrsApplier.readIconicsTextView(context, attrs, this.mIconsBundle);
    }

    private void setIcons() {
        this.mIconsBundle.setIcons((TextView)this);
    }

    @Override
    public IconicsDrawable getIconicsDrawableStart() {
        if (this.mIconsBundle.mStartIcon != null) {
            return this.mIconsBundle.mStartIcon;
        }
        return null;
    }

    @Override
    public IconicsDrawable getIconicsDrawableTop() {
        if (this.mIconsBundle.mTopIcon != null) {
            return this.mIconsBundle.mTopIcon;
        }
        return null;
    }

    @Override
    public IconicsDrawable getIconicsDrawableEnd() {
        if (this.mIconsBundle.mEndIcon != null) {
            return this.mIconsBundle.mEndIcon;
        }
        return null;
    }

    @Override
    public IconicsDrawable getIconicsDrawableBottom() {
        if (this.mIconsBundle.mBottomIcon != null) {
            return this.mIconsBundle.mBottomIcon;
        }
        return null;
    }

    @Override
    public void setDrawableStart(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mStartIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setDrawableTop(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mTopIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setDrawableEnd(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mEndIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setDrawableBottom(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mBottomIcon = drawable;
        this.setIcons();
    }

    @Override
    public void setDrawableForAll(@Nullable IconicsDrawable drawable) {
        this.mIconsBundle.mStartIcon = drawable;
        this.mIconsBundle.mTopIcon = drawable;
        this.mIconsBundle.mEndIcon = drawable;
        this.mIconsBundle.mBottomIcon = drawable;
        this.setIcons();
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (!this.isInEditMode()) {
            super.setText((CharSequence)new Iconics.IconicsBuilder().ctx(this.getContext()).on(text).build(), type);
        } else {
            super.setText(text, type);
        }
    }
}

