/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.logging;

import android.util.Log;
import androidx.annotation.Nullable;
import com.mopub.common.logging.MoPubLogger;

public class MoPubDefaultLogger
implements MoPubLogger {
    static int MAX_MESSAGE_LENGTH_BYTES = 3072;
    private static final String MESSAGE_FORMAT = "[%s][%s] %s";
    private static final String MESSAGE_WITH_ID_FORMAT = "[%s][%s][%s] %s";

    @Override
    public void log(@Nullable String className, @Nullable String methodName, @Nullable String identifier, @Nullable String message) {
        for (String segment : MoPubDefaultLogger.split(message)) {
            if (identifier == null) {
                Log.i((String)"MoPub", (String)String.format(MESSAGE_FORMAT, className, methodName, segment));
                continue;
            }
            Log.i((String)"MoPub", (String)String.format(MESSAGE_WITH_ID_FORMAT, className, methodName, identifier, segment));
        }
    }

    static String[] split(@Nullable String message) {
        if (message == null) {
            return new String[1];
        }
        int segmentCount = 1 + message.length() / MAX_MESSAGE_LENGTH_BYTES;
        String[] segments = new String[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            segments[i] = message.substring(i * MAX_MESSAGE_LENGTH_BYTES, Math.min((i + 1) * MAX_MESSAGE_LENGTH_BYTES, message.length()));
        }
        return segments;
    }
}

