/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.view.Display;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mopub/common/util/ImageUtils;", "", "()V", "applyFastGaussianBlurToBitmap", "Landroid/graphics/Bitmap;", "mutableBitmap", "radius", "", "getMaxImageWidth", "context", "Landroid/content/Context;", "mopub-sdk-util_release"})
public final class ImageUtils {
    @NotNull
    public static final ImageUtils INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final Bitmap applyFastGaussianBlurToBitmap(@NotNull Bitmap mutableBitmap, int radius) {
        Intrinsics.checkNotNullParameter((Object)mutableBitmap, (String)"mutableBitmap");
        int w = mutableBitmap.getWidth();
        int h = mutableBitmap.getHeight();
        int[] pixels = new int[w * h];
        mutableBitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        for (int r = radius; r >= 1; r /= 2) {
            int n = r;
            int n2 = h - r;
            while (n < n2) {
                void i;
                int n3 = r;
                int n4 = w - r;
                while (n3 < n4) {
                    void j;
                    int tl = pixels[(i - r) * w + j - r];
                    int tr = pixels[(i - r) * w + j + r];
                    int tc = pixels[(i - r) * w + j];
                    int bl = pixels[(i + r) * w + j - r];
                    int br = pixels[(i + r) * w + j + r];
                    int bc = pixels[(i + r) * w + j];
                    int cl = pixels[i * w + j - r];
                    int cr = pixels[i * w + j + r];
                    pixels[i * w + j] = 0xFF000000 | (tl & 0xFF) + (tr & 0xFF) + (tc & 0xFF) + (bl & 0xFF) + (br & 0xFF) + (bc & 0xFF) + (cl & 0xFF) + (cr & 0xFF) >> 3 & 0xFF | (tl & 0xFF00) + (tr & 0xFF00) + (tc & 0xFF00) + (bl & 0xFF00) + (br & 0xFF00) + (bc & 0xFF00) + (cl & 0xFF00) + (cr & 0xFF00) >> 3 & 0xFF00 | (tl & 0xFF0000) + (tr & 0xFF0000) + (tc & 0xFF0000) + (bl & 0xFF0000) + (br & 0xFF0000) + (bc & 0xFF0000) + (cl & 0xFF0000) + (cr & 0xFF0000) >> 3 & 0xFF0000;
                    ++j;
                }
                ++i;
            }
        }
        mutableBitmap.setPixels(pixels, 0, w, 0, 0, w, h);
        return mutableBitmap;
    }

    @JvmStatic
    public static final int getMaxImageWidth(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getSize(size);
        int n = size.x;
        int n2 = size.y;
        boolean bl = false;
        return Math.min(n, n2);
    }

    private ImageUtils() {
    }

    static {
        ImageUtils imageUtils;
        INSTANCE = imageUtils = new ImageUtils();
    }
}

