/*
 * Decompiled with CFR 0.152.
 */
package com.mopub.common.util;

import android.app.Activity;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import com.mopub.common.Preconditions;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class Utils {
    private static final AtomicLong sNextGeneratedId = new AtomicLong(1L);

    public static String sha1(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = string.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            for (byte b : bytes = digest.digest()) {
                stringBuilder.append(String.format("%02X", b));
            }
            return stringBuilder.toString().toLowerCase(Locale.US);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static long generateUniqueId() {
        long newValue;
        long result;
        do {
            if ((newValue = (result = sNextGeneratedId.get()) + 1L) <= 0x7FFFFFFFFFFFFFFEL) continue;
            newValue = 1L;
        } while (!sNextGeneratedId.compareAndSet(result, newValue));
        return result;
    }

    public static boolean bitMaskContainsFlag(int bitMask, int flag) {
        return (bitMask & flag) != 0;
    }

    public static void hideNavigationBar(@NonNull Activity activity) {
        Preconditions.checkNotNull(activity);
        Window window = activity.getWindow();
        if (window != null) {
            View view = window.getDecorView();
            Utils.hideNavigation(view);
            view.setOnSystemUiVisibilityChangeListener(Utils.createHideNavigationListener(view));
        }
    }

    static View.OnSystemUiVisibilityChangeListener createHideNavigationListener(final @NonNull View view) {
        Preconditions.checkNotNull(view);
        return new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int visibility) {
                if ((visibility & 2) == 0) {
                    Utils.hideNavigation(view);
                }
            }
        };
    }

    static void hideNavigation(@NonNull View view) {
        Preconditions.checkNotNull(view);
        view.setSystemUiVisibility(4870);
    }
}

