/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid;

import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.oauth.EncryptedPreferences;
import com.navercorp.nid.oauth.NidOAuthBehavior;
import com.navercorp.nid.oauth.NidOAuthBridgeActivity;
import com.navercorp.nid.oauth.NidOAuthErrorCode;
import com.navercorp.nid.oauth.NidOAuthLogin;
import com.navercorp.nid.oauth.NidOAuthLoginState;
import com.navercorp.nid.oauth.NidOAuthPreferencesManager;
import com.navercorp.nid.oauth.OAuthLoginCallback;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0019J\b\u0010\"\u001a\u0004\u0018\u00010#J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u0004\u0018\u00010#J\b\u0010)\u001a\u0004\u0018\u00010#J\u0006\u0010*\u001a\u00020+J\b\u0010,\u001a\u0004\u0018\u00010#J\u0006\u0010-\u001a\u00020#J&\u0010.\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010/\u001a\u00020#2\u0006\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020#J\u0006\u00102\u001a\u00020\u001fJ\u000e\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0010R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u00065"}, d2={"Lcom/navercorp/nid/NaverIdLoginSDK;", "", "()V", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "setApplicationContext", "(Landroid/content/Context;)V", "behavior", "Lcom/navercorp/nid/oauth/NidOAuthBehavior;", "getBehavior", "()Lcom/navercorp/nid/oauth/NidOAuthBehavior;", "setBehavior", "(Lcom/navercorp/nid/oauth/NidOAuthBehavior;)V", "isRequiredCustomTabsReAuth", "", "()Z", "setRequiredCustomTabsReAuth", "(Z)V", "isShowBottomTab", "setShowBottomTab", "isShowMarketLink", "setShowMarketLink", "oauthLoginCallback", "Lcom/navercorp/nid/oauth/OAuthLoginCallback;", "getOauthLoginCallback", "()Lcom/navercorp/nid/oauth/OAuthLoginCallback;", "setOauthLoginCallback", "(Lcom/navercorp/nid/oauth/OAuthLoginCallback;)V", "authenticate", "", "context", "callback", "getAccessToken", "", "getExpiresAt", "", "getLastErrorCode", "Lcom/navercorp/nid/oauth/NidOAuthErrorCode;", "getLastErrorDescription", "getRefreshToken", "getState", "Lcom/navercorp/nid/oauth/NidOAuthLoginState;", "getTokenType", "getVersion", "initialize", "clientId", "clientSecret", "clientName", "logout", "showDevelopersLog", "isShow", "Nid-OAuth_release"})
public final class NaverIdLoginSDK {
    @NotNull
    public static final NaverIdLoginSDK INSTANCE = new NaverIdLoginSDK();
    private static boolean isShowMarketLink = true;
    private static boolean isShowBottomTab = true;
    private static boolean isRequiredCustomTabsReAuth;
    public static OAuthLoginCallback oauthLoginCallback;
    public static Context applicationContext;
    @NotNull
    private static NidOAuthBehavior behavior;

    private NaverIdLoginSDK() {
    }

    public final boolean isShowMarketLink() {
        return isShowMarketLink;
    }

    public final void setShowMarketLink(boolean bl) {
        isShowMarketLink = bl;
    }

    public final boolean isShowBottomTab() {
        return isShowBottomTab;
    }

    public final void setShowBottomTab(boolean bl) {
        isShowBottomTab = bl;
    }

    public final boolean isRequiredCustomTabsReAuth() {
        return isRequiredCustomTabsReAuth;
    }

    public final void setRequiredCustomTabsReAuth(boolean bl) {
        isRequiredCustomTabsReAuth = bl;
    }

    @NotNull
    public final OAuthLoginCallback getOauthLoginCallback() {
        OAuthLoginCallback oAuthLoginCallback = oauthLoginCallback;
        if (oAuthLoginCallback != null) {
            return oAuthLoginCallback;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"oauthLoginCallback");
        return null;
    }

    public final void setOauthLoginCallback(@NotNull OAuthLoginCallback oAuthLoginCallback) {
        Intrinsics.checkNotNullParameter((Object)oAuthLoginCallback, (String)"<set-?>");
        oauthLoginCallback = oAuthLoginCallback;
    }

    @NotNull
    public final Context getApplicationContext() {
        Context context = applicationContext;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationContext");
        return null;
    }

    public final void setApplicationContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        applicationContext = context;
    }

    public final void initialize(@NotNull Context context, @NotNull String clientId, @NotNull String clientSecret, @NotNull String clientName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)clientSecret, (String)"clientSecret");
        Intrinsics.checkNotNullParameter((Object)clientName, (String)"clientName");
        Object object = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.applicationContext");
        EncryptedPreferences.setContext(object);
        Object $this$initialize_u24lambda_u2d0 = object = NidOAuthPreferencesManager.INSTANCE;
        boolean bl = false;
        NidOAuthPreferencesManager.setClientId(clientId);
        NidOAuthPreferencesManager.setClientSecret(clientSecret);
        NidOAuthPreferencesManager.setClientName(clientName);
        NidOAuthPreferencesManager.setCallbackUrl(context.getPackageName());
        NidOAuthPreferencesManager.setLastErrorCode(NidOAuthErrorCode.NONE);
        NidOAuthPreferencesManager.setLastErrorDesc("");
        NidLog.setPrefix("NaverIdLogin|" + context.getPackageName() + '|');
        object = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.applicationContext");
        this.setApplicationContext((Context)object);
    }

    public final void showDevelopersLog(boolean isShow) {
        NidLog.showLog(isShow);
    }

    @NotNull
    public final String getVersion() {
        return "5.1.0";
    }

    public final void authenticate(@NotNull Context context, @NotNull OAuthLoginCallback callback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        if (this.getState() == NidOAuthLoginState.NEED_INIT) {
            Toast.makeText((Context)context.getApplicationContext(), (CharSequence)"SDK \ucd08\uae30\ud654\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.", (int)0).show();
            return;
        }
        this.setOauthLoginCallback(callback);
        String refreshToken2 = this.getRefreshToken();
        CharSequence charSequence = refreshToken2;
        if (charSequence == null || charSequence.length() == 0) {
            Intent intent;
            int orientation = context.getResources().getConfiguration().orientation;
            Intent $this$authenticate_u24lambda_u2d1 = intent = new Intent(context, NidOAuthBridgeActivity.class);
            boolean bl = false;
            $this$authenticate_u24lambda_u2d1.putExtra("orientation", orientation);
            $this$authenticate_u24lambda_u2d1.addFlags(0x10000000);
            Intent intent2 = intent;
            context.startActivity(intent2);
        } else {
            new NidOAuthLogin().refreshToken(context, callback);
        }
    }

    public final void logout() {
        NidOAuthPreferencesManager nidOAuthPreferencesManager;
        NidOAuthPreferencesManager $this$logout_u24lambda_u2d2 = nidOAuthPreferencesManager = NidOAuthPreferencesManager.INSTANCE;
        boolean bl = false;
        NidOAuthPreferencesManager.setAccessToken("");
        NidOAuthPreferencesManager.setRefreshToken("");
        NidOAuthPreferencesManager.setLastErrorCode(NidOAuthErrorCode.NONE);
        NidOAuthPreferencesManager.setLastErrorDesc("");
    }

    @NotNull
    public final NidOAuthErrorCode getLastErrorCode() {
        return NidOAuthPreferencesManager.getLastErrorCode();
    }

    @Nullable
    public final String getLastErrorDescription() {
        return NidOAuthPreferencesManager.getLastErrorDesc();
    }

    @NotNull
    public final NidOAuthBehavior getBehavior() {
        return behavior;
    }

    public final void setBehavior(@NotNull NidOAuthBehavior nidOAuthBehavior) {
        Intrinsics.checkNotNullParameter((Object)((Object)nidOAuthBehavior), (String)"<set-?>");
        behavior = nidOAuthBehavior;
    }

    @Nullable
    public final String getAccessToken() {
        return NidOAuthPreferencesManager.getAccessToken();
    }

    @Nullable
    public final String getRefreshToken() {
        return NidOAuthPreferencesManager.getRefreshToken();
    }

    public final long getExpiresAt() {
        return NidOAuthPreferencesManager.getExpiresAt();
    }

    @Nullable
    public final String getTokenType() {
        return NidOAuthPreferencesManager.getTokenType();
    }

    @NotNull
    public final NidOAuthLoginState getState() {
        String clientId = NidOAuthPreferencesManager.getClientId();
        CharSequence charSequence = clientId;
        if (charSequence == null || charSequence.length() == 0) {
            return NidOAuthLoginState.NEED_INIT;
        }
        String clientSecret = NidOAuthPreferencesManager.getClientSecret();
        CharSequence charSequence2 = clientSecret;
        if (charSequence2 == null || charSequence2.length() == 0) {
            return NidOAuthLoginState.NEED_INIT;
        }
        String accessToken2 = this.getAccessToken();
        String refreshToken2 = this.getRefreshToken();
        CharSequence charSequence3 = accessToken2;
        if (charSequence3 == null || charSequence3.length() == 0) {
            charSequence3 = refreshToken2;
            return charSequence3 == null || charSequence3.length() == 0 ? NidOAuthLoginState.NEED_LOGIN : NidOAuthLoginState.NEED_REFRESH_TOKEN;
        }
        return NidOAuthLoginState.OK;
    }

    static {
        behavior = NidOAuthBehavior.DEFAULT;
    }
}

