/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.cookie;

import android.webkit.CookieManager;
import com.navercorp.nid.log.NidLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0004J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/navercorp/nid/cookie/NidOAuthCookieManager;", "", "()V", "NID_DOMAIN", "", "TAG", "getCookie", "getCookieListFromHeader", "", "header", "", "setCookie", "", "url", "cookies", "Nid-OAuth_release"})
public final class NidOAuthCookieManager {
    @NotNull
    public static final NidOAuthCookieManager INSTANCE = new NidOAuthCookieManager();
    @NotNull
    private static final String TAG = "NidOAuthCookieManager";
    @NotNull
    private static final String NID_DOMAIN = "https://nid.naver.com";

    private NidOAuthCookieManager() {
    }

    public final void setCookie(@NotNull String url, @NotNull List<String> cookies) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(cookies, (String)"cookies");
        CookieManager cookieManager = CookieManager.getInstance();
        NidLog.i(TAG, Intrinsics.stringPlus((String)"setCookie url : ", (Object)url));
        Iterable $this$forEach$iv = cookies;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            cookieManager.setCookie(url, it);
            NidLog.i(TAG, Intrinsics.stringPlus((String)"setCookie : ", (Object)it));
        }
        cookieManager.flush();
    }

    @NotNull
    public final String getCookie() {
        String string = CookieManager.getInstance().getCookie(NID_DOMAIN);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().getCookie(NID_DOMAIN)");
        return string;
    }

    @NotNull
    public final List<String> getCookieListFromHeader(@NotNull Map<String, ? extends List<String>> header) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        ArrayList<String> cookieList = null;
        cookieList = new ArrayList<String>();
        Iterable $this$forEach$iv = header.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List<String> headerList;
            String it = (String)element$iv;
            boolean bl = false;
            if (!StringsKt.equals((String)"Set-Cookie", (String)it, (boolean)true) || (headerList = header.get(it)) == null || !(!((Collection)headerList).isEmpty())) continue;
            for (String c : headerList) {
                String cookie = ((Object)StringsKt.trim((CharSequence)c)).toString();
                if (StringsKt.endsWith$default((String)cookie, (String)";", (boolean)false, (int)2, null)) {
                    cookieList.add(String.valueOf(cookie));
                } else {
                    cookieList.add(Intrinsics.stringPlus((String)cookie, (Object)";"));
                }
                NidLog.d(TAG, Intrinsics.stringPlus((String)"cookie : ", (Object)cookie));
            }
        }
        return cookieList;
    }
}

