/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import androidx.security.crypto.EncryptedSharedPreferences;
import androidx.security.crypto.MasterKey;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.oauth.EncryptedPreferences;
import com.navercorp.nid.oauth.NidOAuthPreferencesManager;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0016J\u0018\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0015\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u0019J\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00042\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0004J\b\u0010\u001a\u001a\u00020\bH\u0002J\b\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\bH\u0002J\u001a\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0016J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0018J\u0016\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0019J\u0018\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lcom/navercorp/nid/oauth/EncryptedPreferences;", "", "()V", "OLD_OAUTH_LOGIN_PREF_NAME", "", "context", "Landroid/content/Context;", "encryptedPreferences", "Landroid/content/SharedPreferences;", "getEncryptedPreferences", "()Landroid/content/SharedPreferences;", "encryptedPreferences$delegate", "Lkotlin/Lazy;", "masterKey", "Landroidx/security/crypto/MasterKey;", "getMasterKey", "()Landroidx/security/crypto/MasterKey;", "masterKey$delegate", "del", "", "key", "get", "", "defaultValue", "", "", "init", "migration", "moveToData", "preferences", "set", "value", "setContext", "Nid-OAuth_release"})
public final class EncryptedPreferences {
    @NotNull
    public static final EncryptedPreferences INSTANCE = new EncryptedPreferences();
    private static Context context;
    @NotNull
    private static final Lazy masterKey$delegate;
    @NotNull
    private static final Lazy encryptedPreferences$delegate;
    @NotNull
    private static final String OLD_OAUTH_LOGIN_PREF_NAME = "NaverOAuthLoginPreferenceData";

    private EncryptedPreferences() {
    }

    private final MasterKey getMasterKey() {
        Lazy lazy = masterKey$delegate;
        return (MasterKey)lazy.getValue();
    }

    private final SharedPreferences getEncryptedPreferences() {
        Lazy lazy = encryptedPreferences$delegate;
        return (SharedPreferences)lazy.getValue();
    }

    private final SharedPreferences init() {
        Context context = EncryptedPreferences.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((Context)context, (String)"NaverOAuthLoginEncryptedPreferenceData", (MasterKey)this.getMasterKey(), (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n            this\u2026heme.AES256_GCM\n        )");
        return sharedPreferences;
    }

    @JvmStatic
    public static final void setContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EncryptedPreferences.context = context;
        INSTANCE.migration();
    }

    public final synchronized void set(@NotNull String key, int value) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit$iv = this.getEncryptedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$set_u24lambda_u2d0 = editor;
        boolean bl = false;
        $this$set_u24lambda_u2d0.putInt(key, value);
        editor$iv.apply();
    }

    public final synchronized int get(@NotNull String key, int defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getEncryptedPreferences().getInt(key, defaultValue);
    }

    public static /* synthetic */ int get$default(EncryptedPreferences encryptedPreferences2, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return encryptedPreferences2.get(string, n);
    }

    public final synchronized void set(@NotNull String key, long value) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit$iv = this.getEncryptedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$set_u24lambda_u2d1 = editor;
        boolean bl = false;
        $this$set_u24lambda_u2d1.putLong(key, value);
        editor$iv.apply();
    }

    public final synchronized long get(@NotNull String key, long defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getEncryptedPreferences().getLong(key, defaultValue);
    }

    public static /* synthetic */ long get$default(EncryptedPreferences encryptedPreferences2, String string, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        return encryptedPreferences2.get(string, l);
    }

    public final synchronized void set(@NotNull String key, @Nullable String value) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit$iv = this.getEncryptedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$set_u24lambda_u2d2 = editor;
        boolean bl = false;
        $this$set_u24lambda_u2d2.putString(key, value);
        editor$iv.apply();
    }

    @Nullable
    public final synchronized String get(@NotNull String key, @Nullable String defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getEncryptedPreferences().getString(key, defaultValue);
    }

    public static /* synthetic */ String get$default(EncryptedPreferences encryptedPreferences2, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return encryptedPreferences2.get(string, string2);
    }

    public final synchronized void set(@NotNull String key, boolean value) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit$iv = this.getEncryptedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$set_u24lambda_u2d3 = editor;
        boolean bl = false;
        $this$set_u24lambda_u2d3.putBoolean(key, value);
        editor$iv.apply();
    }

    public final synchronized boolean get(@NotNull String key, boolean defaultValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getEncryptedPreferences().getBoolean(key, defaultValue);
    }

    public static /* synthetic */ boolean get$default(EncryptedPreferences encryptedPreferences2, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return encryptedPreferences2.get(string, bl);
    }

    public final void del(@NotNull String key) {
        SharedPreferences.Editor editor$iv;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        SharedPreferences $this$edit$iv = this.getEncryptedPreferences();
        boolean commit$iv = false;
        boolean $i$f$edit = false;
        SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        SharedPreferences.Editor $this$del_u24lambda_u2d4 = editor;
        boolean bl = false;
        $this$del_u24lambda_u2d4.remove(key);
        editor$iv.apply();
    }

    /*
     * WARNING - void declaration
     */
    private final void migration() {
        CharSequence charSequence = NidOAuthPreferencesManager.getClientId();
        if (!(charSequence == null || charSequence.length() == 0)) {
            return;
        }
        Context context = EncryptedPreferences.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        SharedPreferences oldPreference = context.getSharedPreferences(OLD_OAUTH_LOGIN_PREF_NAME, 0);
        try {
            SharedPreferences sharedPreferences = oldPreference;
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"oldPreference");
            this.moveToData(sharedPreferences);
        }
        catch (SecurityException e) {
            Context context2 = EncryptedPreferences.context;
            if (context2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context2 = null;
            }
            SharedPreferences sharedPreferences = oldPreference = EncryptedSharedPreferences.create((Context)context2, (String)OLD_OAUTH_LOGIN_PREF_NAME, (MasterKey)this.getMasterKey(), (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"oldPreference");
            this.moveToData(sharedPreferences);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            Context context3 = EncryptedPreferences.context;
            if (context3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context3 = null;
            }
            context3.deleteSharedPreferences(OLD_OAUTH_LOGIN_PREF_NAME);
        } else {
            void $this$edit$iv;
            SharedPreferences.Editor editor$iv;
            SharedPreferences e = oldPreference;
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"oldPreference");
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor editor = editor$iv = $this$edit$iv.edit();
            Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
            SharedPreferences.Editor $this$migration_u24lambda_u2d5 = editor;
            boolean bl = false;
            $this$migration_u24lambda_u2d5.clear();
            editor$iv.apply();
        }
    }

    private final void moveToData(SharedPreferences preferences) throws SecurityException {
        for (Map.Entry entry : preferences.getAll().entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            this.set(key, value);
        }
    }

    private final void set(String key, Object value) throws SecurityException {
        Object object = value;
        if (object instanceof Integer) {
            this.set(key, ((Number)value).intValue());
        } else if (object instanceof Long) {
            this.set(key, ((Number)value).longValue());
        } else {
            Object object2 = object;
            if (object2 == null ? true : object2 instanceof String) {
                this.set(key, (String)value);
            } else if (object instanceof Boolean) {
                this.set(key, (Boolean)value);
            } else {
                NidLog.d("EncryptedPreferences", Intrinsics.stringPlus((String)"Preferences Set() fail | key:", (Object)key));
            }
        }
    }

    public static final /* synthetic */ Context access$getContext$p() {
        return context;
    }

    public static final /* synthetic */ SharedPreferences access$init(EncryptedPreferences $this) {
        return $this.init();
    }

    static {
        masterKey$delegate = LazyKt.lazy((Function0)masterKey.2.INSTANCE);
        encryptedPreferences$delegate = LazyKt.lazy((Function0)encryptedPreferences.2.INSTANCE);
    }
}

