/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import androidx.appcompat.app.AppCompatActivity;
import com.navercorp.nid.NaverIdLoginSDK;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.oauth.NidOAuthBehavior;
import com.navercorp.nid.oauth.NidOAuthErrorCode;
import com.navercorp.nid.oauth.NidOAuthIntent;
import com.navercorp.nid.oauth.NidOAuthLogin;
import com.navercorp.nid.oauth.NidOAuthPreferencesManager;
import com.navercorp.nid.util.NidApplicationUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 *2\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0006H\u0002J \u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\"\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\u001e\u001a\u00020\nH\u0014J\b\u0010\u001f\u001a\u00020\nH\u0014J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010!\u001a\u00020\nH\u0014J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001dH\u0014J\u0010\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0015H\u0016J\b\u0010&\u001a\u00020\nH\u0002J\b\u0010'\u001a\u00020\nH\u0002J\b\u0010(\u001a\u00020\u0006H\u0002J\b\u0010)\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthBridgeActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "clientName", "", "isForceDestroyed", "", "isLoginActivityStarted", "isRotated", "finishWithErrorResult", "", "intent", "Landroid/content/Intent;", "errCode", "Lcom/navercorp/nid/oauth/NidOAuthErrorCode;", "initData", "oauthFinish", "errorCode", "errorDescription", "onActivityResult", "requestCode", "", "resultCode", "data", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onRestoreInstanceState", "onResume", "onSaveInstanceState", "outState", "setRequestedOrientation", "requestedOrientation", "startLoginActivity", "startLoginWebviewActivity", "tryOAuthByCustomTab", "tryOAuthByNaverapp", "Companion", "Nid-OAuth_release"})
public final class NidOAuthBridgeActivity
extends AppCompatActivity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String clientName;
    private boolean isForceDestroyed = true;
    private boolean isRotated;
    private boolean isLoginActivityStarted;
    @NotNull
    public static final String TAG = "NidOAuthBridgeActivity";
    private static final int REQUEST_CODE_LOGIN = 100;
    public static final int CUSTOM_TABS_LOGIN = -1;

    private final boolean initData() {
        CharSequence charSequence = NidOAuthPreferencesManager.getClientId();
        if (charSequence == null || charSequence.length() == 0) {
            this.finishWithErrorResult(NidOAuthErrorCode.CLIENT_ERROR_NO_CLIENTID);
            return false;
        }
        charSequence = NidOAuthPreferencesManager.getClientSecret();
        if (charSequence == null || charSequence.length() == 0) {
            this.finishWithErrorResult(NidOAuthErrorCode.CLIENT_ERROR_NO_CLIENTSECRET);
            return false;
        }
        charSequence = NidOAuthPreferencesManager.getClientName();
        if (charSequence == null || charSequence.length() == 0) {
            this.finishWithErrorResult(NidOAuthErrorCode.CLIENT_ERROR_NO_CLIENTNAME);
            return false;
        }
        charSequence = NidOAuthPreferencesManager.getCallbackUrl();
        if (charSequence == null || charSequence.length() == 0) {
            this.finishWithErrorResult(NidOAuthErrorCode.CLIENT_ERROR_NO_CALLBACKURL);
            return false;
        }
        String string = NidOAuthPreferencesManager.getClientName();
        Intrinsics.checkNotNull((Object)string);
        this.clientName = string;
        int screenOrientation = this.getIntent().getIntExtra("orientation", 1);
        this.setRequestedOrientation(screenOrientation);
        return true;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        NidLog.d(TAG, "called onCreate()");
        if (!this.initData()) {
            return;
        }
        if (savedInstanceState != null) {
            this.isLoginActivityStarted = savedInstanceState.getBoolean("IsLoginActivityStarted");
        }
        NidLog.d(TAG, Intrinsics.stringPlus((String)"onCreate() | isLoginActivityStarted : ", (Object)this.isLoginActivityStarted));
        this.isRotated = false;
        if (!this.isLoginActivityStarted) {
            this.isLoginActivityStarted = true;
            NidLog.d(TAG, "onCreate() first init.");
            this.startLoginActivity();
        }
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (Build.VERSION.SDK_INT != 26) {
            super.setRequestedOrientation(requestedOrientation);
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        NidLog.d(TAG, "called onConfigurationChanged()");
        this.isRotated = true;
    }

    protected void onDestroy() {
        super.onDestroy();
        NidLog.d(TAG, "called onDestroy()");
        if (this.isForceDestroyed && !this.isRotated) {
            NidOAuthPreferencesManager.setLastErrorCode(NidOAuthErrorCode.ACTIVITY_IS_SINGLE_TASK);
            NidOAuthPreferencesManager.setLastErrorDesc("OAuthLoginActivity is destroyed.");
            NaverIdLoginSDK.INSTANCE.getOauthLoginCallback().onError(-1, "OAuthLoginActivity is destroyed.");
        }
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        NidLog.d(TAG, "called onRestoreInstanceState()");
        this.isLoginActivityStarted = savedInstanceState.getBoolean("IsLoginActivityStarted");
        this.isForceDestroyed = savedInstanceState.getBoolean("isForceDestroyed");
        this.isRotated = savedInstanceState.getBoolean("isRotated");
        String state = savedInstanceState.getString("OAuthLoginData_state");
        CharSequence charSequence = state;
        if (charSequence == null || charSequence.length() == 0) {
            NidOAuthPreferencesManager.INSTANCE.setInitState(state);
        }
    }

    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        NidLog.d(TAG, "called onSaveInstanceState()");
        Bundle $this$onSaveInstanceState_u24lambda_u2d0 = bundle = outState;
        boolean bl = false;
        $this$onSaveInstanceState_u24lambda_u2d0.putBoolean("IsLoginActivityStarted", this.isLoginActivityStarted);
        $this$onSaveInstanceState_u24lambda_u2d0.putBoolean("isForceDestroyed", this.isForceDestroyed);
        $this$onSaveInstanceState_u24lambda_u2d0.putBoolean("isRotated", this.isRotated);
        $this$onSaveInstanceState_u24lambda_u2d0.putString("OAuthLoginData_state", NidOAuthPreferencesManager.INSTANCE.getInitState());
    }

    private final void startLoginActivity() {
        NidLog.d(TAG, "startLoginActivity()");
        switch (WhenMappings.$EnumSwitchMapping$0[NaverIdLoginSDK.INSTANCE.getBehavior().ordinal()]) {
            case 1: {
                if (!this.tryOAuthByNaverapp()) {
                    this.oauthFinish(new Intent(), NidOAuthErrorCode.ERROR_NO_CATAGORIZED, "\uae30\uae30\uc5d0 \ub124\uc774\ubc84\uc571\uc774 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                return;
            }
            case 2: {
                if (!this.tryOAuthByCustomTab()) {
                    if (NidApplicationUtil.INSTANCE.isNotCustomTabsAvailable((Context)this)) {
                        this.startLoginWebviewActivity();
                        return;
                    }
                    this.oauthFinish(new Intent(), NidOAuthErrorCode.ERROR_NO_CATAGORIZED, "\ucee4\uc2a4\ud140\ud0ed\uc744 \uc2e4\ud589\ud560 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4.");
                }
                return;
            }
            case 3: {
                this.startLoginWebviewActivity();
                return;
            }
            case 4: {
                if (this.tryOAuthByNaverapp()) {
                    return;
                }
                if (!this.tryOAuthByCustomTab()) break;
                return;
            }
        }
        this.startLoginWebviewActivity();
    }

    private final boolean tryOAuthByNaverapp() {
        boolean bl;
        Intent intent = new NidOAuthIntent.Builder((Context)this).setType(NidOAuthIntent.Type.NAVER_APP).build();
        if (intent == null) {
            bl = false;
        } else {
            this.startActivityForResult(intent, 100);
            bl = true;
        }
        return bl;
    }

    private final boolean tryOAuthByCustomTab() {
        boolean bl;
        Intent intent = new NidOAuthIntent.Builder((Context)this).setType(NidOAuthIntent.Type.CUSTOM_TABS).build();
        if (intent == null) {
            bl = false;
        } else {
            this.startActivityForResult(intent, -1);
            bl = true;
        }
        return bl;
    }

    private final void startLoginWebviewActivity() {
        Intent intent = new NidOAuthIntent.Builder((Context)this).setType(NidOAuthIntent.Type.WEB_VIEW).build();
        this.startActivityForResult(intent, 100);
    }

    protected void onResume() {
        super.onResume();
        NidLog.d(TAG, "called onResume()");
    }

    protected void onPause() {
        super.onPause();
        NidLog.d(TAG, "called onPause()");
    }

    private final void finishWithErrorResult(Intent intent) {
        String errorCode = intent.getStringExtra("oauth_error_code");
        String string = intent.getStringExtra("oauth_error_desc");
        if (string == null) {
            string = "";
        }
        String errorDesc = string;
        this.oauthFinish(intent, NidOAuthErrorCode.INSTANCE.fromString(errorCode), errorDesc);
    }

    private final void finishWithErrorResult(NidOAuthErrorCode errCode) {
        Intent intent;
        Intent $this$finishWithErrorResult_u24lambda_u2d1 = intent = new Intent();
        boolean bl = false;
        $this$finishWithErrorResult_u24lambda_u2d1.putExtra("oauth_error_code", errCode.getCode());
        $this$finishWithErrorResult_u24lambda_u2d1.putExtra("oauth_error_desc", errCode.getDescription());
        Intent intent2 = intent;
        this.oauthFinish(intent2, errCode, errCode.getDescription());
    }

    private final void oauthFinish(Intent intent, NidOAuthErrorCode errorCode, String errorDescription) {
        NidOAuthPreferencesManager.setLastErrorCode(errorCode);
        NidOAuthPreferencesManager.setLastErrorDesc(errorDescription);
        this.setResult(0, intent);
        this.finish();
        NaverIdLoginSDK.INSTANCE.getOauthLoginCallback().onError(-1, errorDescription);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        NidLog.d(TAG, "called onActivityResult()");
        this.isForceDestroyed = false;
        if (requestCode == -1 && resultCode == 0) {
            NidLog.d(TAG, "activity call by customtab");
            return;
        }
        if (data == null) {
            this.finishWithErrorResult(NidOAuthErrorCode.CLIENT_USER_CANCEL);
            return;
        }
        String state = data.getStringExtra("oauth_state");
        String code = data.getStringExtra("oauth_code");
        String errorCode = data.getStringExtra("oauth_error_code");
        String errorDescription = data.getStringExtra("oauth_error_desc");
        Object object = NidOAuthPreferencesManager.INSTANCE;
        NidOAuthPreferencesManager $this$onActivityResult_u24lambda_u2d2 = object;
        boolean bl = false;
        $this$onActivityResult_u24lambda_u2d2.setCode(code);
        $this$onActivityResult_u24lambda_u2d2.setState(state);
        $this$onActivityResult_u24lambda_u2d2.setErrorCode(errorCode);
        $this$onActivityResult_u24lambda_u2d2.setErrorDescription(errorDescription);
        object = code;
        if (object == null || object.length() == 0) {
            this.finishWithErrorResult(data);
        } else {
            new NidOAuthLogin().accessToken((Context)this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthBridgeActivity$Companion;", "", "()V", "CUSTOM_TABS_LOGIN", "", "REQUEST_CODE_LOGIN", "TAG", "", "Nid-OAuth_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NidOAuthBehavior.values().length];
            nArray[NidOAuthBehavior.NAVERAPP.ordinal()] = 1;
            nArray[NidOAuthBehavior.CUSTOMTABS.ordinal()] = 2;
            nArray[NidOAuthBehavior.WEBVIEW.ordinal()] = 3;
            nArray[NidOAuthBehavior.DEFAULT.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

