/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.provider.Settings;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.navercorp.nid.oauth.NidOAuthBridgeActivity;
import com.navercorp.nid.oauth.NidOAuthErrorCode;
import com.navercorp.nid.oauth.NidOAuthPreferencesManager;
import com.navercorp.nid.oauth.activity.NidOAuthCustomTabActivity;
import com.navercorp.nid.oauth.activity.NidOAuthWebViewActivity;
import com.navercorp.nid.util.NidApplicationUtil;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthIntent;", "", "()V", "Builder", "Companion", "Type", "Nid-OAuth_release"})
public final class NidOAuthIntent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String OAUTH_REQUEST_CLIENT_ID = "ClientId";
    @NotNull
    public static final String OAUTH_REQUEST_CALLBACK_URL = "ClientCallbackUrl";
    @NotNull
    public static final String OAUTH_REQUEST_INIT_STATE = "state";
    @NotNull
    public static final String OAUTH_REQUEST_CLIENT_NAME = "app_name";
    @NotNull
    public static final String OAUTH_REQUEST_SDK_VERSION = "oauth_sdk_version";
    @NotNull
    public static final String OAUTH_REQUEST_URL = "OAuthUrl";
    @NotNull
    public static final String OAUTH_REQUEST_AGREE_FROM_URL = "agreeFormUrl";
    @NotNull
    public static final String OAUTH_REQUEST_AGREE_FROM_CONTENT = "OAuthUrl";
    @NotNull
    public static final String OAUTH_RESULT_STATE = "oauth_state";
    @NotNull
    public static final String OAUTH_RESULT_CODE = "oauth_code";
    @NotNull
    public static final String OAUTH_RESULT_ACCESS_TOKEN = "oauth_at";
    @NotNull
    public static final String OAUTH_RESULT_ERROR_CODE = "oauth_error_code";
    @NotNull
    public static final String OAUTH_RESULT_ERROR_DESCRIPTION = "oauth_error_desc";

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthIntent$Companion;", "", "()V", "OAUTH_REQUEST_AGREE_FROM_CONTENT", "", "OAUTH_REQUEST_AGREE_FROM_URL", "OAUTH_REQUEST_CALLBACK_URL", "OAUTH_REQUEST_CLIENT_ID", "OAUTH_REQUEST_CLIENT_NAME", "OAUTH_REQUEST_INIT_STATE", "OAUTH_REQUEST_SDK_VERSION", "OAUTH_REQUEST_URL", "OAUTH_RESULT_ACCESS_TOKEN", "OAUTH_RESULT_CODE", "OAUTH_RESULT_ERROR_CODE", "OAUTH_RESULT_ERROR_DESCRIPTION", "OAUTH_RESULT_STATE", "Nid-OAuth_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthIntent$Type;", "", "(Ljava/lang/String;I)V", "NAVER_APP", "CUSTOM_TABS", "WEB_VIEW", "Nid-OAuth_release"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type NAVER_APP = new Type();
        public static final /* enum */ Type CUSTOM_TABS = new Type();
        public static final /* enum */ Type WEB_VIEW = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.NAVER_APP, Type.CUSTOM_TABS, Type.WEB_VIEW};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u0004\u0018\u00010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u0011\u001a\u00020\rH\u0002J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthIntent$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callbackUrl", "", "clientId", "clientName", "initState", "type", "Lcom/navercorp/nid/oauth/NidOAuthIntent$Type;", "build", "Landroid/content/Intent;", "getCustomTabsIntent", "getIntent", "getNaverAppIntent", "getWebViewIntent", "setType", "Nid-OAuth_release"})
    public static final class Builder {
        @NotNull
        private Context context;
        @Nullable
        private Type type;
        @Nullable
        private String clientId;
        @Nullable
        private String callbackUrl;
        @Nullable
        private String clientName;
        @Nullable
        private String initState;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.clientId = NidOAuthPreferencesManager.getClientId();
            this.callbackUrl = NidOAuthPreferencesManager.getCallbackUrl();
            this.clientName = NidOAuthPreferencesManager.getClientName();
            this.initState = NidOAuthPreferencesManager.INSTANCE.getInitState();
            this.context = context;
        }

        private final Intent getIntent() {
            Intent intent;
            Type type = this.type;
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    intent = this.getNaverAppIntent();
                    break;
                }
                case 2: {
                    intent = this.getCustomTabsIntent();
                    break;
                }
                case 3: {
                    intent = this.getWebViewIntent();
                    break;
                }
                default: {
                    intent = null;
                }
            }
            return intent;
        }

        private final Intent getNaverAppIntent() {
            Intent intent;
            if (NidApplicationUtil.INSTANCE.isNotExistIntentFilter(this.context, "com.nhn.android.search", "com.nhn.android.search.action.OAUTH2_LOGIN")) {
                intent = null;
            } else {
                Intent intent2;
                Intent $this$getNaverAppIntent_u24lambda_u2d0 = intent2 = new Intent();
                boolean bl = false;
                $this$getNaverAppIntent_u24lambda_u2d0.putExtra(NidOAuthIntent.OAUTH_REQUEST_CLIENT_ID, this.clientId);
                $this$getNaverAppIntent_u24lambda_u2d0.putExtra(NidOAuthIntent.OAUTH_REQUEST_CALLBACK_URL, this.callbackUrl);
                $this$getNaverAppIntent_u24lambda_u2d0.putExtra(NidOAuthIntent.OAUTH_REQUEST_CLIENT_NAME, this.clientName);
                $this$getNaverAppIntent_u24lambda_u2d0.putExtra(NidOAuthIntent.OAUTH_REQUEST_INIT_STATE, this.initState);
                $this$getNaverAppIntent_u24lambda_u2d0.putExtra(NidOAuthIntent.OAUTH_REQUEST_SDK_VERSION, "5.1.0");
                $this$getNaverAppIntent_u24lambda_u2d0.setPackage("com.nhn.android.search");
                $this$getNaverAppIntent_u24lambda_u2d0.setAction("com.nhn.android.search.action.OAUTH2_LOGIN");
                intent = intent2;
            }
            return intent;
        }

        private final Intent getCustomTabsIntent() {
            int flag = Settings.Global.getInt((ContentResolver)this.context.getContentResolver(), (String)"always_finish_activities", (int)0);
            if (flag == 1) {
                return null;
            }
            if (NidApplicationUtil.INSTANCE.isNotCustomTabsAvailable(this.context)) {
                return null;
            }
            Function1 listener2 = (Function1)new Function1<Intent, Unit>(this){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Unit invoke(@Nullable Intent intent) {
                    Unit unit;
                    if (intent == null) {
                        Intent newIntent = new Intent();
                        newIntent.putExtra("oauth_error_code", NidOAuthErrorCode.CLIENT_USER_CANCEL.getCode());
                        newIntent.putExtra("oauth_error_desc", NidOAuthErrorCode.CLIENT_USER_CANCEL.getDescription());
                        Context context = Builder.access$getContext$p(this.this$0);
                        NidOAuthBridgeActivity nidOAuthBridgeActivity = context instanceof NidOAuthBridgeActivity ? (NidOAuthBridgeActivity)context : null;
                        if (nidOAuthBridgeActivity == null) {
                            unit = null;
                        } else {
                            nidOAuthBridgeActivity.onActivityResult(-1, -1, newIntent);
                            unit = Unit.INSTANCE;
                        }
                    } else {
                        Context context = Builder.access$getContext$p(this.this$0);
                        NidOAuthBridgeActivity nidOAuthBridgeActivity = context instanceof NidOAuthBridgeActivity ? (NidOAuthBridgeActivity)context : null;
                        if (nidOAuthBridgeActivity == null) {
                            unit = null;
                        } else {
                            nidOAuthBridgeActivity.onActivityResult(-1, -1, intent);
                            unit = Unit.INSTANCE;
                        }
                    }
                    return unit;
                }
            };
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this.context);
            Intrinsics.checkNotNullExpressionValue((Object)localBroadcastManager, (String)"getInstance(context)");
            LocalBroadcastManager instance = localBroadcastManager;
            instance.registerReceiver(new BroadcastReceiver((Function1<? super Intent, Unit>)listener2, instance){
                final /* synthetic */ Function1<Intent, Unit> $listener;
                final /* synthetic */ LocalBroadcastManager $instance;
                {
                    this.$listener = $listener;
                    this.$instance = $instance;
                }

                public void onReceive(@NotNull Context context, @Nullable Intent intent) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    this.$listener.invoke((Object)intent);
                    this.$instance.unregisterReceiver((BroadcastReceiver)this);
                }
            }, new IntentFilter("ACTION_NAVER_3RDPARTY_CUSTOM_TAB"));
            LocalBroadcastManager $this$getCustomTabsIntent_u24lambda_u2d1 = localBroadcastManager = new Intent(this.context, NidOAuthCustomTabActivity.class);
            boolean bl = false;
            $this$getCustomTabsIntent_u24lambda_u2d1.putExtra(NidOAuthIntent.OAUTH_REQUEST_CLIENT_ID, this.clientId);
            $this$getCustomTabsIntent_u24lambda_u2d1.putExtra(NidOAuthIntent.OAUTH_REQUEST_CALLBACK_URL, this.callbackUrl);
            $this$getCustomTabsIntent_u24lambda_u2d1.putExtra(NidOAuthIntent.OAUTH_REQUEST_INIT_STATE, this.initState);
            $this$getCustomTabsIntent_u24lambda_u2d1.putExtra(NidOAuthIntent.OAUTH_REQUEST_SDK_VERSION, "5.1.0");
            $this$getCustomTabsIntent_u24lambda_u2d1.addFlags(65536);
            return localBroadcastManager;
        }

        private final Intent getWebViewIntent() {
            Intent intent;
            Intent $this$getWebViewIntent_u24lambda_u2d2 = intent = new Intent(this.context, NidOAuthWebViewActivity.class);
            boolean bl = false;
            $this$getWebViewIntent_u24lambda_u2d2.putExtra(NidOAuthIntent.OAUTH_REQUEST_CLIENT_ID, this.clientId);
            $this$getWebViewIntent_u24lambda_u2d2.putExtra(NidOAuthIntent.OAUTH_REQUEST_CALLBACK_URL, this.callbackUrl);
            $this$getWebViewIntent_u24lambda_u2d2.putExtra(NidOAuthIntent.OAUTH_REQUEST_INIT_STATE, this.initState);
            $this$getWebViewIntent_u24lambda_u2d2.putExtra(NidOAuthIntent.OAUTH_REQUEST_SDK_VERSION, "5.1.0");
            return intent;
        }

        @NotNull
        public final Builder setType(@NotNull Type type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            return this;
        }

        @Nullable
        public final Intent build() {
            if (this.type == null) {
                return null;
            }
            CharSequence charSequence = this.clientId;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            if (this.type == Type.NAVER_APP && ((charSequence = (CharSequence)this.clientName) == null || charSequence.length() == 0)) {
                return null;
            }
            charSequence = this.callbackUrl;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            charSequence = this.initState;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            return this.getIntent();
        }

        public static final /* synthetic */ Context access$getContext$p(Builder $this) {
            return $this.context;
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Type.values().length];
                nArray[Type.NAVER_APP.ordinal()] = 1;
                nArray[Type.CUSTOM_TABS.ordinal()] = 2;
                nArray[Type.WEB_VIEW.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

