/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth;

import android.media.UnsupportedSchemeException;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.oauth.EncryptedPreferences;
import com.navercorp.nid.oauth.NidOAuthErrorCode;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b.\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R.\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u0015\u0010\u0002\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R.\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u001b\u0010\u0002\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R.\u0010\u001e\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u0019R.\u0010\"\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b#\u0010\u0002\u001a\u0004\b$\u0010\u0017\"\u0004\b%\u0010\u0019R.\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b'\u0010\u0002\u001a\u0004\b(\u0010\u0017\"\u0004\b)\u0010\u0019R(\u0010*\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010\u0017\"\u0004\b,\u0010\u0019R(\u0010-\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010\u0017\"\u0004\b/\u0010\u0019R(\u00100\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010\u0017\"\u0004\b2\u0010\u0019R*\u00104\u001a\u0002032\u0006\u0010\u0013\u001a\u0002038F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b5\u0010\u0002\u001a\u0004\b6\u00107\"\u0004\b8\u00109R(\u0010:\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010\u0017\"\u0004\b<\u0010\u0019R*\u0010>\u001a\u00020=2\u0006\u0010\u0013\u001a\u00020=8F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\b?\u0010\u0002\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR.\u0010D\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bE\u0010\u0002\u001a\u0004\bF\u0010\u0017\"\u0004\bG\u0010\u0019R.\u0010H\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bI\u0010\u0002\u001a\u0004\bJ\u0010\u0017\"\u0004\bK\u0010\u0019R(\u0010L\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bM\u0010\u0017\"\u0004\bN\u0010\u0019R.\u0010O\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u00048F@FX\u0087\u000e\u00a2\u0006\u0012\u0012\u0004\bP\u0010\u0002\u001a\u0004\bQ\u0010\u0017\"\u0004\bR\u0010\u0019\u00a8\u0006S"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthPreferencesManager;", "", "()V", "ACCESS_TOKEN", "", "CALLBACK_URL", "CLIENT_ID", "CLIENT_NAME", "CLIENT_SECRET", "EXPIRES_AT", "LAST_ERROR_CODE", "LAST_ERROR_DESC", "OAUTH_CHECK_STATE", "OAUTH_CODE", "OAUTH_ERROR_CODE", "OAUTH_ERROR_DESCRIPTION", "OAUTH_INIT_STATE", "REFRESH_TOKEN", "TOKEN_TYPE", "value", "accessToken", "getAccessToken$annotations", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "callbackUrl", "getCallbackUrl$annotations", "getCallbackUrl", "setCallbackUrl", "clientId", "getClientId$annotations", "getClientId", "setClientId", "clientName", "getClientName$annotations", "getClientName", "setClientName", "clientSecret", "getClientSecret$annotations", "getClientSecret", "setClientSecret", "code", "getCode", "setCode", "errorCode", "getErrorCode", "setErrorCode", "errorDescription", "getErrorDescription", "setErrorDescription", "", "expiresAt", "getExpiresAt$annotations", "getExpiresAt", "()J", "setExpiresAt", "(J)V", "initState", "getInitState", "setInitState", "Lcom/navercorp/nid/oauth/NidOAuthErrorCode;", "lastErrorCode", "getLastErrorCode$annotations", "getLastErrorCode", "()Lcom/navercorp/nid/oauth/NidOAuthErrorCode;", "setLastErrorCode", "(Lcom/navercorp/nid/oauth/NidOAuthErrorCode;)V", "lastErrorDesc", "getLastErrorDesc$annotations", "getLastErrorDesc", "setLastErrorDesc", "refreshToken", "getRefreshToken$annotations", "getRefreshToken", "setRefreshToken", "state", "getState", "setState", "tokenType", "getTokenType$annotations", "getTokenType", "setTokenType", "Nid-OAuth_release"})
public final class NidOAuthPreferencesManager {
    @NotNull
    public static final NidOAuthPreferencesManager INSTANCE = new NidOAuthPreferencesManager();
    @NotNull
    private static final String ACCESS_TOKEN = "ACCESS_TOKEN";
    @NotNull
    private static final String REFRESH_TOKEN = "REFRESH_TOKEN";
    @NotNull
    private static final String EXPIRES_AT = "EXPIRES_AT";
    @NotNull
    private static final String CLIENT_ID = "CLIENT_ID";
    @NotNull
    private static final String CLIENT_SECRET = "CLIENT_SECRET";
    @NotNull
    private static final String CLIENT_NAME = "CLIENT_NAME";
    @NotNull
    private static final String CALLBACK_URL = "CALLBACK_URL";
    @NotNull
    private static final String TOKEN_TYPE = "TOKEN_TYPE";
    @NotNull
    private static final String LAST_ERROR_CODE = "LAST_ERROR_CODE";
    @NotNull
    private static final String LAST_ERROR_DESC = "LAST_ERROR_DESC";
    @NotNull
    private static final String OAUTH_INIT_STATE = "OAUTH_INIT_STATE";
    @NotNull
    private static final String OAUTH_CODE = "OAUTH_CODE";
    @NotNull
    private static final String OAUTH_CHECK_STATE = "OAUTH_CHECK_STATE";
    @NotNull
    private static final String OAUTH_ERROR_CODE = "OAUTH_ERROR_CODE";
    @NotNull
    private static final String OAUTH_ERROR_DESCRIPTION = "OAUTH_ERROR_DESCRIPTION";

    private NidOAuthPreferencesManager() {
    }

    @Nullable
    public static final String getAccessToken() {
        String token = EncryptedPreferences.INSTANCE.get(ACCESS_TOKEN, null);
        CharSequence charSequence = token;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        if (System.currentTimeMillis() / (long)1000 - INSTANCE.getExpiresAt() < 0L) {
            return token;
        }
        NidLog.i("OAuthLoginEncryptedPreferenceManager", "access token is expired.");
        return null;
    }

    public static final void setAccessToken(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(ACCESS_TOKEN, value);
    }

    @JvmStatic
    public static /* synthetic */ void getAccessToken$annotations() {
    }

    @Nullable
    public static final String getRefreshToken() {
        String token = EncryptedPreferences.INSTANCE.get(REFRESH_TOKEN, null);
        CharSequence charSequence = token;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        return token;
    }

    public static final void setRefreshToken(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(REFRESH_TOKEN, value);
    }

    @JvmStatic
    public static /* synthetic */ void getRefreshToken$annotations() {
    }

    public static final long getExpiresAt() {
        return EncryptedPreferences.INSTANCE.get(EXPIRES_AT, 0L);
    }

    public static final void setExpiresAt(long value) {
        EncryptedPreferences.INSTANCE.set(EXPIRES_AT, value);
    }

    @JvmStatic
    public static /* synthetic */ void getExpiresAt$annotations() {
    }

    @Nullable
    public static final String getClientId() {
        return EncryptedPreferences.INSTANCE.get(CLIENT_ID, null);
    }

    public static final void setClientId(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(CLIENT_ID, value);
    }

    @JvmStatic
    public static /* synthetic */ void getClientId$annotations() {
    }

    @Nullable
    public static final String getClientSecret() {
        return EncryptedPreferences.INSTANCE.get(CLIENT_SECRET, null);
    }

    public static final void setClientSecret(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(CLIENT_SECRET, value);
    }

    @JvmStatic
    public static /* synthetic */ void getClientSecret$annotations() {
    }

    @Nullable
    public static final String getClientName() {
        return EncryptedPreferences.INSTANCE.get(CLIENT_NAME, null);
    }

    public static final void setClientName(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(CLIENT_NAME, value);
    }

    @JvmStatic
    public static /* synthetic */ void getClientName$annotations() {
    }

    @Nullable
    public static final String getCallbackUrl() {
        return EncryptedPreferences.INSTANCE.get(CALLBACK_URL, null);
    }

    public static final void setCallbackUrl(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(CALLBACK_URL, value);
    }

    @JvmStatic
    public static /* synthetic */ void getCallbackUrl$annotations() {
    }

    @Nullable
    public static final String getTokenType() {
        return EncryptedPreferences.INSTANCE.get(TOKEN_TYPE, null);
    }

    public static final void setTokenType(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(TOKEN_TYPE, value);
    }

    @JvmStatic
    public static /* synthetic */ void getTokenType$annotations() {
    }

    @NotNull
    public static final NidOAuthErrorCode getLastErrorCode() {
        String string2 = EncryptedPreferences.INSTANCE.get(LAST_ERROR_CODE, null);
        if (string2 == null) {
            string2 = "";
        }
        String code = string2;
        return NidOAuthErrorCode.INSTANCE.fromString(code);
    }

    public static final void setLastErrorCode(@NotNull NidOAuthErrorCode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        EncryptedPreferences.INSTANCE.set(LAST_ERROR_CODE, value.getCode());
    }

    @JvmStatic
    public static /* synthetic */ void getLastErrorCode$annotations() {
    }

    @Nullable
    public static final String getLastErrorDesc() {
        return EncryptedPreferences.INSTANCE.get(LAST_ERROR_DESC, null);
    }

    public static final void setLastErrorDesc(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(LAST_ERROR_DESC, value);
    }

    @JvmStatic
    public static /* synthetic */ void getLastErrorDesc$annotations() {
    }

    @Nullable
    public final String getInitState() {
        String value = EncryptedPreferences.INSTANCE.get(OAUTH_INIT_STATE, null);
        if (value != null) {
            return value;
        }
        value = new BigInteger(130, new SecureRandom()).toString(32);
        try {
            String encoded;
            value = encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedSchemeException e) {
            NidLog.e("OAuthLoginEncryptedPreferenceManager", (Exception)((Object)e));
        }
        this.setInitState(value);
        return value;
    }

    public final void setInitState(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(OAUTH_INIT_STATE, value);
    }

    @Nullable
    public final String getCode() {
        return EncryptedPreferences.INSTANCE.get(OAUTH_CODE, null);
    }

    public final void setCode(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(OAUTH_CODE, value);
    }

    @Nullable
    public final String getState() {
        return EncryptedPreferences.INSTANCE.get(OAUTH_CHECK_STATE, null);
    }

    public final void setState(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(OAUTH_CHECK_STATE, value);
    }

    @Nullable
    public final String getErrorCode() {
        return EncryptedPreferences.INSTANCE.get(OAUTH_ERROR_CODE, null);
    }

    public final void setErrorCode(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(OAUTH_ERROR_CODE, value);
    }

    @Nullable
    public final String getErrorDescription() {
        return EncryptedPreferences.INSTANCE.get(OAUTH_ERROR_DESCRIPTION, null);
    }

    public final void setErrorDescription(@Nullable String value) {
        EncryptedPreferences.INSTANCE.set(OAUTH_ERROR_DESCRIPTION, value);
    }
}

