/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth;

import android.content.Context;
import com.navercorp.nid.NaverIdLoginSDK;
import com.navercorp.nid.oauth.NidOAuthPreferencesManager;
import com.navercorp.nid.util.NidDeviceUtil;
import com.navercorp.nid.util.NidNetworkUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00042\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthQuery;", "", "()V", "Builder", "Companion", "Method", "Nid-OAuth_release"})
public final class NidOAuthQuery {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String REQUEST_AUTHORIZE_URL = "https://nid.naver.com/oauth2.0/authorize?";

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthQuery$Method;", "", "(Ljava/lang/String;I)V", "CUSTOM_TABS", "WEB_VIEW", "Nid-OAuth_release"})
    public static final class Method
    extends Enum<Method> {
        public static final /* enum */ Method CUSTOM_TABS = new Method();
        public static final /* enum */ Method WEB_VIEW = new Method();
        private static final /* synthetic */ Method[] $VALUES;

        public static Method[] values() {
            return (Method[])$VALUES.clone();
        }

        public static Method valueOf(String value) {
            return Enum.valueOf(Method.class, value);
        }

        static {
            $VALUES = methodArray = new Method[]{Method.CUSTOM_TABS, Method.WEB_VIEW};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthQuery$Companion;", "", "()V", "REQUEST_AUTHORIZE_URL", "", "Nid-OAuth_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000e\u001a\u00020\u0006J\u0012\u0010\u000f\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\u0011\u001a\u00020\u0006H\u0002J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u0006H\u0002J\u001e\u0010\u0014\u001a\u00020\u00062\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/navercorp/nid/oauth/NidOAuthQuery$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "callbackUrl", "", "clientId", "locale", "method", "Lcom/navercorp/nid/oauth/NidOAuthQuery$Method;", "network", "state", "version", "build", "encode", "s", "generateCustomTabsOAuthQuery", "generateQuery", "generateWebViewOAuthQuery", "parametersToQuery", "parameters", "", "setMethod", "Nid-OAuth_release"})
    public static final class Builder {
        @Nullable
        private Method method;
        @Nullable
        private String clientId;
        @Nullable
        private String state;
        @Nullable
        private String callbackUrl;
        @NotNull
        private String locale;
        @NotNull
        private String network;
        @NotNull
        private String version;

        public Builder(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            this.clientId = NidOAuthPreferencesManager.getClientId();
            this.state = NidOAuthPreferencesManager.INSTANCE.getInitState();
            this.callbackUrl = NidOAuthPreferencesManager.getCallbackUrl();
            this.locale = NidDeviceUtil.INSTANCE.getLocale(context);
            this.network = NidNetworkUtil.INSTANCE.getType(context);
            this.version = "5.1.0";
        }

        @NotNull
        public final Builder setMethod(@NotNull Method method) {
            Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
            this.method = method;
            return this;
        }

        private final String generateQuery() {
            String string2;
            Method method = this.method;
            switch (method == null ? -1 : WhenMappings.$EnumSwitchMapping$0[method.ordinal()]) {
                case 1: {
                    string2 = this.generateCustomTabsOAuthQuery();
                    break;
                }
                case 2: {
                    string2 = this.generateWebViewOAuthQuery();
                    break;
                }
                default: {
                    string2 = this.generateWebViewOAuthQuery();
                }
            }
            return string2;
        }

        private final String generateCustomTabsOAuthQuery() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)this.clientId), TuplesKt.to((Object)"inapp_view", (Object)"custom_tab"), TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"oauth_os", (Object)"android"), TuplesKt.to((Object)"version", (Object)Intrinsics.stringPlus((String)"android-", (Object)this.version)), TuplesKt.to((Object)"locale", (Object)this.locale), TuplesKt.to((Object)"redirect_uri", (Object)this.callbackUrl), TuplesKt.to((Object)"state", (Object)this.state)};
            Map parameters = MapsKt.hashMapOf((Pair[])pairArray);
            parameters.put("network", this.network);
            if (NaverIdLoginSDK.INSTANCE.isRequiredCustomTabsReAuth()) {
                parameters.put("auth_type", "reauthenticate");
            }
            return Intrinsics.stringPlus((String)NidOAuthQuery.REQUEST_AUTHORIZE_URL, (Object)this.parametersToQuery(parameters));
        }

        private final String generateWebViewOAuthQuery() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)this.clientId), TuplesKt.to((Object)"inapp_view", (Object)"true"), TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"oauth_os", (Object)"android"), TuplesKt.to((Object)"version", (Object)Intrinsics.stringPlus((String)"android-", (Object)this.version)), TuplesKt.to((Object)"locale", (Object)this.locale), TuplesKt.to((Object)"redirect_uri", (Object)this.callbackUrl), TuplesKt.to((Object)"state", (Object)this.state)};
            Map parameters = MapsKt.hashMapOf((Pair[])pairArray);
            parameters.put("network", this.network);
            return Intrinsics.stringPlus((String)NidOAuthQuery.REQUEST_AUTHORIZE_URL, (Object)this.parametersToQuery(parameters));
        }

        private final String parametersToQuery(Map<String, String> parameters) {
            Set<String> keys = parameters.keySet();
            StringBuilder query = null;
            query = new StringBuilder();
            Iterable $this$forEach$iv = keys;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String key = (String)element$iv;
                boolean bl = false;
                String value = parameters.get(key);
                if (((CharSequence)query).length() > 0) {
                    query.append("&");
                }
                query.append(Intrinsics.stringPlus((String)key, (Object)"="));
                try {
                    query.append(this.encode(value));
                }
                catch (UnsupportedEncodingException e) {
                    query.append(value);
                }
            }
            String string2 = query.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"query.toString()");
            return string2;
        }

        private final String encode(String s) {
            String string2;
            if (s == null) {
                string2 = "";
            } else {
                String string3 = URLEncoder.encode(s, "UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"encode(s, \"UTF-8\")");
                string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"+", (String)"%20", (boolean)false, (int)4, null), (String)"*", (String)"%2A", (boolean)false, (int)4, null), (String)"%7E", (String)"~", (boolean)false, (int)4, null);
            }
            return string2;
        }

        @NotNull
        public final String build() {
            return this.generateQuery();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Method.values().length];
                nArray[Method.CUSTOM_TABS.ordinal()] = 1;
                nArray[Method.WEB_VIEW.ordinal()] = 2;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

