/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth.activity;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.AppCompatActivity;
import com.navercorp.nid.NaverIdLoginSDK;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.oauth.NidOAuthQuery;
import com.navercorp.nid.oauth.plugin.NidOAuthWebViewPlugin;
import com.navercorp.nid.oauth.view.DownloadBanner;
import com.navercorp.nid.scheme.api.NidSchemeApi;
import com.navercorp.nid.util.NidNetworkUtil;
import com.navercorp.nid.util.UserAgentFactory;
import com.nhn.android.oauth.R;
import com.nhn.android.oauth.databinding.ActivityOauthWebviewBinding;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\b\u0010\u001e\u001a\u00020\u001bH\u0002J\b\u0010\u001f\u001a\u00020\u001bH\u0002J\u0010\u0010 \u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0012\u0010$\u001a\u00020\u001b2\b\u0010%\u001a\u0004\u0018\u00010&H\u0014J\b\u0010'\u001a\u00020\u001bH\u0014J\b\u0010(\u001a\u00020\u001bH\u0014J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0014J\b\u0010*\u001a\u00020\u001bH\u0014J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020&H\u0014J\u0012\u0010-\u001a\u00020\u001b2\b\u0010.\u001a\u0004\u0018\u00010&H\u0002J\u0010\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/navercorp/nid/oauth/activity/NidOAuthWebViewActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "TAG", "", "alreadyExecutedBundleKey", "binding", "Lcom/nhn/android/oauth/databinding/ActivityOauthWebviewBinding;", "context", "Landroid/content/Context;", "downloadBanner", "Lcom/navercorp/nid/oauth/view/DownloadBanner;", "isAlreadyExecuted", "", "isVisibleDownloadBanner", "oauthUrlBundleKey", "progressBar", "Landroid/widget/ProgressBar;", "url", "visibleBannerBundleKey", "webView", "Landroid/webkit/WebView;", "wholeView", "Landroid/widget/LinearLayout;", "wholeViewHeight", "", "auth", "", "init", "initData", "initView", "initWebView", "isValidNidUrl", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onPause", "onRestoreInstanceState", "onResume", "onSaveInstanceState", "outState", "restoreActivity", "bundle", "setRequestedOrientation", "requestedOrientation", "Nid-OAuth_release"})
public final class NidOAuthWebViewActivity
extends AppCompatActivity {
    @NotNull
    private final String TAG;
    private Context context;
    private boolean isAlreadyExecuted;
    private ActivityOauthWebviewBinding binding;
    private int wholeViewHeight;
    private boolean isVisibleDownloadBanner = true;
    @Nullable
    private DownloadBanner downloadBanner;
    @Nullable
    private ProgressBar progressBar;
    @Nullable
    private String url;
    @Nullable
    private LinearLayout wholeView;
    @Nullable
    private WebView webView;
    @NotNull
    private final String alreadyExecutedBundleKey;
    @NotNull
    private final String oauthUrlBundleKey;
    @NotNull
    private final String visibleBannerBundleKey;

    public NidOAuthWebViewActivity() {
        this.TAG = "NidOAuthWebViewActivity";
        this.alreadyExecutedBundleKey = "alreadyExecutedBundleKey";
        this.oauthUrlBundleKey = "oauthUrlBundleKey";
        this.visibleBannerBundleKey = "visibleBannerBundleKey";
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivityOauthWebviewBinding activityOauthWebviewBinding = ActivityOauthWebviewBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)activityOauthWebviewBinding, (String)"inflate(layoutInflater)");
        this.binding = activityOauthWebviewBinding;
        this.requestWindowFeature(1);
        ActivityOauthWebviewBinding activityOauthWebviewBinding2 = this.binding;
        if (activityOauthWebviewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding2 = null;
        }
        this.setContentView((View)activityOauthWebviewBinding2.getRoot());
        this.init();
        this.restoreActivity(savedInstanceState);
    }

    private final void init() {
        this.context = (Context)this;
        this.initData();
        this.initView();
        this.initWebView();
    }

    private final void initData() {
        if (this.getIntent() == null) {
            return;
        }
        String authUrl = this.getIntent().getStringExtra("OAuthUrl");
        CharSequence charSequence = authUrl;
        this.url = !(charSequence == null || charSequence.length() == 0) && this.isValidNidUrl(authUrl) ? authUrl : new NidOAuthQuery.Builder((Context)this).setMethod(NidOAuthQuery.Method.WEB_VIEW).build();
        NidLog.d(this.TAG, Intrinsics.stringPlus((String)"initData() | url : ", (Object)this.url));
    }

    private final void initView() {
        ActivityOauthWebviewBinding activityOauthWebviewBinding;
        ActivityOauthWebviewBinding activityOauthWebviewBinding2;
        ActivityOauthWebviewBinding activityOauthWebviewBinding3;
        ActivityOauthWebviewBinding activityOauthWebviewBinding4 = this.binding;
        if (activityOauthWebviewBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding4 = null;
        }
        LinearLayout linearLayout = activityOauthWebviewBinding4.webviewNaviBar;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.webviewNaviBar");
        LinearLayout navigationBar = linearLayout;
        if (!NaverIdLoginSDK.INSTANCE.isShowBottomTab()) {
            navigationBar.setVisibility(8);
        }
        if ((activityOauthWebviewBinding3 = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding3 = null;
        }
        LinearLayout linearLayout2 = this.wholeView = activityOauthWebviewBinding3.wholeView;
        if (linearLayout2 != null) {
            LinearLayout it = linearLayout2;
            boolean bl = false;
            it.getViewTreeObserver().addOnGlobalLayoutListener(() -> NidOAuthWebViewActivity.initView$lambda-1$lambda-0(this, it, navigationBar));
        }
        if ((activityOauthWebviewBinding2 = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding2 = null;
        }
        LinearLayout $this$initView_u24lambda_u2d3 = linearLayout = activityOauthWebviewBinding2.webviewEndKey;
        boolean bl = false;
        $this$initView_u24lambda_u2d3.setClickable(true);
        $this$initView_u24lambda_u2d3.setOnClickListener(arg_0 -> NidOAuthWebViewActivity.initView$lambda-3$lambda-2(this, arg_0));
        ActivityOauthWebviewBinding activityOauthWebviewBinding5 = this.binding;
        if (activityOauthWebviewBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding5 = null;
        }
        this.downloadBanner = activityOauthWebviewBinding5.appDownloadBanner;
        if (NaverIdLoginSDK.INSTANCE.isShowMarketLink()) {
            DownloadBanner downloadBanner = this.downloadBanner;
            if (downloadBanner != null) {
                downloadBanner.setVisibility(0);
            }
        }
        if ((activityOauthWebviewBinding = this.binding) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding = null;
        }
        this.progressBar = activityOauthWebviewBinding.progressBar;
    }

    private final void initWebView() {
        ActivityOauthWebviewBinding activityOauthWebviewBinding = this.binding;
        if (activityOauthWebviewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            activityOauthWebviewBinding = null;
        }
        WebView webView = this.webView = activityOauthWebviewBinding.webView;
        if (webView != null) {
            WebView webView2;
            WebView $this$initWebView_u24lambda_u2d4 = webView2 = webView;
            boolean bl = false;
            $this$initWebView_u24lambda_u2d4.setVerticalScrollbarOverlay(true);
            $this$initWebView_u24lambda_u2d4.setHorizontalScrollbarOverlay(true);
        }
        WebView webView3 = this.webView;
        if (webView3 != null) {
            webView3.setWebViewClient(new WebViewClient(this){
                @Nullable
                private String preUrl;
                final /* synthetic */ NidOAuthWebViewActivity this$0;
                {
                    this.this$0 = $receiver;
                    this.preUrl = "";
                }

                @Nullable
                public final String getPreUrl() {
                    return this.preUrl;
                }

                public final void setPreUrl(@Nullable String string2) {
                    this.preUrl = string2;
                }

                public void onPageStarted(@NotNull WebView view, @NotNull String url, @Nullable Bitmap favicon) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    NidLog.d(NidOAuthWebViewActivity.access$getTAG$p(this.this$0), Intrinsics.stringPlus((String)"onPageStarted() | preUrl : ", (Object)this.preUrl));
                    NidLog.d(NidOAuthWebViewActivity.access$getTAG$p(this.this$0), Intrinsics.stringPlus((String)"onPageStarted() |    url : ", (Object)url));
                    if (NidOAuthWebViewPlugin.INSTANCE.isFinalUrl(true, this.preUrl, url)) {
                        WebView webView = NidOAuthWebViewActivity.access$getWebView$p(this.this$0);
                        if (webView != null) {
                            webView.stopLoading();
                        }
                        this.this$0.finish();
                        return;
                    }
                    Context context = NidOAuthWebViewActivity.access$getContext$p(this.this$0);
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                        context = null;
                    }
                    Intent intent = this.this$0.getIntent();
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                    if (NidOAuthWebViewPlugin.INSTANCE.isDoneAuthorization(context, this.preUrl, url, intent)) {
                        WebView webView = NidOAuthWebViewActivity.access$getWebView$p(this.this$0);
                        if (webView != null) {
                            webView.stopLoading();
                        }
                        return;
                    }
                    super.onPageStarted(view, url, favicon);
                    if (NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0) != null) {
                        ProgressBar progressBar = NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0);
                        Intrinsics.checkNotNull((Object)progressBar);
                        progressBar.setVisibility(0);
                    }
                }

                @RequiresApi(value=21)
                public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable WebResourceRequest request) {
                    WebResourceRequest webResourceRequest = request;
                    return this.shouldOverrideUrlLoading(view, String.valueOf(webResourceRequest == null ? null : webResourceRequest.getUrl()));
                }

                public boolean shouldOverrideUrlLoading(@Nullable WebView view, @Nullable String url) {
                    CharSequence charSequence;
                    if (NidOAuthWebViewPlugin.INSTANCE.isFinalUrl(false, this.preUrl, url)) {
                        WebView webView = NidOAuthWebViewActivity.access$getWebView$p(this.this$0);
                        if (webView != null) {
                            webView.stopLoading();
                        }
                        this.this$0.finish();
                        return true;
                    }
                    Context context = NidOAuthWebViewActivity.access$getContext$p(this.this$0);
                    if (context == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                        context = null;
                    }
                    Intent intent = this.this$0.getIntent();
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
                    if (NidOAuthWebViewPlugin.INSTANCE.isDoneAuthorization(context, this.preUrl, url, intent)) {
                        return true;
                    }
                    if (NidOAuthWebViewPlugin.INSTANCE.isNotInAppBrowserUrl(url)) {
                        Intent intent2 = new Intent("android.intent.action.VIEW");
                        intent2.setData(Uri.parse((String)url));
                        try {
                            this.this$0.startActivity(intent2);
                        }
                        catch (ActivityNotFoundException e) {
                            Context context2 = NidOAuthWebViewActivity.access$getContext$p(this.this$0);
                            if (context2 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                                context2 = null;
                            }
                            Toast.makeText((Context)context2, (int)R.string.naveroauthlogin_string_browser_app_issue, (int)0).show();
                        }
                        return true;
                    }
                    Uri uri = Uri.parse((String)url);
                    String scheme = uri.getScheme();
                    if (StringsKt.equals((String)"nidlogin", (String)scheme, (boolean)true)) {
                        try {
                            Intent intent3 = Intent.parseUri((String)url, (int)1);
                            if (intent3.resolveActivity(this.this$0.getPackageManager()) == null) {
                                StringBuilder builder;
                                CharSequence charSequence2 = builder = new StringBuilder();
                                NidOAuthWebViewActivity nidOAuthWebViewActivity = this.this$0;
                                StringBuilder $this$shouldOverrideUrlLoading_u24lambda_u2d0 = charSequence2;
                                boolean bl = false;
                                $this$shouldOverrideUrlLoading_u24lambda_u2d0.append("SchemeLogin failed in NaverIdLogin SDK");
                                $this$shouldOverrideUrlLoading_u24lambda_u2d0.append("\n");
                                $this$shouldOverrideUrlLoading_u24lambda_u2d0.append("Naverapp is not exist");
                                $this$shouldOverrideUrlLoading_u24lambda_u2d0.append("\n");
                                Context context3 = NidOAuthWebViewActivity.access$getContext$p(nidOAuthWebViewActivity);
                                if (context3 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                                    context3 = null;
                                }
                                $this$shouldOverrideUrlLoading_u24lambda_u2d0.append(UserAgentFactory.INSTANCE.create(context3));
                                NidSchemeApi nidSchemeApi = new NidSchemeApi();
                                Context context4 = NidOAuthWebViewActivity.access$getContext$p(this.this$0);
                                if (context4 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                                    context4 = null;
                                }
                                charSequence2 = builder.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)charSequence2, (String)"builder.toString()");
                                nidSchemeApi.requestSchemeLog(context4, (String)charSequence2);
                                return false;
                            }
                            this.this$0.startActivity(intent3);
                            return true;
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                    }
                    if (!((charSequence = (CharSequence)url) == null || charSequence.length() == 0)) {
                        WebView webView = view;
                        if (webView != null) {
                            webView.loadUrl(url);
                        }
                    }
                    this.preUrl = url;
                    return true;
                }

                public void onPageFinished(@NotNull WebView view, @Nullable String url) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    super.onPageFinished(view, url);
                    if (NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0) != null) {
                        ProgressBar progressBar = NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0);
                        Intrinsics.checkNotNull((Object)progressBar);
                        progressBar.setVisibility(8);
                    }
                    view.clearCache(true);
                }

                @RequiresApi(value=23)
                public void onReceivedError(@NotNull WebView view, @NotNull WebResourceRequest request, @NotNull WebResourceError error) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.onReceivedError(view, error.getErrorCode(), ((Object)error.getDescription()).toString(), request.getUrl().toString());
                }

                public void onReceivedError(@Nullable WebView view, int errorCode, @Nullable String description, @Nullable String failingUrl) {
                    Context context;
                    if (NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0) != null) {
                        ProgressBar progressBar = NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0);
                        Intrinsics.checkNotNull((Object)progressBar);
                        progressBar.setVisibility(8);
                    }
                    if ((context = NidOAuthWebViewActivity.access$getContext$p(this.this$0)) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                        context = null;
                    }
                    if (NidNetworkUtil.INSTANCE.isNotAvailable(context)) {
                        String string2 = this.this$0.getString(R.string.naveroauthlogin_string_network_state_not_available);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.naver\u2026work_state_not_available)");
                        String msg = string2;
                        Context context2 = NidOAuthWebViewActivity.access$getContext$p(this.this$0);
                        if (context2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                            context2 = null;
                        }
                        Toast.makeText((Context)context2, (CharSequence)msg, (int)1).show();
                        this.this$0.finish();
                        return;
                    }
                }
            });
        }
        WebView webView4 = this.webView;
        if (webView4 != null) {
            webView4.setWebChromeClient(new WebChromeClient(this){
                final /* synthetic */ NidOAuthWebViewActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onProgressChanged(@Nullable WebView view, int newProgress) {
                    if (NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0) != null) {
                        ProgressBar progressBar = NidOAuthWebViewActivity.access$getProgressBar$p(this.this$0);
                        Intrinsics.checkNotNull((Object)progressBar);
                        progressBar.setProgress(newProgress);
                    }
                }
            });
        }
        WebView webView5 = this.webView;
        if (webView5 != null) {
            webView5.setDownloadListener((arg_0, arg_1, arg_2, arg_3, arg_4) -> NidOAuthWebViewActivity.initWebView$lambda-5(this, arg_0, arg_1, arg_2, arg_3, arg_4));
        }
        WebView webView6 = this.webView;
        if (webView6 != null) {
            WebSettings webSettings = webView6.getSettings();
            if (webSettings != null) {
                WebSettings $this$initWebView_u24lambda_u2d6 = webSettings;
                boolean bl = false;
                $this$initWebView_u24lambda_u2d6.setJavaScriptEnabled(true);
                StringBuilder stringBuilder = new StringBuilder().append((Object)$this$initWebView_u24lambda_u2d6.getUserAgentString()).append(' ');
                Context context = this.context;
                if (context == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                    context = null;
                }
                $this$initWebView_u24lambda_u2d6.setUserAgentString(stringBuilder.append(UserAgentFactory.INSTANCE.create(context)).toString());
                $this$initWebView_u24lambda_u2d6.setAppCacheEnabled(false);
                $this$initWebView_u24lambda_u2d6.setCacheMode(2);
            }
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.webView != null) {
            WebView webView = this.webView;
            if (webView != null) {
                webView.resumeTimers();
            }
            WebView webView2 = this.webView;
            if (webView2 != null) {
                webView2.onResume();
            }
        }
        if (!this.isAlreadyExecuted) {
            this.isAlreadyExecuted = true;
            this.auth();
        }
    }

    protected void onPause() {
        super.onPause();
        WebView webView = this.webView;
        if (webView != null) {
            webView.onPause();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        WebView webView = this.webView;
        if (webView != null) {
            WebView it = webView;
            boolean bl = false;
            it.stopLoading();
            LinearLayout linearLayout = this.wholeView;
            if (linearLayout != null) {
                linearLayout.removeView((View)it);
            }
            it.clearCache(false);
            it.removeAllViews();
            it.destroy();
        }
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        this.wholeViewHeight = 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onSaveInstanceState(@NotNull Bundle outState) {
        Intrinsics.checkNotNullParameter((Object)outState, (String)"outState");
        super.onSaveInstanceState(outState);
        outState.putBoolean(this.alreadyExecutedBundleKey, this.isAlreadyExecuted);
        if (this.webView != null) {
            WebView webView = this.webView;
            if (webView != null) {
                webView.saveState(outState);
            }
        }
        outState.putString(this.oauthUrlBundleKey, this.url);
        if (this.isVisibleDownloadBanner && this.downloadBanner != null) {
            DownloadBanner downloadBanner = this.downloadBanner;
            Intrinsics.checkNotNull((Object)((Object)downloadBanner));
            if (downloadBanner.getVisibility() == 0) {
                outState.putBoolean(this.visibleBannerBundleKey, true);
                return;
            }
        }
        outState.putBoolean(this.visibleBannerBundleKey, false);
    }

    protected void onRestoreInstanceState(@NotNull Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)savedInstanceState, (String)"savedInstanceState");
        super.onRestoreInstanceState(savedInstanceState);
        this.restoreActivity(savedInstanceState);
    }

    private final void restoreActivity(Bundle bundle) {
        if (bundle == null) {
            return;
        }
        this.isAlreadyExecuted = bundle.getBoolean(this.alreadyExecutedBundleKey);
        if (this.webView != null) {
            WebView webView = this.webView;
            if (webView != null) {
                webView.restoreState(bundle);
            }
        }
        this.isVisibleDownloadBanner = bundle.getBoolean(this.visibleBannerBundleKey);
        this.url = bundle.getString(this.oauthUrlBundleKey);
    }

    private final void auth() {
        String webViewContent;
        CharSequence charSequence;
        NidLog.d(this.TAG, "called auth()");
        if (this.getIntent() == null) {
            return;
        }
        String agreeUrl = this.getIntent().getStringExtra("agreeFormUrl");
        CharSequence charSequence2 = agreeUrl;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            this.url = agreeUrl;
        }
        if ((charSequence = (CharSequence)(webViewContent = this.getIntent().getStringExtra("OAuthUrl"))) == null || charSequence.length() == 0) {
            NidLog.d(this.TAG, Intrinsics.stringPlus((String)"webview url : ", (Object)this.url));
            WebView webView = this.webView;
            if (webView != null) {
                String string2 = this.url;
                Intrinsics.checkNotNull((Object)string2);
                webView.loadUrl(string2);
            }
        } else {
            NidLog.d(this.TAG, Intrinsics.stringPlus((String)"webview url : ", (Object)this.url));
            NidLog.d(this.TAG, Intrinsics.stringPlus((String)"webview context : ", (Object)webViewContent));
            WebView webView = this.webView;
            if (webView != null) {
                String string3 = this.url;
                Intrinsics.checkNotNull((Object)string3);
                webView.loadDataWithBaseURL(string3, webViewContent, "text/html", null, null);
            }
        }
    }

    private final boolean isValidNidUrl(String url) {
        boolean isValid;
        block4: {
            isValid = false;
            try {
                URL u = new URL(url);
                String protocol = u.getProtocol();
                if (!StringsKt.equals((String)protocol, (String)"https", (boolean)true)) break block4;
                String host = u.getHost();
                if (!StringsKt.equals((String)host, (String)"nid.naver.com", (boolean)true)) {
                    Intrinsics.checkNotNullExpressionValue((Object)host, (String)"host");
                    if (!StringsKt.endsWith$default((String)host, (String)"nid.naver.com", (boolean)false, (int)2, null)) break block4;
                }
                isValid = true;
            }
            catch (MalformedURLException e) {
                isValid = false;
            }
        }
        return isValid;
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (Build.VERSION.SDK_INT != 26) {
            super.setRequestedOrientation(requestedOrientation);
        }
    }

    private static final void initView$lambda-1$lambda-0(NidOAuthWebViewActivity this$0, LinearLayout $it, LinearLayout $navigationBar) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        Intrinsics.checkNotNullParameter((Object)$navigationBar, (String)"$navigationBar");
        if (this$0.wholeViewHeight == 0) {
            this$0.wholeViewHeight = $it.getHeight();
        }
        if (this$0.wholeViewHeight > $it.getHeight() || !NaverIdLoginSDK.INSTANCE.isShowBottomTab()) {
            $navigationBar.setVisibility(8);
        } else {
            $navigationBar.setVisibility(0);
        }
    }

    private static final void initView$lambda-3$lambda-2(NidOAuthWebViewActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.finish();
    }

    private static final void initWebView$lambda-5(NidOAuthWebViewActivity this$0, String url, String $noName_1, String $noName_2, String mimetype, long $noName_4) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setDataAndType(Uri.parse((String)url), mimetype);
        try {
            this$0.startActivity(intent);
        }
        catch (Throwable t) {
            try {
                intent.setData(Uri.parse((String)url));
                this$0.startActivity(intent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static final /* synthetic */ String access$getTAG$p(NidOAuthWebViewActivity $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ WebView access$getWebView$p(NidOAuthWebViewActivity $this) {
        return $this.webView;
    }

    public static final /* synthetic */ Context access$getContext$p(NidOAuthWebViewActivity $this) {
        return $this.context;
    }

    public static final /* synthetic */ ProgressBar access$getProgressBar$p(NidOAuthWebViewActivity $this) {
        return $this.progressBar;
    }
}

