/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.oauth.plugin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.UriMatcher;
import android.net.Uri;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.oauth.NidOAuthErrorCode;
import com.navercorp.nid.oauth.NidOAuthPreferencesManager;
import com.navercorp.nid.oauth.plugin.NidOAuthWebViewPluginKt;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\tJ \u0010\u001d\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\tH\u0002J*\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\t2\u0006\u0010%\u001a\u00020&J\"\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\t2\b\u0010\u001f\u001a\u0004\u0018\u00010\tJ\u001a\u0010)\u001a\u00020!2\b\u0010$\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0010\u0010*\u001a\u00020!2\b\u0010\u001f\u001a\u0004\u0018\u00010\tJ\u0010\u0010+\u001a\u00020!2\b\u0010\u001f\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/navercorp/nid/oauth/plugin/NidOAuthWebViewPlugin;", "", "()V", "BLANK_URL", "", "CC_NAVER", "CR_NAVER", "EMPTY_URL", "HTTPS_FINAL_URL", "", "HTTP_FINAL_URL", "NID_DOMAIN", "NID_DOMAIN_ID", "NID_DOMAIN_JOIN", "NID_DOMAIN_LOGOUT", "NID_DOMAIN_PW", "OK_NAME", "SIREN", "SSO_CROSS_DOMAIN", "SSO_FINALIZE", "SSO_LOGOUT", "TAG", "VNO", "uriMatcher", "Landroid/content/UriMatcher;", "getUriMatcher", "()Landroid/content/UriMatcher;", "getDecodedString", "str", "getQueryMap", "", "url", "isDoneAuthorization", "", "context", "Landroid/content/Context;", "preUrl", "intent", "Landroid/content/Intent;", "isFinalUrl", "isShouldOverrideUrl", "isFinalUrlOnPageStarted", "isInAppBrowserUrl", "isNotInAppBrowserUrl", "Nid-OAuth_release"})
public final class NidOAuthWebViewPlugin {
    @NotNull
    public static final NidOAuthWebViewPlugin INSTANCE;
    @NotNull
    private static final String TAG = "NidOAuthWebViewPlugin";
    @NotNull
    private static final String HTTP_FINAL_URL = "http://nid.naver.com/com.nhn.login_global/inweb/finish";
    @NotNull
    private static final String HTTPS_FINAL_URL = "https://nid.naver.com/com.nhn.login_global/inweb/finish";
    private static final int EMPTY_URL = 10;
    private static final int BLANK_URL = 11;
    private static final int NID_DOMAIN = 20;
    private static final int NID_DOMAIN_ID = 21;
    private static final int NID_DOMAIN_PW = 22;
    private static final int NID_DOMAIN_JOIN = 23;
    private static final int NID_DOMAIN_LOGOUT = 24;
    private static final int SSO_LOGOUT = 30;
    private static final int SSO_CROSS_DOMAIN = 31;
    private static final int SSO_FINALIZE = 32;
    private static final int CC_NAVER = 40;
    private static final int CR_NAVER = 41;
    private static final int VNO = 50;
    private static final int OK_NAME = 51;
    private static final int SIREN = 52;
    @NotNull
    private static final UriMatcher uriMatcher;

    private NidOAuthWebViewPlugin() {
    }

    @NotNull
    public final UriMatcher getUriMatcher() {
        return uriMatcher;
    }

    public final boolean isFinalUrl(boolean isShouldOverrideUrl, @Nullable String preUrl, @Nullable String url) {
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        if (StringsKt.equals((String)url, (String)HTTP_FINAL_URL, (boolean)true) || StringsKt.equals((String)url, (String)HTTPS_FINAL_URL, (boolean)true) || StringsKt.equals((String)url, (String)"http://m.naver.com/", (boolean)true) || StringsKt.equals((String)url, (String)"http://m.naver.com", (boolean)true)) {
            return true;
        }
        return isShouldOverrideUrl ? StringsKt.startsWith$default((String)url, (String)"https://nid.naver.com/nidlogin.login?svctype=262144", (boolean)false, (int)2, null) : this.isFinalUrlOnPageStarted(preUrl, url);
    }

    private final boolean isFinalUrlOnPageStarted(String preUrl, String url) {
        if (NidOAuthWebViewPluginKt.startsWithout(url, "https://nid.naver.com/nidlogin.login?svctype=262144")) {
            return false;
        }
        CharSequence charSequence = preUrl;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return StringsKt.startsWith$default((String)preUrl, (String)"https://nid.naver.com/mobile/user/help/sleepId.nhn?m=viewSleepId&token_help=", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)preUrl, (String)"https://nid.naver.com/mobile/user/global/idSafetyRelease.nhn?", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)preUrl, (String)"https://nid.naver.com/mobile/user/help/idSafetyRelease.nhn?", (boolean)false, (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isDoneAuthorization(@NotNull Context context, @Nullable String preUrl, @Nullable String url, @NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        result = false;
        var6_6 = preUrl;
        if (var6_6 == null || var6_6.length() == 0) ** GOTO lbl-1000
        v0 = preUrl;
        Intrinsics.checkNotNull((Object)v0);
        if (!StringsKt.startsWith$default((String)v0, (String)"https://nid.naver.com/", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)preUrl, (String)"https://nid.naver.com/", (boolean)false, (int)2, null)) {
            NidLog.d("NidOAuthWebViewPlugin", "isDoneAuthorization - pre url is not naver.com");
        } else lbl-1000:
        // 2 sources

        {
            v1 = url;
            Intrinsics.checkNotNull((Object)v1);
            if (StringsKt.startsWith$default((String)v1, (String)"https://nid.naver.com/login/noauth/logout.nhn", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)url, (String)"http://nid.naver.com/nidlogin.logout", (boolean)false, (int)2, null)) {
                $this$isDoneAuthorization_u24lambda_u2d1 = var7_7 = (intent = new Intent());
                $i$a$-apply-NidOAuthWebViewPlugin$isDoneAuthorization$1 = false;
                $this$isDoneAuthorization_u24lambda_u2d1.putExtra("oauth_error_code", NidOAuthErrorCode.CLIENT_USER_CANCEL.getCode());
                $this$isDoneAuthorization_u24lambda_u2d1.putExtra("oauth_error_desc", NidOAuthErrorCode.CLIENT_USER_CANCEL.getDescription());
                ((Activity)context).setResult(-1, intent);
                ((Activity)context).finish();
                return true;
            }
            queryMap = null;
            queryMap = this.getQueryMap(url);
            var7_8 = queryMap;
            if (!(var7_8 == null || var7_8.isEmpty() != false) && queryMap.containsKey("code") && queryMap.containsKey("state")) {
                NidLog.d("NidOAuthWebViewPlugin", "query map contain code and state");
                result = true;
            } else {
                var7_8 = queryMap;
                if (!(var7_8 == null || var7_8.isEmpty() != false) && queryMap.containsKey("error") && queryMap.containsKey("error_description")) {
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"query map contain error, url : ", (Object)url));
                    result = true;
                    NidOAuthPreferencesManager.setLastErrorCode(NidOAuthErrorCode.INSTANCE.fromString(queryMap.get("error")));
                    v2 = this.getDecodedString(queryMap.get("error_description"));
                    Intrinsics.checkNotNull((Object)v2);
                    NidOAuthPreferencesManager.setLastErrorDesc(v2);
                } else {
                    uri = Uri.parse((String)url);
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"uri.getFragment : ", (Object)uri.getFragment()));
                    queryMap = this.getQueryMap(uri.getFragment());
                    if (queryMap != null && queryMap.containsKey("access_token") && queryMap.containsKey("state")) {
                        $this$isDoneAuthorization_u24lambda_u2d2 = $i$a$-apply-NidOAuthWebViewPlugin$isDoneAuthorization$1 = (intent = new Intent());
                        $i$a$-apply-NidOAuthWebViewPlugin$isDoneAuthorization$2 = false;
                        $this$isDoneAuthorization_u24lambda_u2d2.putExtra("oauth_at", queryMap.get("access_token"));
                        $this$isDoneAuthorization_u24lambda_u2d2.putExtra("oauth_state", queryMap.get("state"));
                        $this$isDoneAuthorization_u24lambda_u2d2.putExtra("oauth_error_code", queryMap.get("error"));
                        v3 = queryMap.get("error_description");
                        Intrinsics.checkNotNull((Object)v3);
                        $this$isDoneAuthorization_u24lambda_u2d2.putExtra("oauth_error_desc", NidOAuthWebViewPlugin.INSTANCE.getDecodedString(v3));
                        ((Activity)context).setResult(-1, intent);
                        ((Activity)context).finish();
                        return true;
                    }
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"query map does not contain code and state, url : ", (Object)url));
                }
            }
        }
        code = null;
        state = null;
        errorCode = null;
        errorDescription = null;
        if (result) {
            try {
                queryMap = this.getQueryMap(url);
                if (queryMap != null) {
                    code = queryMap.get("code");
                    state = queryMap.get("state");
                    errorCode = queryMap.get("error");
                    errorDescription = this.getDecodedString(queryMap.get("error_description"));
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"isDoneAuthorization() | code : ", (Object)code));
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"isDoneAuthorization() | state : ", (Object)state));
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"isDoneAuthorization() | errorCode : ", (Object)errorCode));
                    NidLog.d("NidOAuthWebViewPlugin", Intrinsics.stringPlus((String)"isDoneAuthorization() | errorDescription : ", (Object)errorDescription));
                }
                $this$isDoneAuthorization_u24lambda_u2d3 = var12_21 = (intent = new Intent());
                $i$a$-apply-NidOAuthWebViewPlugin$isDoneAuthorization$3 = false;
                $this$isDoneAuthorization_u24lambda_u2d3.putExtra("oauth_code", code);
                $this$isDoneAuthorization_u24lambda_u2d3.putExtra("oauth_state", NidOAuthPreferencesManager.INSTANCE.getInitState());
                $this$isDoneAuthorization_u24lambda_u2d3.putExtra("oauth_error_code", errorCode);
                $this$isDoneAuthorization_u24lambda_u2d3.putExtra("oauth_error_desc", errorDescription);
                ((Activity)context).setResult(-1, intent);
            }
            catch (MalformedURLException e) {
                $this$isDoneAuthorization_u24lambda_u2d4 = var12_22 = (intent = new Intent());
                $i$a$-apply-NidOAuthWebViewPlugin$isDoneAuthorization$4 = false;
                $this$isDoneAuthorization_u24lambda_u2d4.putExtra("oauth_error_code", errorCode);
                $this$isDoneAuthorization_u24lambda_u2d4.putExtra("oauth_error_desc", errorDescription);
                ((Activity)context).setResult(0, intent);
            }
            ((Activity)context).finish();
        }
        return result;
    }

    public final boolean isInAppBrowserUrl(@Nullable String url) {
        CharSequence charSequence = url;
        if (charSequence == null || charSequence.length() == 0 || url.contentEquals("about:blank")) {
            return true;
        }
        int match = uriMatcher.match(Uri.parse((String)url));
        switch (match) {
            case 21: 
            case 22: 
            case 23: {
                return false;
            }
        }
        return true;
    }

    public final boolean isNotInAppBrowserUrl(@Nullable String url) {
        return !this.isInAppBrowserUrl(url);
    }

    private final Map<String, String> getQueryMap(String url) {
        String[] $this$toTypedArray$iv;
        String query;
        block8: {
            NidLog.d(TAG, "called getQueryMap()");
            NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | url : ", (Object)url));
            CharSequence charSequence = url;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            query = null;
            try {
                query = new URL(url).getQuery();
            }
            catch (Exception e) {
                if (!StringsKt.contains$default((CharSequence)url, (CharSequence)"?", (boolean)false, (int)2, null)) break block8;
                Object object = url;
                Regex regex = new Regex("\\?");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$toTypedArray = false;
                String[] thisCollection$iv = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                query = stringArray[1];
            }
        }
        CharSequence e = query;
        if (e == null || e.length() == 0) {
            return null;
        }
        NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | query : ", (Object)query));
        $this$toTypedArray$iv = new String[]{"&"};
        List parameters = StringsKt.split$default((CharSequence)query, (String[])$this$toTypedArray$iv, (boolean)false, (int)0, (int)6, null);
        Map result = new HashMap();
        Iterable $this$forEach$iv = parameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String[] key;
            String it = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"="};
            Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)it, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv2;
            if (thisCollection$iv.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | key : ", (Object)key));
            if (key.length == 2) {
                NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | key[0] : ", (Object)key[0]));
                NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | key[1] : ", (Object)key[1]));
                result.put(key[0], key[1]);
                continue;
            }
            if (key.length != 1) continue;
            NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | key[0] : ", (Object)key[0]));
            result.put(key[0], "");
        }
        NidLog.d(TAG, Intrinsics.stringPlus((String)"getQueryMap() | result : ", (Object)result));
        return result;
    }

    @Nullable
    public final String getDecodedString(@Nullable String str) {
        NidLog.d(TAG, "called getDecodedString()");
        NidLog.d(TAG, Intrinsics.stringPlus((String)"getDecodedString() | str : ", (Object)str));
        CharSequence charSequence = str;
        if (charSequence == null || charSequence.length() == 0) {
            return str;
        }
        String decoded = URLDecoder.decode(str, "UTF-8");
        CharSequence charSequence2 = decoded;
        if (!(charSequence2 == null || charSequence2.length() == 0) && !StringsKt.equals((String)decoded, (String)str, (boolean)true)) {
            return decoded;
        }
        return str;
    }

    static {
        UriMatcher uriMatcher;
        INSTANCE = new NidOAuthWebViewPlugin();
        NidOAuthWebViewPlugin.uriMatcher = new UriMatcher(-1);
        UriMatcher $this$_init__u24lambda_u2d0 = uriMatcher = NidOAuthWebViewPlugin.uriMatcher;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.addURI("nid.naver.com", "mobile/user/help/idInquiry.nhn", 21);
        $this$_init__u24lambda_u2d0.addURI("nid.naver.com", "mobile/user/help/pwInquiry.nhn", 22);
        $this$_init__u24lambda_u2d0.addURI("nid.naver.com", "user2/V2Join.nhn", 23);
        $this$_init__u24lambda_u2d0.addURI("nid.naver.com", "nidlogin.logout", 24);
        $this$_init__u24lambda_u2d0.addURI("*", "/sso/logout.nhn", 30);
        $this$_init__u24lambda_u2d0.addURI("*", "/sso/cross-domain.nhn", 31);
        $this$_init__u24lambda_u2d0.addURI("*", "/sso/finalize.nhn", 32);
        $this$_init__u24lambda_u2d0.addURI("cc.naver.com", "*", 40);
        $this$_init__u24lambda_u2d0.addURI("cr.naver.com", "*", 41);
        $this$_init__u24lambda_u2d0.addURI("cert.vno.co.kr", "*", 50);
        $this$_init__u24lambda_u2d0.addURI("ipin.ok-name.co.kr", "*", 51);
        $this$_init__u24lambda_u2d0.addURI("ipin.siren24.com", "*", 52);
    }
}

