/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.progress;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.Window;
import androidx.appcompat.app.AppCompatDialog;
import androidx.appcompat.widget.AppCompatTextView;
import com.airbnb.lottie.LottieAnimationView;
import com.nhn.android.oauth.R;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/navercorp/nid/progress/NidProgressDialog;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "animation", "Lcom/airbnb/lottie/LottieAnimationView;", "dialog", "Landroidx/appcompat/app/AppCompatDialog;", "message", "Landroidx/appcompat/widget/AppCompatTextView;", "hideProgress", "", "init", "cancelListener", "Landroid/content/DialogInterface$OnCancelListener;", "showProgress", "resourceId", "", "msg", "", "Nid-OAuth_release"})
public final class NidProgressDialog {
    @NotNull
    private Context context;
    @NotNull
    private AppCompatDialog dialog;
    @Nullable
    private AppCompatTextView message;
    @Nullable
    private LottieAnimationView animation;

    public NidProgressDialog(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.dialog = new AppCompatDialog(context);
        this.init(null);
    }

    private final void init(DialogInterface.OnCancelListener cancelListener) {
        this.dialog.setCancelable(true);
        Window window = this.dialog.getWindow();
        if (window != null) {
            window.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        }
        this.dialog.setContentView(R.layout.nid_progress_dialog);
        this.message = (AppCompatTextView)this.dialog.findViewById(R.id.nid_progress_dialog_message);
        this.animation = (LottieAnimationView)this.dialog.findViewById(R.id.nid_progress_dialog_animation);
    }

    public final void showProgress(int resourceId) {
        String string2 = this.context.getResources().getString(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getString(resourceId)");
        this.showProgress(string2);
    }

    public final void showProgress(int resourceId, @Nullable DialogInterface.OnCancelListener cancelListener) {
        String string2 = this.context.getResources().getString(resourceId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getString(resourceId)");
        this.showProgress(string2, cancelListener);
    }

    public static /* synthetic */ void showProgress$default(NidProgressDialog nidProgressDialog, int n, DialogInterface.OnCancelListener onCancelListener, int n2, Object object) {
        if ((n2 & 2) != 0) {
            onCancelListener = null;
        }
        nidProgressDialog.showProgress(n, onCancelListener);
    }

    public final void showProgress(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.showProgress(msg, null);
    }

    public final void showProgress(@NotNull String msg, @Nullable DialogInterface.OnCancelListener cancelListener) {
        AppCompatTextView it;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        AppCompatTextView appCompatTextView = this.message;
        if (appCompatTextView != null) {
            it = appCompatTextView;
            boolean bl = false;
            it.setText((CharSequence)msg);
        }
        DialogInterface.OnCancelListener onCancelListener = cancelListener;
        if (onCancelListener != null) {
            it = onCancelListener;
            boolean bl = false;
            this.dialog.setOnCancelListener(cancelListener);
        }
        LottieAnimationView lottieAnimationView = this.animation;
        if (lottieAnimationView != null) {
            lottieAnimationView.playAnimation();
        }
        this.dialog.show();
    }

    public static /* synthetic */ void showProgress$default(NidProgressDialog nidProgressDialog, String string2, DialogInterface.OnCancelListener onCancelListener, int n, Object object) {
        if ((n & 2) != 0) {
            onCancelListener = null;
        }
        nidProgressDialog.showProgress(string2, onCancelListener);
    }

    public final void hideProgress() {
        if (this.dialog.isShowing()) {
            LottieAnimationView lottieAnimationView = this.animation;
            if (lottieAnimationView != null) {
                lottieAnimationView.pauseAnimation();
            }
            this.dialog.dismiss();
        }
    }
}

