/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.util;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import com.navercorp.nid.log.NidLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/navercorp/nid/util/NidApplicationUtil;", "", "()V", "TAG", "", "getCustomTabsPackageList", "", "Landroid/content/pm/PackageInfo;", "context", "Landroid/content/Context;", "isCustomTabsAvailable", "", "isExistApplication", "packageName", "isExistChromeApp", "isExistIntentFilter", "intentName", "isExistNaverApp", "isNotCustomTabsAvailable", "isNotExistIntentFilter", "Nid-OAuth_release"})
public final class NidApplicationUtil {
    @NotNull
    public static final NidApplicationUtil INSTANCE = new NidApplicationUtil();
    @NotNull
    public static final String TAG = "NidApplicationUtil";

    private NidApplicationUtil() {
    }

    public final boolean isExistNaverApp(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isExistApplication(context, "com.nhn.android.search");
    }

    public final boolean isExistChromeApp(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isExistApplication(context, "com.android.chrome");
    }

    public final boolean isExistApplication(@NotNull Context context, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        return intent != null;
    }

    public final boolean isExistIntentFilter(@NotNull Context context, @NotNull String packageName, @NotNull String intentName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)intentName, (String)"intentName");
        List list = context.getPackageManager().queryIntentActivities(new Intent(intentName), 128);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"context.packageManager.q\u2026r.GET_META_DATA\n        )");
        List resolveInfoList = list;
        Iterable $this$forEach$iv = resolveInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolveInfo it = (ResolveInfo)element$iv;
            boolean bl = false;
            NidLog.d(TAG, Intrinsics.stringPlus((String)"intent filter name : ", (Object)intentName));
            NidLog.d(TAG, Intrinsics.stringPlus((String)"resolveInfo.activityInfo.packageName : ", (Object)it.activityInfo.packageName));
            if (!StringsKt.equals((String)it.activityInfo.packageName, (String)packageName, (boolean)true)) continue;
            return true;
        }
        return false;
    }

    public final boolean isNotExistIntentFilter(@NotNull Context context, @NotNull String packageName, @NotNull String intentName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)intentName, (String)"intentName");
        return !this.isExistIntentFilter(context, packageName, intentName);
    }

    private final List<PackageInfo> getCustomTabsPackageList(Context context) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        List list = packageManager.queryIntentActivities(intent, 0);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"packageManager.queryIntentActivities(intent, 0)");
        List resolvedActivityList = list;
        List customTabsPackageList = new ArrayList();
        Iterable $this$forEach$iv = resolvedActivityList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Intent intent2;
            Intent intent3;
            ResolveInfo it = (ResolveInfo)element$iv;
            boolean bl = false;
            Intent $this$getCustomTabsPackageList_u24lambda_u2d2_u24lambda_u2d1 = intent3 = (intent2 = new Intent());
            boolean bl2 = false;
            $this$getCustomTabsPackageList_u24lambda_u2d2_u24lambda_u2d1.setAction("android.support.customtabs.action.CustomTabsService");
            $this$getCustomTabsPackageList_u24lambda_u2d2_u24lambda_u2d1.setPackage(it.activityInfo.packageName);
            NidLog.d(TAG, Intrinsics.stringPlus((String)"getCustomTabsPackageList : ", (Object)it.activityInfo.packageName));
            if (packageManager.resolveService(intent2, 0) == null) continue;
            try {
                $this$getCustomTabsPackageList_u24lambda_u2d2_u24lambda_u2d1 = packageManager.getApplicationInfo(it.activityInfo.packageName, 0);
                Intrinsics.checkNotNullExpressionValue((Object)$this$getCustomTabsPackageList_u24lambda_u2d2_u24lambda_u2d1, (String)"packageManager.getApplic\u2026ivityInfo.packageName, 0)");
                Intent applicationInfo = $this$getCustomTabsPackageList_u24lambda_u2d2_u24lambda_u2d1;
                if (!applicationInfo.enabled) continue;
                PackageInfo packageInfo = packageManager.getPackageInfo(it.activityInfo.packageName, 0);
                Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"packageInfo");
                customTabsPackageList.add(packageInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                NidLog.d(TAG, (Exception)((Object)e));
            }
        }
        return customTabsPackageList;
    }

    public final boolean isCustomTabsAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<PackageInfo> customTabsPackageList = this.getCustomTabsPackageList(context);
        return !((Collection)customTabsPackageList).isEmpty();
    }

    public final boolean isNotCustomTabsAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return !this.isCustomTabsAvailable(context);
    }
}

