/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.util;

import android.content.Context;
import android.os.Build;
import java.net.URLEncoder;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000b"}, d2={"Lcom/navercorp/nid/util/NidDeviceUtil;", "", "()V", "getLocale", "", "context", "Landroid/content/Context;", "getSystemLocale", "Ljava/util/Locale;", "isKorean", "", "Nid-OAuth_release"})
public final class NidDeviceUtil {
    @NotNull
    public static final NidDeviceUtil INSTANCE = new NidDeviceUtil();

    private NidDeviceUtil() {
    }

    @NotNull
    public final Locale getSystemLocale(@NotNull Context context) {
        Locale locale;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT >= 24) {
            Locale locale2 = context.getResources().getConfiguration().getLocales().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n            context.re\u2026.locales.get(0)\n        }");
            locale = locale2;
        } else {
            Locale locale3 = context.getResources().getConfiguration().locale;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n            context.re\u2026guration.locale\n        }");
            locale = locale3;
        }
        return locale;
    }

    @NotNull
    public final String getLocale(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Locale systemLocale = this.getSystemLocale(context);
        String string2 = systemLocale.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemLocale.toString()");
        if (((CharSequence)string2).length() == 0) {
            return "ko_KR";
        }
        String string3 = systemLocale.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"systemLocale.toString()");
        String locale = string3;
        String encodedLocale = URLEncoder.encode(locale, "utf-8");
        if (!StringsKt.equals((String)locale, (String)encodedLocale, (boolean)true)) {
            locale = systemLocale.getLanguage() + '_' + systemLocale.getCountry();
        }
        return locale;
    }

    public final boolean isKorean(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string2 = this.getSystemLocale(context).getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSystemLocale(context).language");
        return StringsKt.startsWith$default((String)string2, (String)"ko", (boolean)false, (int)2, null);
    }
}

