/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.util;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Build;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lcom/navercorp/nid/util/NidNetworkUtil;", "", "()V", "getType", "", "context", "Landroid/content/Context;", "isAvailable", "", "isConnected", "connectType", "", "isNotAvailable", "Nid-OAuth_release"})
public final class NidNetworkUtil {
    @NotNull
    public static final NidNetworkUtil INSTANCE = new NidNetworkUtil();

    private NidNetworkUtil() {
    }

    @NotNull
    public final String getType(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String networkType = "other";
        if (this.isConnected(context, 0)) {
            networkType = "cell";
        } else if (this.isConnected(context, 1)) {
            networkType = "wifi";
        }
        return networkType;
    }

    public final boolean isAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager manager = (ConnectivityManager)object;
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info != null && info.isConnected();
    }

    public final boolean isNotAvailable(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return !this.isAvailable(context);
    }

    private final boolean isConnected(Context context, int connectType) {
        Object object = context.getSystemService("connectivity");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        ConnectivityManager manager = (ConnectivityManager)object;
        if (Build.VERSION.SDK_INT < 23) {
            NetworkInfo networkInfo = manager.getNetworkInfo(connectType);
            if (networkInfo != null && networkInfo.isConnected()) {
                return true;
            }
        } else {
            Network[] networks;
            Network[] networkArray = manager.getAllNetworks();
            Intrinsics.checkNotNullExpressionValue((Object)networkArray, (String)"manager.allNetworks");
            Network[] $this$forEach$iv = networks = networkArray;
            boolean $i$f$forEach = false;
            for (Network element$iv : $this$forEach$iv) {
                Network it = element$iv;
                boolean bl = false;
                NetworkInfo info = manager.getNetworkInfo(it);
                if (info == null || info.getType() != connectType || !info.isConnected()) continue;
                return true;
            }
        }
        return false;
    }
}

