/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.nid.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.navercorp.nid.log.NidLog;
import com.navercorp.nid.util.UserAgentFactoryKt;
import com.nhn.android.naverlogin.OAuthLogin;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/navercorp/nid/util/UserAgentFactory;", "", "()V", "TAG", "", "create", "context", "Landroid/content/Context;", "generateAppInfo", "Nid-OAuth_release"})
public final class UserAgentFactory {
    @NotNull
    public static final UserAgentFactory INSTANCE = new UserAgentFactory();
    @NotNull
    private static final String TAG = "UserAgentFactory";

    private UserAgentFactory() {
    }

    @NotNull
    public final String create(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String versionInfo = UserAgentFactoryKt.refine(Intrinsics.stringPlus((String)"Android/", (Object)Build.VERSION.RELEASE));
        String modelInfo = UserAgentFactoryKt.refine(Intrinsics.stringPlus((String)"Model/", (Object)Build.MODEL));
        String appInfo = this.generateAppInfo(context);
        CharSequence charSequence = appInfo;
        if (charSequence == null || charSequence.length() == 0) {
            return versionInfo + ' ' + modelInfo;
        }
        String sdkInfo = UserAgentFactoryKt.refine(Intrinsics.stringPlus((String)"OAuthLoginMod/", (Object)OAuthLogin.getVersion()));
        return versionInfo + ' ' + modelInfo + ' ' + appInfo + ' ' + sdkInfo;
    }

    private final String generateAppInfo(Context context) {
        String appInfo = null;
        try {
            PackageManager packageManger = context.getPackageManager();
            PackageInfo packageInfo = packageManger.getPackageInfo(context.getPackageName(), 448);
            String appId = null;
            appId = "";
            CharSequence charSequence = packageInfo.applicationInfo.loadDescription(packageManger);
            if (charSequence != null) {
                CharSequence it = charSequence;
                boolean bl = false;
                appId = Intrinsics.stringPlus((String)",appId:", (Object)it);
            }
            appInfo = UserAgentFactoryKt.refine(context.getPackageName() + '/' + packageInfo.versionName + '(' + packageInfo.versionCode + ",uid:" + packageInfo.applicationInfo.uid + appId + ')');
        }
        catch (PackageManager.NameNotFoundException e) {
            appInfo = null;
            NidLog.e(TAG, (Exception)((Object)e));
        }
        return appInfo;
    }
}

