/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.jwt;

import com.nexmo.jwt.DateClaimDelegate;
import com.nexmo.jwt.JwtGenerator;
import com.nexmo.jwt.StringClaimDelegate;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002%&B+\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\"\u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020$H\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0014\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0015\u0010\tR\u001b\u0010\u0018\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0013\u001a\u0004\b\u0019\u0010\u0011R\u001b\u0010\u001b\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0013\u001a\u0004\b\u001c\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\tR\u001b\u0010\u001f\u001a\u00020\u00038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0017\u001a\u0004\b \u0010\t\u00a8\u0006'"}, d2={"Lcom/nexmo/jwt/Jwt;", "", "applicationId", "", "privateKeyContents", "claims", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "getApplicationId", "()Ljava/lang/String;", "getClaims", "()Ljava/util/Map;", "setClaims", "(Ljava/util/Map;)V", "expiresAt", "Ljava/time/ZonedDateTime;", "getExpiresAt", "()Ljava/time/ZonedDateTime;", "expiresAt$delegate", "Lcom/nexmo/jwt/DateClaimDelegate;", "id", "getId", "id$delegate", "Lcom/nexmo/jwt/StringClaimDelegate;", "issuedAt", "getIssuedAt", "issuedAt$delegate", "notBefore", "getNotBefore", "notBefore$delegate", "getPrivateKeyContents", "subject", "getSubject", "subject$delegate", "generate", "jwtGenerator", "Lcom/nexmo/jwt/JwtGenerator;", "Builder", "Companion", "jwt"})
public final class Jwt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final DateClaimDelegate issuedAt$delegate;
    @NotNull
    private final StringClaimDelegate id$delegate;
    @NotNull
    private final DateClaimDelegate notBefore$delegate;
    @NotNull
    private final DateClaimDelegate expiresAt$delegate;
    @NotNull
    private final StringClaimDelegate subject$delegate;
    @NotNull
    private final String applicationId;
    @NotNull
    private final String privateKeyContents;
    @NotNull
    private Map<String, ? extends Object> claims;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Jwt.class), "issuedAt", "getIssuedAt()Ljava/time/ZonedDateTime;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Jwt.class), "id", "getId()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Jwt.class), "notBefore", "getNotBefore()Ljava/time/ZonedDateTime;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Jwt.class), "expiresAt", "getExpiresAt()Ljava/time/ZonedDateTime;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(Jwt.class), "subject", "getSubject()Ljava/lang/String;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final ZonedDateTime getIssuedAt() {
        return this.issuedAt$delegate.getValue(this, $$delegatedProperties[0]);
    }

    @NotNull
    public final String getId() {
        return this.id$delegate.getValue(this, $$delegatedProperties[1]);
    }

    @NotNull
    public final ZonedDateTime getNotBefore() {
        return this.notBefore$delegate.getValue(this, $$delegatedProperties[2]);
    }

    @NotNull
    public final ZonedDateTime getExpiresAt() {
        return this.expiresAt$delegate.getValue(this, $$delegatedProperties[3]);
    }

    @NotNull
    public final String getSubject() {
        return this.subject$delegate.getValue(this, $$delegatedProperties[4]);
    }

    @JvmOverloads
    @NotNull
    public final String generate(@NotNull JwtGenerator jwtGenerator) {
        Intrinsics.checkParameterIsNotNull((Object)jwtGenerator, (String)"jwtGenerator");
        return jwtGenerator.generate(this);
    }

    @JvmOverloads
    @NotNull
    public static /* synthetic */ String generate$default(Jwt jwt, JwtGenerator jwtGenerator, int n, Object object) {
        if ((n & 1) != 0) {
            jwtGenerator = new JwtGenerator(null, 1, null);
        }
        return jwt.generate(jwtGenerator);
    }

    @JvmOverloads
    @NotNull
    public final String generate() {
        return Jwt.generate$default(this, null, 1, null);
    }

    @NotNull
    public final String getApplicationId() {
        return this.applicationId;
    }

    @NotNull
    public final String getPrivateKeyContents() {
        return this.privateKeyContents;
    }

    @NotNull
    public final Map<String, Object> getClaims() {
        return this.claims;
    }

    public final void setClaims(@NotNull Map<String, ? extends Object> map) {
        Intrinsics.checkParameterIsNotNull(map, (String)"<set-?>");
        this.claims = map;
    }

    private Jwt(String applicationId, String privateKeyContents, Map<String, ? extends Object> claims) {
        this.applicationId = applicationId;
        this.privateKeyContents = privateKeyContents;
        this.claims = claims;
        this.issuedAt$delegate = new DateClaimDelegate();
        this.id$delegate = new StringClaimDelegate();
        this.notBefore$delegate = new DateClaimDelegate();
        this.expiresAt$delegate = new DateClaimDelegate();
        this.subject$delegate = new StringClaimDelegate();
    }

    public /* synthetic */ Jwt(String applicationId, String privateKeyContents, Map claims, DefaultConstructorMarker $constructor_marker) {
        this(applicationId, privateKeyContents, claims);
    }

    @JvmStatic
    @NotNull
    public static final Builder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0001J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u0005\u001a\u00020\u00002\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0010J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0010J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/nexmo/jwt/Jwt$Builder;", "", "applicationId", "", "privateKeyContents", "claims", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;)V", "addClaim", "key", "value", "build", "Lcom/nexmo/jwt/Jwt;", "", "expiresAt", "exp", "Ljava/time/ZonedDateTime;", "id", "jti", "issuedAt", "iat", "notBefore", "nbf", "privateKeyPath", "Ljava/nio/file/Path;", "subject", "validate", "", "jwt"})
    public static final class Builder {
        private String applicationId;
        private String privateKeyContents;
        private Map<String, Object> claims;

        @NotNull
        public final Builder applicationId(@NotNull String applicationId) {
            Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.applicationId = applicationId;
            return builder;
        }

        @NotNull
        public final Builder privateKeyContents(@NotNull String privateKeyContents) {
            Intrinsics.checkParameterIsNotNull((Object)privateKeyContents, (String)"privateKeyContents");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.privateKeyContents = privateKeyContents;
            return builder;
        }

        @NotNull
        public final Builder privateKeyPath(@NotNull Path privateKeyPath) {
            Intrinsics.checkParameterIsNotNull((Object)privateKeyPath, (String)"privateKeyPath");
            byte[] byArray = Files.readAllBytes(privateKeyPath);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Files.readAllBytes(privateKeyPath)");
            byte[] byArray2 = byArray;
            Builder builder = this;
            boolean bl = false;
            String string = new String(byArray2, Charsets.UTF_8);
            return builder.privateKeyContents(string);
        }

        @NotNull
        public final Builder privateKeyPath(@NotNull String privateKeyPath) {
            Intrinsics.checkParameterIsNotNull((Object)privateKeyPath, (String)"privateKeyPath");
            Path path = Paths.get(privateKeyPath, new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"Paths.get(privateKeyPath)");
            return this.privateKeyPath(path);
        }

        @NotNull
        public final Builder claims(@NotNull Map<String, ? extends Object> claims) {
            Intrinsics.checkParameterIsNotNull(claims, (String)"claims");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.claims.putAll(claims);
            return builder;
        }

        @NotNull
        public final Builder addClaim(@NotNull String key, @NotNull Object value) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.claims.put(key, value);
            return builder;
        }

        @NotNull
        public final Builder issuedAt(@NotNull ZonedDateTime iat) {
            Intrinsics.checkParameterIsNotNull((Object)iat, (String)"iat");
            return this.addClaim("iat", iat);
        }

        @NotNull
        public final Builder id(@NotNull String jti) {
            Intrinsics.checkParameterIsNotNull((Object)jti, (String)"jti");
            return this.addClaim("jti", jti);
        }

        @NotNull
        public final Builder notBefore(@NotNull ZonedDateTime nbf) {
            Intrinsics.checkParameterIsNotNull((Object)nbf, (String)"nbf");
            return this.addClaim("nbf", nbf);
        }

        @NotNull
        public final Builder expiresAt(@NotNull ZonedDateTime exp) {
            Intrinsics.checkParameterIsNotNull((Object)exp, (String)"exp");
            return this.addClaim("exp", exp);
        }

        @NotNull
        public final Builder subject(@NotNull String subject) {
            Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
            return this.addClaim("sub", subject);
        }

        @NotNull
        public final Jwt build() {
            this.validate();
            return new Jwt(this.applicationId, this.privateKeyContents, this.claims, null);
        }

        private final void validate() {
            if (Intrinsics.areEqual((Object)this.applicationId, (Object)"") && Intrinsics.areEqual((Object)this.privateKeyContents, (Object)"")) {
                throw (Throwable)new IllegalStateException("Both an Application ID and Private Key are required.");
            }
            if (Intrinsics.areEqual((Object)this.applicationId, (Object)"")) {
                throw (Throwable)new IllegalStateException("Application ID is required.");
            }
            if (Intrinsics.areEqual((Object)this.privateKeyContents, (Object)"")) {
                throw (Throwable)new IllegalStateException("Private Key is required.");
            }
        }

        public Builder(@NotNull String applicationId, @NotNull String privateKeyContents, @NotNull Map<String, Object> claims) {
            Intrinsics.checkParameterIsNotNull((Object)applicationId, (String)"applicationId");
            Intrinsics.checkParameterIsNotNull((Object)privateKeyContents, (String)"privateKeyContents");
            Intrinsics.checkParameterIsNotNull(claims, (String)"claims");
            this.applicationId = applicationId;
            this.privateKeyContents = privateKeyContents;
            this.claims = claims;
        }

        public /* synthetic */ Builder(String string, String string2, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                boolean bl = false;
                map = new LinkedHashMap();
            }
            this(string, string2, map);
        }

        public Builder() {
            this(null, null, null, 7, null);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/nexmo/jwt/Jwt$Companion;", "", "()V", "builder", "Lcom/nexmo/jwt/Jwt$Builder;", "jwt"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final Builder builder() {
            return new Builder(null, null, null, 7, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

