/*
 * Decompiled with CFR 0.152.
 */
package com.nexmo.jwt;

import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/nexmo/jwt/KeyConverter;", "", "keyFactory", "Ljava/security/KeyFactory;", "(Ljava/security/KeyFactory;)V", "keySpec", "Ljava/security/spec/PKCS8EncodedKeySpec;", "key", "", "privateKey", "Ljava/security/interfaces/RSAPrivateKey;", "sanitize", "Companion", "jwt"})
public final class KeyConverter {
    private final KeyFactory keyFactory;
    private static final String PRIVATE_KEY_HEADER = "-----BEGIN PRIVATE KEY-----\n";
    private static final String PRIVATE_KEY_FOOTER = "-----END PRIVATE KEY-----";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final RSAPrivateKey privateKey(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        PrivateKey privateKey = this.keyFactory.generatePrivate(this.keySpec(this.sanitize(key)));
        if (privateKey == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.security.interfaces.RSAPrivateKey");
        }
        return (RSAPrivateKey)privateKey;
    }

    private final String sanitize(String key) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)key, (String)PRIVATE_KEY_HEADER, (String)"", (boolean)false, (int)4, null), (String)PRIVATE_KEY_FOOTER, (String)"", (boolean)false, (int)4, null);
        String string = "\\s";
        boolean bl = false;
        string = new Regex(string);
        String string2 = "";
        boolean bl2 = false;
        return string.replace(charSequence, string2);
    }

    private final PKCS8EncodedKeySpec keySpec(String key) {
        return new PKCS8EncodedKeySpec(Base64.getDecoder().decode(key));
    }

    public KeyConverter(@NotNull KeyFactory keyFactory) {
        Intrinsics.checkParameterIsNotNull((Object)keyFactory, (String)"keyFactory");
        this.keyFactory = keyFactory;
    }

    public /* synthetic */ KeyConverter(KeyFactory keyFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            KeyFactory keyFactory2 = KeyFactory.getInstance("RSA");
            Intrinsics.checkExpressionValueIsNotNull((Object)keyFactory2, (String)"KeyFactory.getInstance(\"RSA\")");
            keyFactory = keyFactory2;
        }
        this(keyFactory);
    }

    public KeyConverter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/nexmo/jwt/KeyConverter$Companion;", "", "()V", "PRIVATE_KEY_FOOTER", "", "PRIVATE_KEY_HEADER", "jwt"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

