/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.location;

import android.location.Location;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.util.concurrent.TimeUnit;

public final class LocationDescriptor
implements ProtobufMessage {
    private final long a;
    private final double b;
    private final double c;
    private final double d;
    private final float e;
    private final float f;
    private final float g;
    private final float h;

    public static LocationDescriptor of() {
        return new LocationDescriptor(0L, Double.NaN, Double.NaN, Double.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    }

    public static LocationDescriptor ofLocation(Location location) {
        LocationDescriptor locationDescriptor;
        long l2 = System.currentTimeMillis();
        int n2 = Build.VERSION.SDK_INT;
        long l3 = n2 >= 33 ? location.getElapsedRealtimeAgeMillis(SystemClock.elapsedRealtime()) : TimeUnit.NANOSECONDS.toMillis(SystemClock.elapsedRealtimeNanos() - location.getElapsedRealtimeNanos());
        Location location2 = location;
        l2 = TimeUnit.MILLISECONDS.toSeconds(l2 - l3);
        double d2 = location2.getLatitude();
        double d3 = location2.getLongitude();
        double d4 = location2.hasAltitude() ? location.getAltitude() : Double.NaN;
        float f2 = location.hasSpeed() ? location.getSpeed() : Float.NaN;
        float f3 = location.hasAccuracy() ? location.getAccuracy() : Float.NaN;
        float f4 = n2 >= 26 && location.hasVerticalAccuracy() ? location.getVerticalAccuracyMeters() : Float.NaN;
        float f5 = n2 >= 26 && location.hasSpeedAccuracy() ? location.getSpeedAccuracyMetersPerSecond() : Float.NaN;
        LocationDescriptor locationDescriptor2 = locationDescriptor;
        locationDescriptor2(l2, d2, d3, d4, f2, f3, f4, f5);
        return locationDescriptor2;
    }

    LocationDescriptor(long l2, double d2, double d3, double d4, float f2, float f3, float f4, float f5) {
        this.a = l2;
        this.b = d2;
        this.c = d3;
        this.d = d4;
        this.e = f2;
        this.f = f3;
        this.g = f4;
        this.h = f5;
    }

    @Override
    public LocationDescriptor mergeFrom(ProtobufReader protobufReader) {
        LocationDescriptor locationDescriptor = this;
        long l2 = locationDescriptor.a;
        double d2 = locationDescriptor.b;
        double d3 = locationDescriptor.c;
        double d4 = locationDescriptor.d;
        float f2 = locationDescriptor.e;
        float f3 = locationDescriptor.f;
        float f4 = locationDescriptor.g;
        float f5 = locationDescriptor.h;
        block10: while (protobufReader.hasRemaining()) {
            switch (protobufReader.readTag()) {
                default: {
                    protobufReader.readAndDiscard();
                    continue block10;
                }
                case 8: {
                    f5 = protobufReader.readFixedFloat();
                    continue block10;
                }
                case 7: {
                    f4 = protobufReader.readFixedFloat();
                    continue block10;
                }
                case 6: {
                    f3 = protobufReader.readFixedFloat();
                    continue block10;
                }
                case 5: {
                    f2 = protobufReader.readFixedFloat();
                    continue block10;
                }
                case 4: {
                    d4 = protobufReader.readFixedDouble();
                    continue block10;
                }
                case 3: {
                    d3 = protobufReader.readFixedDouble();
                    continue block10;
                }
                case 2: {
                    d2 = protobufReader.readFixedDouble();
                    continue block10;
                }
                case 1: 
            }
            l2 = protobufReader.readFixedLong();
        }
        return new LocationDescriptor(l2, d2, d3, d4, f2, f3, f4, f5);
    }

    @Override
    public void writeTo(ProtobufWriter protobufWriter) {
        long l2 = this.a;
        double d2 = this.b;
        ProtobufWriter protobufWriter2 = protobufWriter.writeFixedLong(1, l2).writeFixedDouble(2, d2);
        d2 = this.c;
        ProtobufWriter protobufWriter3 = protobufWriter2.writeFixedDouble(3, d2);
        d2 = this.d;
        protobufWriter3.writeFixedDouble(4, d2).writeFixedFloat(5, this.e).writeFixedFloat(6, this.f).writeFixedFloat(7, this.g).writeFixedFloat(8, this.h);
    }

    public long timestampSeconds() {
        return this.a;
    }

    public double latitudeDegrees() {
        return this.b;
    }

    public double longitudeDegrees() {
        return this.c;
    }

    public boolean hasHorizontal() {
        return !Double.isNaN(this.b) && !Double.isNaN(this.c);
    }

    public double altitudeMeters() {
        return this.d;
    }

    public boolean hasVertical() {
        return Double.isNaN(this.d) ^ true;
    }

    public float horizontalAccuracyMeters() {
        return this.f;
    }

    public boolean hasHorizontalAccuracy() {
        return Float.isNaN(this.f) ^ true;
    }

    public float verticalAccuracyMeters() {
        return this.g;
    }

    public boolean hasVerticalAccuracy() {
        return Float.isNaN(this.g) ^ true;
    }

    public float speedMetersPerSecond() {
        return this.e;
    }

    public boolean hasSpeed() {
        return Float.isNaN(this.e) ^ true;
    }

    public float speedAccuracyMetersPerSecond() {
        return this.h;
    }

    public boolean hasSpeedAccuracy() {
        return Float.isNaN(this.h) ^ true;
    }

    public int hashCode() {
        return Long.hashCode(this.a);
    }

    public boolean equals(@Nullable Object object) {
        if (!(object instanceof LocationDescriptor)) {
            return false;
        }
        object = (LocationDescriptor)object;
        return this.a == ((LocationDescriptor)object).a && Double.doubleToLongBits(this.b) == Double.doubleToLongBits(((LocationDescriptor)object).b) && Double.doubleToLongBits(this.c) == Double.doubleToLongBits(((LocationDescriptor)object).c) && Double.doubleToLongBits(this.d) == Double.doubleToLongBits(((LocationDescriptor)object).d) && Float.floatToIntBits(this.e) == Float.floatToIntBits(((LocationDescriptor)object).e) && Float.floatToIntBits(this.f) == Float.floatToIntBits(((LocationDescriptor)object).f) && Float.floatToIntBits(this.g) == Float.floatToIntBits(((LocationDescriptor)object).g) && Float.floatToIntBits(this.h) == Float.floatToIntBits(((LocationDescriptor)object).h);
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        LocationDescriptor locationDescriptor = this;
        long l2 = locationDescriptor.a;
        double d2 = locationDescriptor.b;
        double d3 = locationDescriptor.c;
        double d4 = locationDescriptor.d;
        float f2 = locationDescriptor.e;
        float f3 = locationDescriptor.f;
        float f4 = locationDescriptor.g;
        float f5 = locationDescriptor.h;
        StringBuilder stringBuilder3 = stringBuilder2 = stringBuilder;
        StringBuilder stringBuilder4 = stringBuilder2;
        StringBuilder stringBuilder5 = stringBuilder2;
        StringBuilder stringBuilder6 = stringBuilder2;
        StringBuilder stringBuilder7 = stringBuilder2;
        StringBuilder stringBuilder8 = stringBuilder2;
        StringBuilder stringBuilder9 = stringBuilder2;
        stringBuilder2("LocationDescriptor{timestampSeconds=");
        stringBuilder9.append(l2);
        stringBuilder9.append(",latitudeDegrees=");
        stringBuilder8.append(d2);
        stringBuilder8.append(",longitudeDegrees=");
        stringBuilder7.append(d3);
        stringBuilder7.append(",altitudeMeters=");
        stringBuilder6.append(d4);
        stringBuilder6.append(",speedMetersPerSecond=");
        stringBuilder5.append(f2);
        stringBuilder5.append(",horizontalAccuracyMeters=");
        stringBuilder4.append(f3);
        stringBuilder4.append(",verticalAccuracymeters=");
        stringBuilder3.append(f4);
        stringBuilder3.append(",speedAccuracyMetersPerSecond=");
        stringBuilder.append(f5);
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

