/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.app.ActivityManager;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import androidx.annotation.Nullable;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import java.util.Iterator;
import java.util.Objects;

public class AndroidContexts {
    public static boolean hasPermission(Context context, String string) {
        try {
            return context.checkCallingOrSelfPermission(string) == 0;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean hasAllPermissions(Context context, String ... stringArray) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (AndroidContexts.hasPermission(context, stringArray[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyPermissions(Context context, String ... stringArray) {
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!AndroidContexts.hasPermission(context, stringArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasSystemFeature(Context context, String string) {
        boolean bl;
        block4: {
            block3: {
                if ((context = context.getPackageManager()) != null) {
                    try {
                        if (!context.hasSystemFeature(string)) break block3;
                        bl = true;
                        break block4;
                    }
                    catch (Throwable throwable) {
                        return false;
                    }
                }
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static <T> T systemServiceOf(Context object, Class<T> clazz, String string) {
        block5: {
            block4: {
                block3: {
                    try {
                        object = object.getSystemService(string);
                        if (object == null) break block3;
                    }
                    catch (Throwable throwable) {
                        break block5;
                    }
                    if (clazz.isInstance(object)) break block4;
                }
                object = null;
            }
            return (T)object;
        }
        return null;
    }

    @Nullable
    public static <T, R> R withSystemService(Context object, Class<T> clazz, String string, Function<T, R> function) {
        if ((object = AndroidContexts.systemServiceOf(object, clazz, string)) != null) {
            try {
                return (R)function.apply(object);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public static <T, R> R withSystemService(Context context, Class<T> clazz, String string, Function<T, R> function, R r2) {
        return Objects.requireNonNullElse(AndroidContexts.withSystemService(context, clazz, string, function), r2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String currentProcessName(Context object) {
        int n2;
        Object object2;
        block10: {
            object2 = "";
            n2 = Build.VERSION.SDK_INT;
            if (n2 >= 28) {
                object2 = Application.getProcessName();
            }
            if (Strings.isNullOrEmpty((String)object2)) {
                try {
                    object2 = Class.forName("android.app.ActivityThread");
                    String string = n2 >= 18 ? "currentProcessName" : "currentPackageName";
                    object2 = (String)((Class)object2).getDeclaredMethod(string, null).invoke(null, null);
                    break block10;
                }
                catch (Throwable throwable) {}
                Log.w((String)"AndroidContexts", (String)"Failed to query process name", (Throwable)throwable);
                object2 = "";
            }
        }
        object = AndroidContexts.systemServiceOf((Context)object, ActivityManager.class, "activity");
        n2 = Process.myPid();
        if (object != null && (object = object.getRunningAppProcesses()) != null) {
            ActivityManager.RunningAppProcessInfo runningAppProcessInfo;
            Iterator iterator;
            if (Strings.isNullOrEmpty((String)object2)) {
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                    if (runningAppProcessInfo.pid != n2) continue;
                    object2 = runningAppProcessInfo.processName;
                    break;
                }
            }
            if (!Strings.isNullOrEmpty((String)object2)) {
                int n3 = Integer.MAX_VALUE;
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    int n4;
                    runningAppProcessInfo = (ActivityManager.RunningAppProcessInfo)iterator.next();
                    if (!((String)object2).equals(runningAppProcessInfo.processName) || (n4 = runningAppProcessInfo.pid) == n2) continue;
                    n3 = Math.min(n3, n4);
                }
                if (n3 != Integer.MAX_VALUE) {
                    object2 = (String)object2 + "." + (n2 - n3);
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)object2)) return object2;
        return Integer.toString(n2);
    }
}

