/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import androidx.annotation.RestrictTo;
import com.polygamma.ogm.util.Bits;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface ProtobufConstants {
    public static final int TYPE_VARINT = 0;
    public static final int TYPE_64BIT = 1;
    public static final int TYPE_LEN = 2;
    @Deprecated
    public static final int TYPE_START_GROUP = 3;
    @Deprecated
    public static final int TYPE_END_GROUP = 4;
    public static final int TYPE_32BIT = 5;
    public static final int MIN_TYPE = 0;
    public static final int MAX_TYPE = 5;
    public static final int BITS_PER_TYPE;
    public static final int TYPES_MASK;
    public static final int MIN_TAG = 1;
    public static final int MAX_TAG;
    public static final int MAX_VARINT_SIZE;
    public static final int MAX_INT_VARINT_SIZE;

    public static int sizeOfVarint(long l2) {
        return Integer.divideUnsigned((Long.numberOfLeadingZeros(l2 | 1L) ^ 0x3F) * 9 + 73, 64);
    }

    public static int sizeOfTag(int n2) {
        return ProtobufConstants.sizeOfVarint(Integer.toUnsignedLong(n2 << 3));
    }

    public static long varintOfSignedLong(long l2) {
        return l2 << 1 ^ l2 >> 63;
    }

    public static long varintOfSignedInt(int n2) {
        return Integer.toUnsignedLong(n2 << 1 ^ n2 >> 31);
    }

    public static long signedLongOfVarint(long l2) {
        return l2 >>> 1 ^ -(l2 & 1L);
    }

    public static int signedIntOfVarint(long l2) {
        int n2 = (int)(l2 & 0xFFFFFFFFL);
        return n2 >>> 1 ^ -(n2 & 1);
    }

    static {
        int n2;
        BITS_PER_TYPE = n2 = Bits.sizeOfUnsigned(6L);
        TYPES_MASK = Bits.intMaskOfRange(0, n2 - 1);
        MAX_TAG = (1 << 32 - n2) - 1;
        MAX_VARINT_SIZE = Math.max(ProtobufConstants.sizeOfVarint(-1L), Math.max(ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedLong(Long.MAX_VALUE)), ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedLong(Long.MIN_VALUE))));
        MAX_INT_VARINT_SIZE = Math.max(ProtobufConstants.sizeOfVarint(Integer.toUnsignedLong(-1)), Math.max(ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedInt(Integer.MAX_VALUE)), ProtobufConstants.sizeOfVarint(ProtobufConstants.varintOfSignedInt(Integer.MIN_VALUE))));
    }
}

