/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.os.Build;
import android.util.Pair;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.util.ProtobufConstants;
import com.polygamma.ogm.util.ProtobufMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProtobufReader {
    private final ByteBuffer a;
    int b;

    public boolean hasRemaining() {
        return this.a.hasRemaining();
    }

    final long a() {
        int n2;
        int n3 = this.a.get() & 0xFF;
        if (n3 < 128) {
            return n3;
        }
        long l2 = (long)n3 & 0x7FL;
        for (int i2 = 1; i2 < (n2 = ProtobufConstants.MAX_VARINT_SIZE); ++i2) {
            int n4 = this.a.get() & 0xFF;
            l2 |= ((long)n4 & 0x7FL) << i2 * 7;
            if (n4 >= 128) continue;
            if (i2 == n2 - 1 && n4 >= 2) break;
            return l2;
        }
        throw new IllegalStateException("malformed varint");
    }

    public int readTag() {
        long l2 = this.a();
        int n2 = (int)(l2 & (long)ProtobufConstants.TYPES_MASK);
        int n3 = (int)(l2 >>> ProtobufConstants.BITS_PER_TYPE);
        Preconditions.checkState((Long.compareUnsigned(l2, Integer.toUnsignedLong(-1)) <= 0 && n2 >= 0 && n2 <= 5 && n3 >= 1 && n3 <= ProtobufConstants.MAX_TAG ? 1 : 0) != 0, (String)"malformed key: %s", (long)l2);
        this.b = n2;
        return n3;
    }

    public boolean isNextVarint() {
        return this.b == 0;
    }

    public boolean isNextFixed64() {
        return this.b == 1;
    }

    public boolean isNextFixed32() {
        return this.b == 5;
    }

    public boolean isNextSequence() {
        return this.b == 2;
    }

    public long readUnsignedLong() {
        Preconditions.checkState((this.b == 0 ? 1 : 0) != 0);
        this.b = -1;
        return this.a();
    }

    public long readLong() {
        return ProtobufConstants.signedLongOfVarint(this.readUnsignedLong());
    }

    public int readUnsignedInt() {
        return (int)(this.readUnsignedLong() & 0xFFFFFFFFL);
    }

    public int readInt() {
        return ProtobufConstants.signedIntOfVarint(this.readUnsignedLong());
    }

    public boolean readBoolean() {
        return this.readUnsignedLong() != 0L;
    }

    public long readFixedLong() {
        int n2 = 1;
        Preconditions.checkState((this.b == n2 ? 1 : 0) != 0);
        this.b = -1;
        return this.a.getLong();
    }

    public int readFixedInt() {
        int n2 = 5;
        Preconditions.checkState((this.b == n2 ? 1 : 0) != 0);
        this.b = -1;
        return this.a.getInt();
    }

    public double readFixedDouble() {
        return Double.longBitsToDouble(this.readFixedLong());
    }

    public float readFixedFloat() {
        return Float.intBitsToFloat(this.readFixedInt());
    }

    public ByteBuffer readByteBufferView() {
        ByteBuffer byteBuffer;
        int n2;
        int n3 = 2;
        Preconditions.checkState((this.b == n3 ? 1 : 0) != 0);
        this.b = -1;
        long l2 = this.a();
        try {
            n2 = Math.toIntExact(l2);
        }
        catch (ArithmeticException arithmeticException) {
            n2 = -1;
        }
        Preconditions.checkState((n2 >= 0 ? 1 : 0) != 0, (String)"malformed length: %d", (long)l2);
        if (Build.VERSION.SDK_INT >= 34) {
            ByteBuffer byteBuffer2 = this.a;
            byteBuffer = byteBuffer2.slice(byteBuffer2.position(), n2);
        } else {
            ByteBuffer byteBuffer3 = this.a.duplicate();
            byteBuffer = ((ByteBuffer)byteBuffer3.limit(byteBuffer3.position() + n2)).slice();
        }
        ByteBuffer byteBuffer4 = this.a;
        int n4 = byteBuffer4.position();
        byteBuffer4.position(byteBuffer.remaining() + n4);
        return byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public byte[] readByteArray() {
        ByteBuffer byteBuffer = ((ProtobufReader)((Object)byteBuffer)).readByteBufferView();
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public long[] readUnsignedLongArray() {
        return this.b(false);
    }

    public long[] readLongArray() {
        return this.b(true);
    }

    public int[] readUnsignedIntArray() {
        return this.a(false);
    }

    public int[] readIntArray() {
        return this.a(true);
    }

    public boolean[] readBooleanArray() {
        ProtobufReader protobufReader;
        ProtobufReader protobufReader2 = protobufReader;
        int n2 = new ProtobufReader((ByteBuffer)this.readByteBufferView()).a.remaining();
        boolean[] blArray = new boolean[n2];
        int n3 = 0;
        while (protobufReader2.hasRemaining()) {
            int n4 = n3 + 1;
            boolean bl = protobufReader2.a() != 0L;
            blArray[n3] = bl;
            n3 = n4;
        }
        if (n3 != n2) {
            blArray = Arrays.copyOf(blArray, n3);
        }
        return blArray;
    }

    public long[] readFixedLongArray() {
        int n2 = 8;
        ByteBuffer byteBuffer = this.readByteBufferView();
        Preconditions.checkState((byteBuffer.remaining() % n2 == 0 ? 1 : 0) != 0, (Object)"misaligned fixed length");
        LongBuffer longBuffer = byteBuffer.asLongBuffer();
        long[] lArray = new long[longBuffer.remaining()];
        longBuffer.get(lArray);
        return lArray;
    }

    public int[] readFixedIntArray() {
        int n2 = 4;
        ByteBuffer byteBuffer = this.readByteBufferView();
        Preconditions.checkState((byteBuffer.remaining() % n2 == 0 ? 1 : 0) != 0, (Object)"misaligned fixed length");
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int[] nArray = new int[intBuffer.remaining()];
        intBuffer.get(nArray);
        return nArray;
    }

    public double[] readFixedDoubleArray() {
        int n2 = 8;
        ByteBuffer byteBuffer = this.readByteBufferView();
        Preconditions.checkState((byteBuffer.remaining() % n2 == 0 ? 1 : 0) != 0, (Object)"misaligned fixed length");
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        double[] dArray = new double[doubleBuffer.remaining()];
        doubleBuffer.get(dArray);
        return dArray;
    }

    public float[] readFixedFloatArray() {
        int n2 = 4;
        ByteBuffer byteBuffer = this.readByteBufferView();
        Preconditions.checkState((byteBuffer.remaining() % n2 == 0 ? 1 : 0) != 0, (Object)"misaligned fixed length");
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        float[] fArray = new float[floatBuffer.remaining()];
        floatBuffer.get(fArray);
        return fArray;
    }

    public String readUtf8() {
        return StandardCharsets.UTF_8.decode(this.readByteBufferView()).toString();
    }

    public Pair<String, String> readUtf8Pair() {
        ProtobufReader protobufReader;
        ProtobufReader protobufReader2 = protobufReader;
        protobufReader = new ProtobufReader(((ProtobufReader)object).readByteBufferView());
        Object object = "";
        String string = "";
        while (protobufReader2.hasRemaining()) {
            int n2 = protobufReader2.readTag();
            if (n2 != 1) {
                if (n2 == 2) {
                    string = protobufReader2.readUtf8();
                    continue;
                }
                throw new IllegalStateException("unexpected tag");
            }
            object = protobufReader2.readUtf8();
        }
        return new Pair(object, (Object)string);
    }

    public <M extends ProtobufMessage> M readMessage(M m2) {
        return (M)m2.mergeFrom(new ProtobufReader(this.readByteBufferView()));
    }

    public <M extends ProtobufMessage> List<M> readRepeatedMessage(List<M> arrayList, List<M> list, M m2) {
        if (list == arrayList) {
            ArrayList<M> arrayList2;
            arrayList = arrayList2;
            arrayList2 = new ArrayList<M>(1);
        }
        ArrayList<M> arrayList3 = arrayList;
        arrayList3.add(this.readMessage(m2));
        return arrayList3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void readAndDiscard() {
        int n2 = this.b;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    if (n2 != 5) throw new IllegalStateException();
                    this.readFixedInt();
                    return;
                } else {
                    this.readByteBufferView();
                }
                return;
            } else {
                this.readFixedLong();
            }
            return;
        } else {
            this.a();
        }
    }

    public ProtobufReader(ByteBuffer byteBuffer) {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        if (byteBuffer.order() != byteOrder) {
            byteBuffer = byteBuffer.slice().order(byteOrder);
        }
        ProtobufReader protobufReader = this;
        protobufReader.a = byteBuffer;
        protobufReader.b = -1;
    }

    private long[] b(boolean bl) {
        ProtobufReader protobufReader;
        ProtobufReader protobufReader2 = protobufReader;
        Object object = new long[new ProtobufReader((ByteBuffer)((ProtobufReader)object).readByteBufferView()).a.remaining() / Math.min(ProtobufConstants.MAX_VARINT_SIZE / 2, 1)];
        int n2 = 0;
        while (protobufReader2.hasRemaining()) {
            long l2 = protobufReader2.a();
            if (((Object)object).length == n2) {
                Object object2 = object;
                object = Arrays.copyOf((long[])object2, ((Object)object2).length * 2 + 1);
            }
            int n3 = n2 + 1;
            if (bl) {
                l2 = ProtobufConstants.signedLongOfVarint(l2);
            }
            object[n2] = l2;
            n2 = n3;
        }
        if (n2 != ((Object)object).length) {
            object = Arrays.copyOf((long[])object, n2);
        }
        return object;
    }

    private int[] a(boolean bl) {
        ProtobufReader protobufReader;
        ProtobufReader protobufReader2 = protobufReader;
        Object object = new int[new ProtobufReader((ByteBuffer)((ProtobufReader)object).readByteBufferView()).a.remaining() / Math.min(ProtobufConstants.MAX_INT_VARINT_SIZE / 2, 1)];
        int n2 = 0;
        while (protobufReader2.hasRemaining()) {
            long l2 = protobufReader2.a();
            if (((Object)object).length == n2) {
                Object object2 = object;
                object = Arrays.copyOf((int[])object2, ((Object)object2).length * 2 + 1);
            }
            int n3 = n2 + 1;
            int n4 = bl ? ProtobufConstants.signedIntOfVarint(l2) : (int)(l2 & 0xFFFFFFFFL);
            object[n2] = n4;
            n2 = n3;
        }
        if (n2 != ((Object)object).length) {
            object = Arrays.copyOf((int[])object, n2);
        }
        return object;
    }
}

