/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.util;

import android.util.Pair;
import androidx.core.util.Consumer;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.util.ProtobufConstants;
import com.polygamma.ogm.util.ProtobufMessage;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class ProtobufWriter {
    private ByteBuffer a;

    public ProtobufWriter() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(64);
        this.a = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    private ByteBuffer a(int n2) {
        ByteBuffer byteBuffer = this.a;
        if (byteBuffer.remaining() >= n2) {
            return byteBuffer;
        }
        int n3 = byteBuffer.capacity();
        this.a = ByteBuffer.allocate(Math.max(n3 * 2 + 1, Math.addExact(n3, n2))).order(ByteOrder.LITTLE_ENDIAN).put((ByteBuffer)byteBuffer.flip());
        return this.a;
    }

    private int a(int n2, int n3, int n4) {
        ProtobufWriter protobufWriter = this;
        Objects.checkFromIndexSize(n2, n3, n4);
        n2 = ProtobufConstants.MAX_INT_VARINT_SIZE;
        protobufWriter.a(n2 + n2);
        int n5 = protobufWriter.a.position();
        this.a.position(n5 + n2 + n2);
        return n5;
    }

    private void a(int n2, int n3) {
        int n4 = ProtobufConstants.MAX_INT_VARINT_SIZE;
        n4 = n3 + n4 + n4;
        int n5 = ((ProtobufWriter)((Object)byteBuffer)).a.position() - n4;
        if (n5 == 0) {
            ((ProtobufWriter)((Object)byteBuffer)).a.position(n3);
            return;
        }
        ProtobufWriter protobufWriter = byteBuffer;
        ProtobufWriter protobufWriter2 = byteBuffer;
        ByteBuffer byteBuffer = protobufWriter2.a.duplicate();
        byteBuffer.position(n4).limit(n4 + n5);
        protobufWriter2.a.position(n3);
        protobufWriter.b((int)n2, (int)2).a((long)((long)n5)).a.put(byteBuffer);
    }

    private ProtobufWriter a(boolean bl, int n2, long[] lArray, int n3, int n4) {
        int n5 = this.a(n3, n4, lArray.length);
        this.a(n4 * ProtobufConstants.MAX_VARINT_SIZE);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            int n7 = n3 + 1;
            long l2 = lArray[n3];
            if (bl) {
                l2 = ProtobufConstants.varintOfSignedLong(l2);
            }
            this.a(l2);
            n3 = n7;
        }
        ProtobufWriter protobufWriter = this;
        protobufWriter.a(n2, n5);
        return protobufWriter;
    }

    private ProtobufWriter a(boolean bl, int n2, int[] nArray, int n3, int n4) {
        int n5 = this.a(n3, n4, nArray.length);
        this.a(n4 * ProtobufConstants.MAX_INT_VARINT_SIZE);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            int n7 = n3 + 1;
            n3 = nArray[n3];
            long l2 = bl ? ProtobufConstants.varintOfSignedInt(n3) : Integer.toUnsignedLong(n3);
            this.a(l2);
            n3 = n7;
        }
        ProtobufWriter protobufWriter = this;
        protobufWriter.a(n2, n5);
        return protobufWriter;
    }

    private ByteBuffer a(int n2, int n3, int n4, int n5, int n6) {
        Objects.checkFromIndexSize(n4, n5, n6);
        if (n5 == 0) {
            return this.a;
        }
        int n7 = ProtobufConstants.MAX_VARINT_SIZE;
        int n8 = n5 * n3;
        this.a(n7 + n7 + n8);
        return this.b((int)n2, (int)2).a((long)((long)n8)).a;
    }

    final ProtobufWriter a(long l2) {
        ByteBuffer byteBuffer = this.a(ProtobufConstants.MAX_VARINT_SIZE);
        for (int i2 = 0; i2 < ProtobufConstants.MAX_VARINT_SIZE; ++i2) {
            if (Long.compareUnsigned(l2, 128L) < 0) {
                byteBuffer.put((byte)(l2 & 0xFFL));
                break;
            }
            byteBuffer.put((byte)(l2 & 0x7FL | 0x80L));
            l2 >>>= 7;
        }
        return this;
    }

    final ProtobufWriter b(int n2, int n3) {
        Preconditions.checkArgument((n2 >= 1 && n2 <= ProtobufConstants.MAX_TAG ? 1 : 0) != 0);
        return this.a(Integer.toUnsignedLong(n2 << ProtobufConstants.BITS_PER_TYPE | n3));
    }

    public ProtobufWriter writeUnsignedLong(int n2, long l2) {
        int n3 = ProtobufConstants.MAX_VARINT_SIZE;
        this.a(n3 + n3);
        return this.b(n2, 0).a(l2);
    }

    public ProtobufWriter writeLong(int n2, long l2) {
        return this.writeUnsignedLong(n2, ProtobufConstants.varintOfSignedLong(l2));
    }

    public ProtobufWriter writeUnsignedInt(int n2, int n3) {
        return this.writeUnsignedLong(n2, Integer.toUnsignedLong(n3));
    }

    public ProtobufWriter writeInt(int n2, int n3) {
        return this.writeUnsignedLong(n2, ProtobufConstants.varintOfSignedInt(n3));
    }

    public ProtobufWriter writeBoolean(int n2, boolean bl) {
        ProtobufWriter protobufWriter = this;
        this.a(ProtobufConstants.MAX_VARINT_SIZE + 1);
        protobufWriter.b((int)n2, (int)0).a.put((byte)(bl ? 1 : 0));
        return protobufWriter;
    }

    public ProtobufWriter writeFixedLong(int n2, long l2) {
        ProtobufWriter protobufWriter = this;
        this.a(ProtobufConstants.MAX_VARINT_SIZE + 8);
        protobufWriter.b((int)n2, (int)1).a.putLong(l2);
        return protobufWriter;
    }

    public ProtobufWriter writeFixedInt(int n2, int n3) {
        ProtobufWriter protobufWriter = this;
        this.a(ProtobufConstants.MAX_VARINT_SIZE + 4);
        protobufWriter.b((int)n2, (int)5).a.putInt(n3);
        return protobufWriter;
    }

    public ProtobufWriter writeFixedDouble(int n2, double d2) {
        return this.writeFixedLong(n2, Double.doubleToLongBits(d2));
    }

    public ProtobufWriter writeFixedFloat(int n2, float f2) {
        return this.writeFixedInt(n2, Float.floatToIntBits(f2));
    }

    public ProtobufWriter writeByteBuffer(int n2, ByteBuffer byteBuffer) {
        if (!byteBuffer.hasRemaining()) {
            return this;
        }
        ProtobufWriter protobufWriter = this;
        int n3 = ProtobufConstants.MAX_VARINT_SIZE;
        int n4 = n3 + n3;
        this.a(byteBuffer.remaining() + n4);
        protobufWriter.b((int)n2, (int)2).a((long)((long)byteBuffer.remaining())).a.put(byteBuffer);
        return protobufWriter;
    }

    public ProtobufWriter writeByteArray(int n2, byte[] byArray, int n3, int n4) {
        return this.writeByteBuffer(n2, ByteBuffer.wrap(byArray, n3, n4));
    }

    public ProtobufWriter writeByteArray(int n2, byte[] byArray) {
        int n3 = byArray.length;
        return this.writeByteArray(n2, byArray, 0, n3);
    }

    public ProtobufWriter writeUnsignedLongArray(int n2, long[] lArray, int n3, int n4) {
        return this.a(false, n2, lArray, n3, n4);
    }

    public ProtobufWriter writeUnsignedLongArray(int n2, long[] lArray) {
        int n3 = lArray.length;
        return this.writeUnsignedLongArray(n2, lArray, 0, n3);
    }

    public ProtobufWriter writeLongArray(int n2, long[] lArray, int n3, int n4) {
        return this.a(true, n2, lArray, n3, n4);
    }

    public ProtobufWriter writeLongArray(int n2, long[] lArray) {
        int n3 = lArray.length;
        return this.a(true, n2, lArray, 0, n3);
    }

    public ProtobufWriter writeUnsignedIntArray(int n2, int[] nArray, int n3, int n4) {
        return this.a(false, n2, nArray, n3, n4);
    }

    public ProtobufWriter writeUnsignedIntArray(int n2, int[] nArray) {
        int n3 = nArray.length;
        return this.writeUnsignedIntArray(n2, nArray, 0, n3);
    }

    public ProtobufWriter writeIntArray(int n2, int[] nArray, int n3, int n4) {
        return this.a(true, n2, nArray, n3, n4);
    }

    public ProtobufWriter writeIntArray(int n2, int[] nArray) {
        int n3 = nArray.length;
        return this.a(true, n2, nArray, 0, n3);
    }

    public ProtobufWriter writeBooleanArray(int n2, boolean[] blArray, int n3, int n4) {
        ProtobufWriter protobufWriter = this;
        int n5 = blArray.length;
        n5 = protobufWriter.a(n3, n4, n5);
        ByteBuffer byteBuffer = protobufWriter.a(n4);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            byteBuffer.put((byte)(blArray[n3++] ? 1 : 0));
        }
        ProtobufWriter protobufWriter2 = this;
        protobufWriter2.a(n2, n5);
        return protobufWriter2;
    }

    public ProtobufWriter writeBooleanArray(int n2, boolean[] blArray) {
        int n3 = blArray.length;
        return this.writeBooleanArray(n2, blArray, 0, n3);
    }

    public ProtobufWriter writeFixedLongArray(int n2, long[] lArray, int n3, int n4) {
        int n5 = lArray.length;
        ByteBuffer byteBuffer = this.a(n2, 8, n3, n4, n5);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            byteBuffer.putLong(lArray[n3++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedLongArray(int n2, long[] lArray) {
        int n3 = lArray.length;
        return this.writeFixedLongArray(n2, lArray, 0, n3);
    }

    public ProtobufWriter writeFixedIntArray(int n2, int[] nArray, int n3, int n4) {
        int n5 = nArray.length;
        ByteBuffer byteBuffer = this.a(n2, 4, n3, n4, n5);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            byteBuffer.putInt(nArray[n3++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedIntArray(int n2, int[] nArray) {
        int n3 = nArray.length;
        return this.writeFixedIntArray(n2, nArray, 0, n3);
    }

    public ProtobufWriter writeFixedDoubleArray(int n2, double[] dArray, int n3, int n4) {
        int n5 = dArray.length;
        ByteBuffer byteBuffer = this.a(n2, 8, n3, n4, n5);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            byteBuffer.putDouble(dArray[n3++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedDoubleArray(int n2, double[] dArray) {
        int n3 = dArray.length;
        return this.writeFixedDoubleArray(n2, dArray, 0, n3);
    }

    public ProtobufWriter writeFixedFloatArray(int n2, float[] fArray, int n3, int n4) {
        int n5 = fArray.length;
        ByteBuffer byteBuffer = this.a(n2, 4, n3, n4, n5);
        while (true) {
            int n6 = n4;
            n4 = n6 + -1;
            if (n6 <= 0) break;
            byteBuffer.putFloat(fArray[n3++]);
        }
        return this;
    }

    public ProtobufWriter writeFixedFloatArray(int n2, float[] fArray) {
        int n3 = fArray.length;
        return this.writeFixedFloatArray(n2, fArray, 0, n3);
    }

    public ProtobufWriter writeUtf8(int n2, String string) {
        return this.writeByteArray(n2, string.getBytes(StandardCharsets.UTF_8));
    }

    public ProtobufWriter writeUtf8Pair(int n2, Pair<String, String> pair) {
        ProtobufWriter protobufWriter = this;
        int n3 = this.a(0, 1, 1);
        protobufWriter.writeUtf8(1, (String)pair.first).writeUtf8(2, (String)pair.second).a(n2, n3);
        return protobufWriter;
    }

    public ProtobufWriter writeMessage(int n2, ProtobufMessage protobufMessage) {
        ProtobufWriter protobufWriter = this;
        int n3 = this.a(0, 1, 1);
        protobufMessage.writeTo(this);
        protobufWriter.a(n2, n3);
        return protobufWriter;
    }

    public ProtobufWriter writeMessage(int n2, Consumer<ProtobufWriter> consumer) {
        ProtobufWriter protobufWriter = this;
        int n3 = this.a(0, 1, 1);
        consumer.accept((Object)this);
        protobufWriter.a(n2, n3);
        return protobufWriter;
    }

    public ProtobufWriter writeRepeatedMessage(int n2, Iterable<? extends ProtobufMessage> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.writeMessage(n2, (ProtobufMessage)object.next());
        }
        return this;
    }

    public ByteBuffer finish() {
        ByteBuffer byteBuffer = this.a.duplicate();
        byteBuffer.flip();
        this.a.clear();
        return byteBuffer;
    }
}

