/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm;

import android.os.Build;
import android.os.SystemClock;
import com.polygamma.ogm.Executor;
import com.polygamma.ogm.util.DebugBuild;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ForkJoinPool;

final class BackgroundExecutor
extends Executor {
    private final Timer timer = new Timer();
    private final ForkJoinPool work = Build.VERSION.SDK_INT >= 24 ? ForkJoinPool.commonPool() : new ForkJoinPool(Math.max(Runtime.getRuntime().availableProcessors(), 1) * 2 + 1);

    BackgroundExecutor() {
    }

    @Override
    void terminate() {
        try {
            this.timer.cancel();
            if (Build.VERSION.SDK_INT < 24) {
                this.work.shutdown();
            }
        }
        finally {
            super.terminate();
        }
    }

    @Override
    boolean postImpl(Runnable cmd, long expiryMillis) {
        if (expiryMillis == 0L) {
            this.work.execute(cmd);
        } else if ((expiryMillis -= SystemClock.uptimeMillis()) != 0L) {
            this.timer.schedule((TimerTask)new PostDelayed(cmd), expiryMillis);
        } else {
            this.work.execute(cmd);
        }
        return true;
    }

    private final class PostDelayed
    extends TimerTask {
        private final Runnable command;

        PostDelayed(Runnable cmd) {
            this.command = DebugBuild.checkNotNull(cmd);
        }

        @Override
        public void run() {
            try {
                BackgroundExecutor.this.work.submit(this.command);
            }
            finally {
                super.cancel();
            }
        }
    }
}

