/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm;

import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.Sync;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

abstract class Executor
extends AbstractExecutorService
implements ListeningScheduledExecutorService {
    private static final String TAG = Executor.class.getSimpleName();
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATED = 2;
    private final ReadWriteLock lock = Sync.newReadWriteLock();
    private final AtomicInteger pendingTasks = new AtomicInteger();
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private int state = 0;

    private static void checkPosted(boolean ok) {
        if (!ok) {
            throw new RejectedExecutionException();
        }
    }

    Executor() {
    }

    void terminate() {
        assert (this.state == 1);
        this.shutdownLatch.countDown();
        this.state = 2;
    }

    @Override
    public void shutdown() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            if (this.state != 0) {
                return;
            }
            this.state = 1;
            if (this.pendingTasks.get() == 0) {
                this.terminate();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void onTaskComplete(Task<?> task) {
        DebugBuild.log(TAG, "task %s completed", task);
        if (this.pendingTasks.decrementAndGet() == 0) {
            Lock read = this.lock.readLock();
            read.lock();
            try {
                if (this.state == 1) {
                    this.terminate();
                }
            }
            finally {
                read.unlock();
            }
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isState(int exp) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            boolean bl = this.state == exp;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean isShutdown() {
        return !this.isState(0);
    }

    @Override
    public boolean isTerminated() {
        return this.isState(2);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    abstract boolean postImpl(Runnable var1, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void post(Task<?> cmd, long expiryMillis, boolean recur) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            Executor.checkPosted(this.state == 0 && this.postImpl(cmd, expiryMillis));
            if (!recur) {
                this.pendingTasks.getAndIncrement();
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void post(Task<?> cmd) {
        this.post(cmd, 0L, false);
    }

    @NonNull
    public <T> ListenableFuture<T> submit(@NonNull Callable<T> cmd) {
        Task<T> task = new Task<T>(cmd);
        this.post(task);
        return task;
    }

    @NonNull
    public <T> ListenableFuture<T> submit(@NonNull Runnable cmd, T res) {
        Task<T> task = new Task<T>(cmd, res);
        this.post(task);
        return task;
    }

    @NonNull
    public ListenableFuture<?> submit(@NonNull Runnable cmd) {
        return this.submit(cmd, (T)null);
    }

    @Override
    public void execute(Runnable cmd) {
        this.submit(cmd);
    }

    private <V> ListenableScheduledFuture<V> scheduleImpl(Task<V> task, long delay, TimeUnit unit) {
        DelayedFutureImpl fut = new DelayedFutureImpl(task, SystemClock.uptimeMillis() + unit.toMillis(delay));
        this.post(fut.task, fut.expiryMillis, false);
        return fut;
    }

    @NonNull
    public ListenableScheduledFuture<?> schedule(@NonNull Runnable cmd, long delay, @NonNull TimeUnit unit) {
        return this.scheduleImpl(new Task<Object>(cmd, null), delay, unit);
    }

    @NonNull
    public <V> ListenableScheduledFuture<V> schedule(@NonNull Callable<V> cmd, long delay, @NonNull TimeUnit unit) {
        return this.scheduleImpl(new Task<V>(cmd), delay, unit);
    }

    @NonNull
    public ListenableScheduledFuture<?> scheduleAtFixedRate(@NonNull Runnable cmd, long initialDelay, long period, @NonNull TimeUnit unit) {
        RecurringRateTask task = new RecurringRateTask(cmd, unit.toMillis(initialDelay), unit.toMillis(period));
        this.post(task, task.expiryMillis, false);
        return task;
    }

    @NonNull
    public ListenableScheduledFuture<?> scheduleWithFixedDelay(@NonNull Runnable cmd, long initialDelay, long delay, @NonNull TimeUnit unit) {
        RecurringDelayTask task = new RecurringDelayTask(cmd, unit.toMillis(initialDelay), unit.toMillis(delay));
        this.post(task, task.expiryMillis, false);
        return task;
    }

    public <T> ListenableFuture<T> submitPunting(java.util.concurrent.Executor dst, Callable<T> cmd) {
        PuntingTask<T> task = new PuntingTask<T>(dst, cmd);
        this.post(task);
        return task;
    }

    public ListenableFuture<?> submitPunting(java.util.concurrent.Executor dst, Runnable cmd) {
        PuntingTask<Object> task = new PuntingTask<Object>(dst, cmd, null);
        this.post(task);
        return task;
    }

    public <T> ListenableScheduledFuture<T> schedulePunting(java.util.concurrent.Executor dst, Callable<T> cmd, long delay, TimeUnit unit) {
        return this.scheduleImpl(new PuntingTask<T>(dst, cmd), delay, unit);
    }

    public ListenableScheduledFuture<?> schedulePunting(java.util.concurrent.Executor dst, Runnable cmd, long delay, TimeUnit unit) {
        return this.scheduleImpl(new PuntingTask<Object>(dst, cmd, null), delay, unit);
    }

    public ListenableScheduledFuture<?> schedulePuntingWithFixedDelay(java.util.concurrent.Executor dst, Runnable cmd, long initialDelay, long delay, TimeUnit unit) {
        RecurringPuntingDelayTask task = new RecurringPuntingDelayTask(dst, cmd, unit.toMillis(initialDelay), unit.toMillis(delay));
        this.post(task, task.expiryMillis, false);
        return task;
    }

    private class Task<V>
    extends FutureTask<V>
    implements ListenableFuture<V> {
        private final ExecutionList listeners;

        Task(Runnable cmd, V res) {
            super(Objects.requireNonNull(cmd), res);
            this.listeners = new ExecutionList();
        }

        Task(Callable<V> cmd) {
            super(Objects.requireNonNull(cmd));
            this.listeners = new ExecutionList();
        }

        @Override
        protected void done() {
            Executor.this.onTaskComplete(this);
            this.listeners.execute();
        }

        public void addListener(Runnable fn, java.util.concurrent.Executor exec) {
            this.listeners.add(fn, exec);
        }
    }

    private static final class DelayedFutureImpl<V>
    implements ListenableScheduledFuture<V> {
        private final Task<V> task;
        private final long expiryMillis;

        private DelayedFutureImpl(Task<V> task, long expiryMillis) {
            this.task = task;
            this.expiryMillis = expiryMillis;
        }

        public void addListener(@NonNull Runnable fn, @NonNull java.util.concurrent.Executor exec) {
            this.task.addListener(fn, exec);
        }

        public int compareTo(Delayed that) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), that.getDelay(TimeUnit.MILLISECONDS));
        }

        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiryMillis - SystemClock.uptimeMillis(), TimeUnit.MILLISECONDS);
        }

        public boolean cancel(boolean force) {
            return this.task.cancel(force);
        }

        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        public boolean isDone() {
            return this.task.isDone();
        }

        public V get() throws ExecutionException, InterruptedException {
            return this.task.get();
        }

        public V get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return this.task.get(timeout, unit);
        }
    }

    private class RecurringRateTask
    extends RecurringTask {
        private final long periodMillis;

        RecurringRateTask(Runnable cmd, long initialDelayMillis, long periodMillis) {
            super(cmd, initialDelayMillis);
            Preconditions.checkArgument((periodMillis >= 0L ? 1 : 0) != 0);
            this.periodMillis = periodMillis;
        }

        @Override
        long nextExpiryMillis() {
            return this.expiryMillis + this.periodMillis;
        }
    }

    private class RecurringDelayTask
    extends RecurringTask {
        private final long delayMillis;

        RecurringDelayTask(Runnable cmd, long initialDelayMillis, long delayMillis) {
            super(cmd, initialDelayMillis);
            Preconditions.checkArgument((delayMillis >= 0L ? 1 : 0) != 0);
            this.delayMillis = delayMillis;
        }

        @Override
        long nextExpiryMillis() {
            return SystemClock.uptimeMillis() + this.delayMillis;
        }
    }

    private class PuntingTask<V>
    extends Task<V> {
        private final java.util.concurrent.Executor destination;
        private boolean punted;

        PuntingTask(java.util.concurrent.Executor dst, Runnable cmd, V res) {
            super(cmd, res);
            this.destination = Objects.requireNonNull(dst);
        }

        PuntingTask(java.util.concurrent.Executor dst, Callable<V> cmd) {
            super(cmd);
            this.destination = Objects.requireNonNull(dst);
        }

        @Override
        public void run() {
            if (this.punted) {
                super.run();
            } else if (!super.isDone()) {
                this.punted = true;
                try {
                    this.destination.execute(this);
                }
                catch (RejectedExecutionException e) {
                    super.setException(e);
                }
            }
        }
    }

    private class RecurringPuntingDelayTask
    extends RecurringDelayTask {
        private final java.util.concurrent.Executor destination;
        private final Runnable command;
        private boolean punted;

        RecurringPuntingDelayTask(java.util.concurrent.Executor dst, Runnable cmd, long initialDelayMillis, long delayMillis) {
            super(() -> {}, initialDelayMillis, delayMillis);
            this.destination = Objects.requireNonNull(dst);
            this.command = Objects.requireNonNull(cmd);
        }

        @Override
        public void run() {
            if (!super.runAndReset()) {
                return;
            }
            try {
                if (this.punted) {
                    this.punted = false;
                    this.command.run();
                    long next = this.nextExpiryMillis();
                    try {
                        Executor.this.post(this, next, true);
                        this.expiryMillis = next;
                    }
                    catch (RejectedExecutionException e) {
                        super.cancel(false);
                    }
                } else {
                    this.punted = true;
                    this.destination.execute(this);
                }
            }
            catch (Throwable e) {
                super.setException(e);
            }
        }
    }

    private abstract class RecurringTask
    extends Task<Object>
    implements ListenableScheduledFuture<Object> {
        long expiryMillis;

        RecurringTask(Runnable cmd, long initialDelayMillis) {
            super(Objects.requireNonNull(cmd), null);
            Preconditions.checkArgument((initialDelayMillis >= 0L ? 1 : 0) != 0);
            this.expiryMillis = SystemClock.uptimeMillis() + initialDelayMillis;
        }

        abstract long nextExpiryMillis();

        @Override
        public void run() {
            if (super.runAndReset()) {
                long next = this.nextExpiryMillis();
                try {
                    Executor.this.post(this, next, true);
                    this.expiryMillis = next;
                }
                catch (RejectedExecutionException e) {
                    super.cancel(false);
                }
            }
        }

        public int compareTo(Delayed that) {
            return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), that.getDelay(TimeUnit.MILLISECONDS));
        }

        public long getDelay(TimeUnit unit) {
            return unit.convert(this.expiryMillis - SystemClock.uptimeMillis(), TimeUnit.MILLISECONDS);
        }
    }
}

