/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm;

import android.content.Context;
import android.os.Handler;
import androidx.core.util.Supplier;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.antifraud.AntiFraudModule;
import com.polygamma.ogm.net.RemoteServiceModule;
import com.polygamma.ogm.util.DebugBuild;
import com.transsion.core.CoreUtil;
import java.lang.reflect.Constructor;
import java.util.concurrent.TimeUnit;

final class HisavanaBootstrap {
    private static final String TAG = HisavanaBootstrap.class.getSimpleName();

    HisavanaBootstrap() {
    }

    private static void doBootstrap(Context ctxt) {
        Preconditions.checkNotNull((Object)ctxt);
        try {
            OriginMobile.current();
            return;
        }
        catch (IllegalStateException illegalStateException) {
            DebugBuild.log(TAG, "Attempting to bootstrap");
            Handler handler = new Handler(ctxt.getMainLooper());
            handler.post(() -> OriginMobile.initializer().context(ctxt).addModule(RemoteServiceModule.ofProvider().rootServiceHost("ogsvc.pgoriginad.com")).addModule(AntiFraudModule.ofProvider()).initialize((sdk, err) -> {
                if (err != null) {
                    DebugBuild.log(TAG, "Failed to initialize SDK", err);
                } else {
                    DebugBuild.log(TAG, "Initialized SDK");
                }
            }));
            return;
        }
    }

    static void bootstrap() {
        try {
            Class.forName("com.transsion.core.CoreUtil");
            Constructor<?> ctor = Class.forName("com.polygamma.ogm.HisavanaBootstrap$ContextAccessor").getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            Supplier acc = (Supplier)ctor.newInstance(new Object[0]);
            Thread thread = new Thread(() -> {
                for (int i = 0; i < 5; ++i) {
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(15L));
                        HisavanaBootstrap.doBootstrap((Context)acc.get());
                        break;
                    }
                    catch (Throwable err) {
                        DebugBuild.log(TAG, "Bootstrap failed", err);
                        continue;
                    }
                }
            });
            thread.setDaemon(true);
            thread.start();
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "Bootstrap unavailable", e);
        }
    }

    private static final class ContextAccessor
    implements Supplier<Context> {
        private ContextAccessor() {
        }

        public Context get() {
            return CoreUtil.getContext();
        }
    }
}

