/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.InstallSourceInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Process;
import android.webkit.WebView;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.ReturnThis;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.util.Consumer;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import com.polygamma.ogm.AppDescriptor;
import com.polygamma.ogm.BackgroundExecutor;
import com.polygamma.ogm.HisavanaBootstrap;
import com.polygamma.ogm.LooperExecutor;
import com.polygamma.ogm.OriginModule;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.BiConsumer;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.Gzip;
import com.polygamma.ogm.util.MoreFutures;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.Sync;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONObject;

public final class OriginMobile {
    public static final String VERSION = "0.5.13.3";
    private static final String TAG = OriginMobile.class.getSimpleName();
    private static final String SHARED_PREFERENCES_NAME = "pgogm";
    private static final Lock INSTALL_LOCK = new ReentrantLock();
    private static final IdentityHashMap<Consumer<OriginMobile>, Object> ON_INSTALL = new IdentityHashMap();
    @Nullable
    private static OriginMobile instance;
    private final UUID startupId;
    private final AppDescriptor app;
    private final WeakReference<Context> context;
    @VisibleForTesting
    @Nullable
    final SharedPreferences settings;
    private final LooperExecutor foreground;
    private final ListeningScheduledExecutorService background;
    private final ReadWriteLock modulesLock;
    private final LinkedHashMap<Class<? extends OriginModule>, Object> modules;
    private final CountDownLatch shutdownLatch;
    private final ReadWriteLock descriptorsLock;
    private final IdentityHashMap<OriginModule, ProtobufMessage> descriptors;
    private final IdentityHashMap<OriginModule, ProtobufMessage> updatedDescriptors;
    private final IdentityHashMap<Consumer<Map<OriginModule, ProtobufMessage>>, Object> descriptorsUpdateCallbacks;
    @Nullable
    private Future<?> descriptorsUpdateFuture;

    @VisibleForTesting
    @Nullable
    static SharedPreferences openSettings(Context ctxt, String seed) {
        try {
            return ctxt.getSharedPreferences(Gzip.compressString("pgogm_" + seed), 0);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "Failed to open shared preferences", e);
            return null;
        }
    }

    private static void doInstall(OriginMobile sdk) {
        instance = sdk;
        for (Consumer<OriginMobile> cons : ON_INSTALL.keySet()) {
            sdk.background().execute(() -> cons.accept((Object)sdk));
        }
    }

    private static void install(OriginMobile sdk) {
        INSTALL_LOCK.lock();
        try {
            if (instance == null) {
                OriginMobile.doInstall(sdk);
                return;
            }
            OriginMobile prev = instance;
            prev.shutdown();
            for (int i = 0; i != 5; ++i) {
                block10: {
                    if (!prev.awaitTermination(1L, TimeUnit.MINUTES)) break block10;
                    OriginMobile.doInstall(sdk);
                    return;
                }
                try {
                    DebugBuild.log(TAG, "previous SDK shut down taking longer than 1 minute");
                    continue;
                }
                catch (InterruptedException e) {
                    DebugBuild.log(TAG, "previous SDK shut down wait interrupted", e);
                }
            }
            throw new IllegalStateException("failed to stop previous SDK");
        }
        finally {
            INSTALL_LOCK.unlock();
        }
    }

    public static Initializer initializer() {
        return new Initializer();
    }

    public static OriginMobile current() {
        if (instance == null) {
            throw new IllegalStateException("module not yet initialized");
        }
        return instance;
    }

    public static void registerInstallCallback(Consumer<OriginMobile> cb) {
        OriginMobile sdk;
        INSTALL_LOCK.lock();
        try {
            if (ON_INSTALL.put(cb, true) != null) {
                return;
            }
            sdk = instance;
            if (sdk == null || sdk.isShutdown()) {
                return;
            }
        }
        finally {
            INSTALL_LOCK.unlock();
        }
        try {
            sdk.background.execute(() -> {
                INSTALL_LOCK.lock();
                try {
                    if (sdk != instance || sdk.isShutdown()) {
                        return;
                    }
                }
                finally {
                    INSTALL_LOCK.unlock();
                }
                cb.accept((Object)sdk);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    public static void deregisterInstallCallback(Consumer<OriginMobile> cb) {
        INSTALL_LOCK.lock();
        try {
            ON_INSTALL.remove(cb);
        }
        finally {
            INSTALL_LOCK.unlock();
        }
    }

    private OriginMobile(Initializer ini) {
        Context ctxt = DebugBuild.checkNotNull(ini.context);
        ShutdownTrigger shutdownTrigger = new ShutdownTrigger();
        this.startupId = UUID.randomUUID();
        this.app = ini.probeApp();
        this.context = new WeakReference<Context>(ctxt, shutdownTrigger.queue);
        this.settings = OriginMobile.openSettings(ctxt, this.app.processName());
        this.foreground = new LooperExecutor(ctxt.getMainLooper());
        this.background = new BackgroundExecutor();
        this.modulesLock = Sync.newReadWriteLock();
        this.modules = new LinkedHashMap();
        this.shutdownLatch = new CountDownLatch(1);
        this.descriptorsLock = Sync.newReadWriteLock();
        this.descriptors = new IdentityHashMap();
        this.updatedDescriptors = new IdentityHashMap();
        this.descriptorsUpdateCallbacks = new IdentityHashMap();
        new Thread(shutdownTrigger).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadModules() {
        ArrayList<Map.Entry<Class<? extends OriginModule>, Object>> mods;
        IllegalStateException unloaded = new IllegalStateException("module unloaded");
        this.modulesLock.readLock().lock();
        try {
            mods = new ArrayList<Map.Entry<Class<? extends OriginModule>, Object>>(this.modules.entrySet());
        }
        finally {
            this.modulesLock.readLock().unlock();
        }
        while (!mods.isEmpty()) {
            OriginModule mod;
            Map.Entry entry = (Map.Entry)mods.remove(mods.size() - 1);
            OriginModule originModule = mod = entry.getValue() instanceof OriginModule ? (OriginModule)entry.getValue() : null;
            if (mod == null) continue;
            try {
                mod.destroy();
                DebugBuild.log(TAG, "unloaded module %s", mod);
            }
            catch (Exception e) {
                DebugBuild.log(TAG, String.format("failed to destroy module %s", mod), e);
            }
            this.modulesLock.writeLock().lock();
            try {
                this.modules.put((Class)entry.getKey(), unloaded);
            }
            finally {
                this.modulesLock.writeLock().unlock();
            }
        }
    }

    private static void shutdownWorkPool(String which, ExecutorService exec) {
        exec.shutdown();
        for (int i = 0; i < 2; ++i) {
            try {
                if (exec.awaitTermination(1L, TimeUnit.MINUTES)) {
                    return;
                }
                DebugBuild.log(TAG, String.format("%s work pool taking longer than 1 minute to terminate", which));
                exec.shutdownNow();
                continue;
            }
            catch (InterruptedException e) {
                DebugBuild.log(TAG, String.format("interrupted while awaiting %s work pool shut down", which), e);
            }
        }
    }

    private void doShutdown() {
        try {
            this.unloadModules();
            OriginMobile.shutdownWorkPool("background", (ExecutorService)this.background);
            OriginMobile.shutdownWorkPool("foreground", this.foreground);
        }
        finally {
            this.shutdownLatch.countDown();
            INSTALL_LOCK.lock();
            try {
                if (instance == this) {
                    instance = null;
                }
            }
            finally {
                INSTALL_LOCK.unlock();
            }
        }
        DebugBuild.log(TAG, "shutdown complete %s", this);
    }

    public boolean isShutdown() {
        return this.context.get() == null;
    }

    public boolean isTerminated() {
        return this.shutdownLatch.getCount() == 0L;
    }

    public UUID startupId() {
        return this.startupId;
    }

    public AppDescriptor app() {
        return this.app;
    }

    public Context context() {
        Context ctxt = (Context)this.context.get();
        if (ctxt == null) {
            throw new IllegalStateException();
        }
        return ctxt;
    }

    public void removeSetting(String name) {
        if (this.settings != null) {
            this.settings.edit().remove(name).apply();
        }
    }

    public String getSetting(String name, String dfl) {
        return this.settings == null ? dfl : this.settings.getString(name, dfl);
    }

    public void putSetting(String name, String val) {
        if (this.settings != null) {
            this.settings.edit().putString(name, val).apply();
        }
    }

    public JSONObject getJsonObjectSetting(String name, JSONObject dfl) {
        String curr = this.getSetting(name, "");
        if (curr.isEmpty()) {
            return dfl;
        }
        try {
            return new JSONObject(Gzip.decompressString(curr));
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, String.format("Malformed JSON preferences: %s", curr), e);
            return dfl;
        }
    }

    public void putJsonObjectSetting(String name, JSONObject val) {
        try {
            this.putSetting(name, Gzip.compressString(val.toString()));
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, String.format("Failed to update JSON preferences: %s", val), e);
        }
    }

    public long getLongSetting(String name, long dfl) {
        return this.settings == null ? dfl : this.settings.getLong(name, dfl);
    }

    public void putLongSetting(String name, long val) {
        if (this.settings != null) {
            this.settings.edit().putLong(name, val).apply();
        }
    }

    public ListeningScheduledExecutorService foreground() {
        return this.foreground;
    }

    public ListeningScheduledExecutorService background() {
        return this.background;
    }

    private static ListenableFuture<?> runNowOrSchedule(ListeningExecutorService exec, Runnable cmd, boolean now) {
        if (now) {
            try {
                cmd.run();
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
            return Futures.immediateVoidFuture();
        }
        return exec.submit(cmd);
    }

    private static <V> ListenableFuture<V> callNowOrSchedule(ListeningExecutorService exec, Callable<V> cmd, boolean now) {
        if (now) {
            try {
                return Futures.immediateFuture(cmd.call());
            }
            catch (Exception e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        return exec.submit(cmd);
    }

    public ListenableFuture<?> runInForeground(Runnable cmd) {
        return OriginMobile.runNowOrSchedule((ListeningExecutorService)this.foreground, cmd, Sync.isMainThread());
    }

    public <V> ListenableFuture<V> callInForeground(Callable<V> cmd) {
        return OriginMobile.callNowOrSchedule((ListeningExecutorService)this.foreground, cmd, Sync.isMainThread());
    }

    public ListenableFuture<?> runInBackground(Runnable cmd) {
        return OriginMobile.runNowOrSchedule((ListeningExecutorService)this.background, cmd, !Sync.isMainThread());
    }

    public <V> ListenableFuture<V> callInBackground(Callable<V> cmd) {
        return OriginMobile.callNowOrSchedule((ListeningExecutorService)this.background, cmd, !Sync.isMainThread());
    }

    public ListenableFuture<?> runPunting(Runnable cmd) {
        return this.foreground.submitPunting((Executor)this.background, cmd);
    }

    public <V> ListenableFuture<V> callPunting(Callable<V> cmd) {
        return this.foreground.submitPunting((Executor)this.background, cmd);
    }

    public ListenableFuture<?> runPuntingDelayed(Runnable cmd, long delay, TimeUnit unit) {
        return this.foreground.schedulePunting((Executor)this.background, cmd, delay, unit);
    }

    public <V> ListenableFuture<V> callPuntingDelayed(Callable<V> cmd, long delay, TimeUnit unit) {
        return this.foreground.schedulePunting((Executor)this.background, cmd, delay, unit);
    }

    public ListenableFuture<?> schedulePuntingWithFixedDelay(Runnable cmd, long initialDelay, long delay, TimeUnit unit) {
        return this.foreground.schedulePuntingWithFixedDelay((Executor)this.background, cmd, initialDelay, delay, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void descriptorsUpdated() {
        Consumer[] callbacks;
        Map<OriginModule, ProtobufMessage> updates;
        Lock read = this.descriptorsLock.readLock();
        read.lock();
        try {
            updates = Collections.unmodifiableMap(new IdentityHashMap<OriginModule, ProtobufMessage>(this.updatedDescriptors));
            callbacks = this.descriptorsUpdateCallbacks.keySet().toArray(new Consumer[0]);
            this.updatedDescriptors.clear();
        }
        finally {
            this.descriptorsUpdateFuture = null;
            read.unlock();
        }
        for (Consumer cb : callbacks) {
            try {
                cb.accept(updates);
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "descriptor update callback %s failed", cb, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDescriptorOf(OriginModule mod, ProtobufMessage desc) {
        DebugBuild.checkState(mod.sdk() == this);
        DebugBuild.log(TAG, "updating descriptor of %s to %s", mod, desc);
        Lock write = this.descriptorsLock.writeLock();
        write.lock();
        try {
            this.descriptors.put(mod, desc);
            this.updatedDescriptors.put(mod, desc);
            if (this.descriptorsUpdateFuture == null) {
                try {
                    this.descriptorsUpdateFuture = this.background.schedule(this::descriptorsUpdated, 10L, TimeUnit.MILLISECONDS);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        finally {
            write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ProtobufMessage descriptorOf(OriginModule mod) {
        DebugBuild.checkState(mod.sdk() == this);
        Lock read = this.descriptorsLock.readLock();
        read.lock();
        try {
            ProtobufMessage protobufMessage = this.descriptors.get(mod);
            return protobufMessage;
        }
        finally {
            read.unlock();
        }
    }

    public void registerDescriptorsUpdateCallback(Consumer<Map<OriginModule, ProtobufMessage>> cb) {
        Lock write = this.descriptorsLock.writeLock();
        write.lock();
        try {
            this.descriptorsUpdateCallbacks.put(cb, true);
        }
        finally {
            write.unlock();
        }
    }

    public void unregisterDescriptorsUpdateCallback(Consumer<Map<OriginModule, ProtobufMessage>> cb) {
        Lock write = this.descriptorsLock.writeLock();
        write.lock();
        try {
            this.descriptorsUpdateCallbacks.remove(cb);
        }
        finally {
            write.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <M extends OriginModule> M findModule(Class<M> type) {
        Lock lock = this.modulesLock.readLock();
        lock.lock();
        try {
            Object m = this.modules.get(type);
            OriginModule originModule = m instanceof OriginModule ? (OriginModule)m : null;
            return (M)originModule;
        }
        finally {
            lock.unlock();
        }
    }

    public <M extends OriginModule> M getModule(Class<M> type) {
        M mod = this.findModule(type);
        if (mod == null) {
            throw new IllegalArgumentException();
        }
        return mod;
    }

    private static OriginModule.Provider<?> newProvider(Class<? extends OriginModule> type) {
        Object res;
        try {
            res = type.getDeclaredMethod("ofProvider", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            res = e;
        }
        if (res instanceof Throwable) {
            throw new IllegalArgumentException(String.format("unable to access %s::ofProvider()", type.getSimpleName()), (Throwable)res);
        }
        if (!(res instanceof OriginModule.Provider)) {
            throw new IllegalArgumentException(String.format("%s::ofProvider() did not return a provider", type.getSimpleName()));
        }
        return (OriginModule.Provider)res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends OriginModule> Object loadModule(Lock lock, Class<M> type, OriginModule.Provider<M> prov) {
        if (!prov.type().isAssignableFrom(type)) {
            throw new IllegalArgumentException(String.format("%s provides module type %s, which is not assignable to %s", prov.getClass(), prov.type(), type));
        }
        Context ctxt = this.context();
        SettableFuture load = SettableFuture.create();
        this.modules.put(type, load);
        lock.unlock();
        Throwable rv = null;
        try {
            rv = (Throwable)prov.provide(this, ctxt);
            ((OriginModule)((Object)rv)).setup(ctxt);
            load.set((Object)rv);
        }
        catch (Throwable e) {
            if (rv != null) {
                try {
                    ((OriginModule)((Object)rv)).destroy();
                }
                catch (Throwable d) {
                    DebugBuild.log(TAG, "failed to destroy module", d);
                }
            }
            rv = e;
            load.setException(e);
        }
        finally {
            lock.lock();
        }
        if (rv instanceof OriginModule) {
            OriginModule mod = (OriginModule)((Object)rv);
            this.modules.remove(type);
            this.modules.put(type, mod);
            DebugBuild.log(TAG, "loaded module %s", mod);
        } else {
            this.modules.put(type, rv);
            DebugBuild.log(TAG, "failed to load module %s", type, rv);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends OriginModule> M loadModule(Class<M> type) {
        Object m;
        Sync.checkNonMainThread();
        Lock lock = this.modulesLock.writeLock();
        lock.lock();
        try {
            m = this.modules.get(type);
            if (m == null) {
                m = OriginMobile.newProvider(type);
            }
            if (m instanceof OriginModule.Provider) {
                m = this.loadModule(lock, type, (OriginModule.Provider<M>)m);
            }
            if (m instanceof Throwable) {
                throw new IllegalStateException("module failed to load", (Throwable)m);
            }
        }
        finally {
            lock.unlock();
        }
        if (m instanceof Future) {
            Future fut = (Future)m;
            try {
                m = fut.get(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(String.format("recursive dependency on %s detected", type));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException("module failed to load", e);
            }
        }
        return (M)((OriginModule)m);
    }

    @WorkerThread
    public <M extends OriginModule> M getOrLoadModuleSync(Class<M> type) {
        Sync.checkNonMainThread();
        M mod = this.findModule(type);
        return mod != null ? mod : this.loadModule(type);
    }

    public <M extends OriginModule> void getOrLoadModule(Class<M> type, BiConsumer<M, ? super Throwable> cons) {
        M mod = this.findModule(type);
        if (mod != null) {
            cons.accept(mod, null);
        } else {
            MoreFutures.addFallibleListener(this.background.submit(() -> this.getOrLoadModuleSync(type)), cons);
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.shutdownLatch.await(timeout, unit);
    }

    public void shutdown() {
        this.context.enqueue();
        this.context.clear();
    }

    public String toString() {
        return String.format("OriginMobile[%s]", this.startupId);
    }

    static {
        HisavanaBootstrap.bootstrap();
    }

    public static final class Initializer {
        @Nullable
        private IdentityHashMap<Class<? extends OriginModule>, OriginModule.Provider<?>> modules;
        @Nullable
        private Context context;
        @Nullable
        private AppDescriptor app;
        private boolean enableWebkitDataSpecialization = false;

        private Initializer() {
        }

        @ReturnThis
        public Initializer context(Context ctxt) {
            if (!(ctxt instanceof Application)) {
                ctxt = ctxt.getApplicationContext();
            }
            this.context = Objects.requireNonNull(ctxt);
            return this;
        }

        @ReturnThis
        public Initializer addModule(OriginModule.Provider<?> prov) {
            if (this.modules == null) {
                this.modules = new IdentityHashMap();
            }
            this.modules.put(prov.type(), prov);
            return this;
        }

        @ReturnThis
        public Initializer addModules(Iterable<OriginModule.Provider<?>> provs) {
            for (OriginModule.Provider<?> prov : provs) {
                this.addModule(prov);
            }
            return this;
        }

        @ReturnThis
        public Initializer app(@Nullable AppDescriptor app) {
            this.app = app;
            return this;
        }

        @ReturnThis
        public Initializer enableWebkitDataSpecialization(boolean enable) {
            this.enableWebkitDataSpecialization = enable;
            return this;
        }

        private AppDescriptor probeApp() {
            String pkg;
            PackageManager pman;
            Context ctxt = DebugBuild.checkNotNull(this.context);
            AppDescriptor.Builder base = this.app == null ? AppDescriptor.ofBuilder() : this.app.toBuilder();
            try {
                pman = ctxt.getPackageManager();
                pkg = Strings.nullToEmpty((String)ctxt.getPackageName());
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to probe application bundle", e);
                return base.build();
            }
            try {
                String name = ((CharSequence)MoreObjects.firstNonNull((Object)pman.getApplicationLabel(pman.getApplicationInfo(pkg, 0)), (Object)"")).toString();
                String ver = Strings.nullToEmpty((String)pman.getPackageInfo((String)pkg, (int)0).versionName);
                if (!pkg.isEmpty()) {
                    base.bundle(pkg);
                }
                if (!name.isEmpty()) {
                    base.name(name);
                }
                if (!ver.isEmpty()) {
                    base.version(ver);
                }
                base.processId(Process.myPid());
                base.processName(AndroidContexts.currentProcessName(ctxt));
                base.userId(Process.myUid());
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to probe application", e);
            }
            try {
                String installer = "";
                if (Build.VERSION.SDK_INT >= 30) {
                    InstallSourceInfo info = pman.getInstallSourceInfo(pkg);
                    installer = (String)MoreObjects.firstNonNull((Object)info.getInstallingPackageName(), (Object)((String)MoreObjects.firstNonNull((Object)info.getInitiatingPackageName(), (Object)((String)MoreObjects.firstNonNull((Object)info.getOriginatingPackageName(), (Object)"")))));
                }
                if (installer.isEmpty()) {
                    installer = Strings.nullToEmpty((String)pman.getInstallerPackageName(pkg));
                }
                base.installerBundle(installer);
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to probe application installer", e);
            }
            return base.build();
        }

        private void setupWebkit(OriginMobile sdk) {
            if (!this.enableWebkitDataSpecialization || Build.VERSION.SDK_INT < 28) {
                return;
            }
            String pname = sdk.app.processName();
            if (Strings.isNullOrEmpty((String)pname) || pname.equals(sdk.app.bundle())) {
                return;
            }
            String name = pname.replace('.', '_').replace(':', '-');
            try {
                WebView.setDataDirectorySuffix((String)name);
                DebugBuild.log(TAG, String.format("Set web view data directory suffix to: %s", name));
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "Failed to set web view data directory suffix", e);
            }
        }

        @MainThread
        public void initialize(BiConsumer<OriginMobile, ? super Throwable> cons) {
            ArrayList<Class<? extends OriginModule>> modTypes;
            Sync.checkMainThread();
            Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"context not specified");
            OriginMobile sdk = new OriginMobile(this);
            this.setupWebkit(sdk);
            ArrayList<Class<? extends OriginModule>> arrayList = modTypes = this.modules == null ? Collections.emptyList() : new ArrayList<Class<? extends OriginModule>>(this.modules.keySet());
            if (!modTypes.isEmpty()) {
                sdk.modules.putAll(this.modules);
            }
            MoreFutures.addFallibleListener(sdk.background.submit(() -> {
                for (Class modType : modTypes) {
                    sdk.getOrLoadModuleSync(modType);
                }
                OriginMobile.install(sdk);
            }), (ok, err) -> {
                DebugBuild.log(TAG, "initialization complete %s", sdk, err);
                try {
                    if (err != null) {
                        try {
                            if (sdk.settings != null) {
                                sdk.settings.edit().clear().apply();
                            }
                        }
                        finally {
                            sdk.shutdown();
                        }
                    }
                    cons.accept(err == null ? sdk : null, (Throwable)err);
                }
                catch (Throwable throwable) {
                    cons.accept(err == null ? sdk : null, (Throwable)err);
                    throw throwable;
                }
            });
        }

        @MainThread
        public void initialize() {
            this.initialize((ok, err) -> {
                if (err != null) {
                    DebugBuild.log(TAG, "failed to initialize", err);
                } else {
                    DebugBuild.log(TAG, "initialized new SDK instance");
                }
            });
        }
    }

    private final class ShutdownTrigger
    implements Runnable {
        private final ReferenceQueue<Context> queue = new ReferenceQueue();

        private ShutdownTrigger() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.queue.remove();
                }
                catch (InterruptedException e) {
                    DebugBuild.log(TAG, "cleaner reference dequeue interrupted", e);
                    if (OriginMobile.this.context.get() != null) continue;
                }
                break;
            }
            OriginMobile.this.doShutdown();
        }
    }
}

