/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.antifraud;

import androidx.annotation.Nullable;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

public final class AntiFraudDescriptor
implements ProtobufMessage {
    private static final int TAG_SIGNATURE = 1;
    private static final int TAG_STATUS = 2;
    private static final int TAG_CONFIDENCE = 3;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NOT_FRAUDULENT = 1;
    public static final int STATUS_MAYBE_FRAUDULENT = 2;
    public static final int STATUS_FRAUDULENT = 3;
    private final String signature;
    private final int status;
    private final float confidence;

    public AntiFraudDescriptor(String signature, int status, float confidence) {
        this.signature = signature;
        this.status = status;
        this.confidence = confidence;
    }

    @Override
    public AntiFraudDescriptor mergeFrom(ProtobufReader reader) {
        String sig = this.signature;
        int stat = this.status;
        float conf = this.confidence;
        block5: while (reader.hasRemaining()) {
            switch (reader.readTag()) {
                case 1: {
                    sig = reader.readUtf8();
                    continue block5;
                }
                case 2: {
                    stat = reader.readUnsignedInt();
                    continue block5;
                }
                case 3: {
                    conf = reader.readFixedFloat();
                    continue block5;
                }
            }
            reader.readAndDiscard();
        }
        return new AntiFraudDescriptor(sig, stat, conf);
    }

    @Override
    public void writeTo(ProtobufWriter writer) {
        writer.writeUtf8(1, this.signature).writeUnsignedInt(2, this.status).writeFixedFloat(3, this.confidence);
    }

    public String signature() {
        return this.signature;
    }

    public int status() {
        return this.status;
    }

    public float confidence() {
        return this.confidence;
    }

    JSONObject toJson() {
        JSONObject json = new JSONObject();
        try {
            json.put("_0", (Object)this.signature).put("_1", this.status).put("_2", (double)this.confidence);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json;
    }

    static AntiFraudDescriptor fromJson(JSONObject json) {
        return new AntiFraudDescriptor(json.optString("_0", ""), json.optInt("_1", 0), (float)json.optDouble("_2", 1.0));
    }

    public int hashCode() {
        return Objects.hash(this.signature, this.status, Float.valueOf(this.confidence));
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AntiFraudDescriptor)) {
            return false;
        }
        AntiFraudDescriptor that = (AntiFraudDescriptor)other;
        return Objects.equals(this.signature, that.signature) && this.status == that.status && this.confidence == that.confidence;
    }

    public String toString() {
        return super.toString();
    }
}

