/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.antifraud;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import androidx.core.util.Supplier;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.OriginModule;
import com.polygamma.ogm.antifraud.AntiFraudDescriptor;
import com.polygamma.ogm.antifraud.EntropyPool;
import com.polygamma.ogm.antifraud.ScriptExecutor;
import com.polygamma.ogm.device.DeviceModule;
import com.polygamma.ogm.location.LocationsModule;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.RemoteServiceModule;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.AndroidSettings;
import com.polygamma.ogm.util.Bits;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.MoreFutures;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.json.JSONObject;

public final class AntiFraudModule
extends OriginModule {
    private static final String TAG = AntiFraudModule.class.getSimpleName();
    private static final long DEFAULT_RECHECK_DELAY_MILLIS = TimeUnit.MINUTES.toMillis(5L);
    private static final long ERROR_RECHECK_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(35L);
    private static final long MAX_RECHECK_DELAY_MILLIS = TimeUnit.DAYS.toMillis(2L);
    @VisibleForTesting
    static final String NEXT_SEND_REQUEST_SETTINGS = "ogm_antifraud_next_send";
    @VisibleForTesting
    static final String PREVIOUS_DESCRIPTOR_SETTINGS = "ogm_antifraud_prev_desc";
    public static final int BUILD_ENTROPY = Bits.intMaskOf(0);
    public static final int TELEPHONY_ENTROPY = Bits.intMaskOf(1);
    public static final int SETTINGS_ENTROPY = Bits.intMaskOf(2);
    public static final int PACKAGE_ENTROPY = Bits.intMaskOf(3);
    private final int disabledEntropyMask;
    private final DeviceModule device;
    private final LocationsModule locations;
    private final ConnectivityModule connectivity;
    private final RemoteServiceModule remoteService;
    @VisibleForTesting
    final ScriptExecutor scriptExecutor;
    private final ConcurrentHashMap<String, ProtobufMessage> entropyDescriptors;
    @VisibleForTesting
    AntiFraudDescriptor descriptor;
    @VisibleForTesting
    @Nullable
    ListenableFuture<ByteBuffer> checkResponseFuture;
    @VisibleForTesting
    @Nullable
    ListenableFuture<?> checkRequestFuture;
    private boolean destroyed;

    public static OriginModule.Provider<AntiFraudModule> ofProvider(final int disabledEntropyMask) {
        return new OriginModule.Provider<AntiFraudModule>(AntiFraudModule.class){

            @Override
            public AntiFraudModule provide(OriginMobile sdk, Context ctxt) {
                return new AntiFraudModule(sdk, disabledEntropyMask);
            }
        };
    }

    public static OriginModule.Provider<AntiFraudModule> ofProvider() {
        return AntiFraudModule.ofProvider(0);
    }

    private AntiFraudModule(OriginMobile sdk, int disabledEntropyMask) {
        super("anti-fraud", sdk);
        this.disabledEntropyMask = disabledEntropyMask;
        this.device = sdk.getOrLoadModuleSync(DeviceModule.class);
        this.locations = sdk.getOrLoadModuleSync(LocationsModule.class);
        this.connectivity = sdk.getOrLoadModuleSync(ConnectivityModule.class);
        this.remoteService = sdk.getOrLoadModuleSync(RemoteServiceModule.class);
        this.scriptExecutor = new ScriptExecutor(this);
        this.entropyDescriptors = new ConcurrentHashMap();
        this.descriptor = new AntiFraudDescriptor("", 0, 1.0f);
    }

    public AntiFraudDescriptor descriptor() {
        return this.descriptor;
    }

    private static String inspectOne(Supplier<String> op) {
        try {
            return (String)op.get();
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    @SuppressLint(value={"HardwareIds"})
    private void generateBuildEntropy(EntropyPool dst, Context ctxt) {
        if ((this.disabledEntropyMask & BUILD_ENTROPY) != 0) {
            return;
        }
        dst.push(String.format("%s\u0001%s\u0000", BUILD_ENTROPY, Build.VERSION.SDK_INT < 26 ? Build.SERIAL : AntiFraudModule.inspectOne((Supplier<String>)((Supplier)Build::getSerial))));
    }

    @SuppressLint(value={"MissingPermission", "HardwareIds"})
    private void generateTelephonyEntropy(EntropyPool dst, Context ctxt) {
        if ((this.disabledEntropyMask & TELEPHONY_ENTROPY) != 0) {
            return;
        }
        TelephonyManager tele = AndroidContexts.systemServiceOf(ctxt, TelephonyManager.class, "phone");
        if (tele == null) {
            return;
        }
        Object[] objectArray = new Object[5];
        objectArray[0] = TELEPHONY_ENTROPY;
        objectArray[1] = AntiFraudModule.inspectOne((Supplier<String>)((Supplier)() -> Build.VERSION.SDK_INT >= 34 ? tele.getPrimaryImei() : (Build.VERSION.SDK_INT >= 26 ? tele.getImei() : tele.getDeviceId())));
        objectArray[2] = Build.VERSION.SDK_INT < 26 ? "" : AntiFraudModule.inspectOne((Supplier<String>)((Supplier)() -> ((TelephonyManager)tele).getSubscriberId()));
        Object object = objectArray[3] = Build.VERSION.SDK_INT < 26 ? "" : AntiFraudModule.inspectOne((Supplier<String>)((Supplier)() -> ((TelephonyManager)tele).getMeid()));
        objectArray[4] = (Build.VERSION.SDK_INT >= 26 ? AndroidContexts.hasAnyPermissions(ctxt, "android.permission.READ_PHONE_STATE", "android.permission.READ_PHONE_NUMBERS") : AndroidContexts.hasPermission(ctxt, "android.permission.READ_PHONE_STATE")) ? AntiFraudModule.inspectOne((Supplier<String>)((Supplier)() -> ((TelephonyManager)tele).getLine1Number())) : "";
        dst.push(String.format("%s\u0001%s\u0001%s\u0001%s\u0001%s\u0000", objectArray));
    }

    @SuppressLint(value={"HardwareIds"})
    private void generateSettingsEntropy(EntropyPool dst, Context ctxt) {
        if ((this.disabledEntropyMask & SETTINGS_ENTROPY) != 0) {
            return;
        }
        dst.push(String.format("%s\u0001%s\u0001%s\u0001%s\u0001%s\u0000", SETTINGS_ENTROPY, AndroidSettings.getSecureString(ctxt.getContentResolver(), "android_id").trim(), AndroidSettings.getSystemString("prop.sim1.imei").trim(), AndroidSettings.getSystemString("ro.tranos.version").trim(), AndroidSettings.getSystemString("ro.serialno").trim()));
    }

    @SuppressLint(value={"QueryPermissionsNeeded"})
    private void generatePackageEntropy(EntropyPool dst, Context ctxt) {
        if ((this.disabledEntropyMask & PACKAGE_ENTROPY) != 0) {
            return;
        }
        StringBuilder entropy = new StringBuilder();
        entropy.append(PACKAGE_ENTROPY).append('\u0001');
        if (AndroidContexts.hasPermission(ctxt, "android.permission.QUERY_ALL_PACKAGES")) {
            try {
                for (ApplicationInfo info : ctxt.getPackageManager().getInstalledApplications(0)) {
                    entropy.append('\u0001').append(Strings.nullToEmpty((String)info.packageName));
                }
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "Failed to probe packages");
            }
        }
        entropy.append('\u0000');
        dst.push(entropy.toString());
    }

    byte[] generateEntropy(boolean high, @Nullable byte[] extra) {
        ByteArrayOutputStream entropy = new ByteArrayOutputStream();
        EntropyPool pool = new EntropyPool((Consumer<ByteBuffer>)((Consumer)src -> entropy.write(src.array(), src.arrayOffset() + src.position(), src.arrayOffset() + src.limit())));
        ProtobufWriter prbf = new ProtobufWriter();
        try {
            Context ctxt = super.sdk().context();
            this.generateBuildEntropy(pool, ctxt);
            this.generateTelephonyEntropy(pool, ctxt);
            this.generateSettingsEntropy(pool, ctxt);
            this.generatePackageEntropy(pool, ctxt);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to generate inspect entropy", e);
        }
        if (high) {
            pool.push("high");
            if (Build.VERSION.SDK_INT >= 24) {
                this.entropyDescriptors.forEach((n, d) -> {
                    pool.push((String)n);
                    d.writeTo(prbf);
                    prbf.writeFixedInt(0x1FFFFFFF, 1640531527);
                    pool.push(prbf.finish());
                });
            } else {
                for (Map.Entry<String, ProtobufMessage> en : this.entropyDescriptors.entrySet()) {
                    pool.push(en.getKey());
                    en.getValue().writeTo(prbf);
                    prbf.writeFixedInt(0x1FFFFFFF, 1640531527);
                    pool.push(prbf.finish());
                }
            }
        }
        if (extra != null) {
            pool.push("extra");
            prbf.writeByteArray(1, extra);
            pool.push(prbf.finish());
        }
        pool.flush();
        return entropy.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCheck() {
        Future fut;
        AntiFraudModule antiFraudModule = this;
        synchronized (antiFraudModule) {
            if (this.destroyed) {
                return;
            }
            fut = (Future)DebugBuild.checkNotNull(this.checkResponseFuture);
            this.checkResponseFuture = null;
        }
        long delay = DEFAULT_RECHECK_DELAY_MILLIS;
        AntiFraudDescriptor result = this.descriptor;
        String script = "";
        int scriptType = 0;
        try {
            ProtobufReader prbf = new ProtobufReader((ByteBuffer)Futures.getDone((Future)fut));
            block14: while (prbf.hasRemaining()) {
                switch (prbf.readTag()) {
                    case 1: {
                        result = prbf.readMessage(result);
                        continue block14;
                    }
                    case 2: {
                        delay = prbf.readUnsignedLong();
                        continue block14;
                    }
                    case 3: {
                        script = prbf.readUtf8();
                        continue block14;
                    }
                    case 4: {
                        scriptType = prbf.readUnsignedInt();
                        continue block14;
                    }
                }
                prbf.readAndDiscard();
            }
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to process check response", e);
            delay = ERROR_RECHECK_DELAY_MILLIS;
        }
        if (result != this.descriptor) {
            this.descriptor = result;
            super.publishDescriptor(result);
            super.sdk().putJsonObjectSetting(PREVIOUS_DESCRIPTOR_SETTINGS, result.toJson());
        }
        if (!script.isEmpty()) {
            AntiFraudModule antiFraudModule2 = this;
            synchronized (antiFraudModule2) {
                if (!this.destroyed) {
                    ListenableFuture<byte[]> sfut = this.scriptExecutor.submit(script, scriptType);
                    sfut.addListener(() -> {
                        byte[] data;
                        try {
                            data = (byte[])sfut.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            data = "X".getBytes(StandardCharsets.UTF_8);
                        }
                        if (data != null) {
                            AntiFraudModule antiFraudModule = this;
                            synchronized (antiFraudModule) {
                                if (this.checkRequestFuture != null) {
                                    this.checkRequestFuture.cancel(false);
                                    this.checkRequestFuture = null;
                                }
                            }
                            this.sendCheckRequest(data);
                        }
                    }, (Executor)this.sdk().background());
                    DebugBuild.log(TAG, "scheduled execution of script `%s`", script);
                }
            }
        }
        this.scheduleSendCheckRequest(delay <= 0L ? DEFAULT_RECHECK_DELAY_MILLIS : delay);
    }

    private void probePermissions(ProtobufWriter dst) throws PackageManager.NameNotFoundException {
        Context ctxt = super.sdk().context();
        PackageManager pman = ctxt.getPackageManager();
        PackageInfo info = pman.getPackageInfo(super.sdk().app().bundle(), 4096);
        HashSet<Object> perms = new HashSet<Object>();
        perms.add("android.permission.READ_CONTACTS");
        perms.add("android.permission.ACCESS_FINE_LOCATION");
        perms.add("android.permission.ACCESS_COARSE_LOCATION");
        perms.add("android.permission.INSTALL_LOCATION_PROVIDER");
        if (info.requestedPermissions != null) {
            for (String perm : info.requestedPermissions) {
                if (Strings.isNullOrEmpty((String)perm)) continue;
                perms.add(perm);
            }
        }
        for (String string : perms) {
            if (!AndroidContexts.hasPermission(ctxt, string)) continue;
            dst.writeUtf8(102, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCheckRequest(@Nullable byte[] preempt) {
        ProtobufWriter rq = new ProtobufWriter();
        rq.writeMessage(1, super.sdk().app()).writeMessage(2, this.device.descriptor()).writeMessage(3, this.locations.descriptor()).writeMessage(4, this.connectivity.descriptor());
        try {
            this.probePermissions(rq);
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to probe permissions", e);
        }
        if (this.descriptor != null) {
            if (!Strings.isNullOrEmpty((String)this.descriptor.signature())) {
                rq.writeUtf8(100, this.descriptor.signature());
            }
            if (this.descriptor.status() == 2 && (double)this.descriptor.confidence() < 0.5) {
                rq.writeByteArray(101, this.generateEntropy(false, preempt));
                preempt = null;
            }
        }
        if (preempt != null) {
            rq.writeByteArray(101, this.generateEntropy(false, preempt));
        }
        AntiFraudModule antiFraudModule = this;
        synchronized (antiFraudModule) {
            this.checkRequestFuture = null;
            if (this.destroyed || this.checkResponseFuture != null) {
                return;
            }
            this.checkResponseFuture = this.remoteService.sendRequest(32781292443756643L, rq.finish());
        }
        this.checkResponseFuture.addListener(this::processCheck, (Executor)super.sdk().background());
        DebugBuild.log(TAG, "check request sent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleSendCheckRequest(long delayMillis) {
        delayMillis = Math.min(delayMillis, MAX_RECHECK_DELAY_MILLIS);
        super.sdk().putLongSetting(NEXT_SEND_REQUEST_SETTINGS, System.currentTimeMillis() + delayMillis);
        AntiFraudModule antiFraudModule = this;
        synchronized (antiFraudModule) {
            if (this.destroyed || this.checkRequestFuture != null) {
                return;
            }
            this.checkRequestFuture = super.sdk().background().schedule(() -> this.sendCheckRequest(null), delayMillis, TimeUnit.MILLISECONDS);
            DebugBuild.log(TAG, "next recheck in %dms", delayMillis);
        }
    }

    @Override
    protected void setup(Context ctxt) {
        super.sdk().registerDescriptorsUpdateCallback((Consumer<Map<OriginModule, ProtobufMessage>>)((Consumer)upd -> {
            if (Build.VERSION.SDK_INT >= 24) {
                upd.forEach((mod, desc) -> this.entropyDescriptors.put(mod.name(), (ProtobufMessage)desc));
            } else {
                for (Map.Entry en : upd.entrySet()) {
                    this.entropyDescriptors.put(((OriginModule)en.getKey()).name(), (ProtobufMessage)en.getValue());
                }
            }
        }));
        JSONObject prevDesc = super.sdk().getJsonObjectSetting(PREVIOUS_DESCRIPTOR_SETTINGS, new JSONObject());
        if (prevDesc.length() > 0) {
            this.descriptor = AntiFraudDescriptor.fromJson(prevDesc);
        }
        long now = System.currentTimeMillis();
        long when = super.sdk().getLongSetting(NEXT_SEND_REQUEST_SETTINGS, now);
        long delay = Math.max(when - now, 10L);
        if (delay > MAX_RECHECK_DELAY_MILLIS) {
            delay = 10L;
        }
        this.scheduleSendCheckRequest(delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy() {
        ArrayList futs = new ArrayList(2);
        AntiFraudModule antiFraudModule = this;
        synchronized (antiFraudModule) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            futs.add((Future<?>)this.checkRequestFuture);
            this.checkRequestFuture = null;
            futs.add((Future<?>)this.checkResponseFuture);
            this.checkResponseFuture = null;
        }
        MoreFutures.cancelAndAwaitAll(futs);
        this.scriptExecutor.destroy();
    }
}

