/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.antifraud;

import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.util.Supplier;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.util.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;

final class AsyncIvtStateMachine {
    private static final Object NULL = new Object();
    static final Object CONTEXT = new Object();
    static final Object BACKGROUND_EXECUTOR = new Object();
    static final Object FOREGROUND_EXECUTOR = new Object();
    static final int POP = 1;
    static final int PUSH = 2;
    static final int DUP = 3;
    static final int CALL = 4;
    static final int READ = 5;
    static final int WRITE = 6;
    private final OriginMobile sdk;
    private final ArrayList<Object> stack;

    AsyncIvtStateMachine(OriginMobile sdk) {
        this.sdk = sdk;
        this.stack = new ArrayList();
    }

    private void push(@Nullable Object value) {
        if (value == null) {
            value = NULL;
        }
        this.stack.add(value);
    }

    private Object pop() {
        Object rv = this.stack.remove(this.stack.size() - 1);
        if (rv == CONTEXT) {
            rv = this.sdk.context();
        } else if (rv == BACKGROUND_EXECUTOR) {
            rv = this.sdk.background();
        } else if (rv == FOREGROUND_EXECUTOR) {
            rv = this.sdk.foreground();
        } else if (rv == NULL) {
            rv = null;
        }
        return rv;
    }

    @WorkerThread
    @Nullable
    Object apply(int op, @Nullable Object value) throws Exception {
        Object rv;
        switch (op) {
            case 1: {
                rv = this.pop();
                break;
            }
            case 2: {
                rv = value;
                this.push(value);
                break;
            }
            case 3: {
                if (value == null) {
                    value = -1;
                }
                if ((Integer)value < 0) {
                    value = this.stack.size() + (Integer)value;
                }
                rv = this.stack.get((Integer)value);
                this.stack.add(rv);
                break;
            }
            case 4: {
                rv = Reflection.invokerOf((Member)value, (Supplier<Object>)((Supplier)this::pop)).get();
                if (value instanceof Method && Void.TYPE.equals(((Method)value).getReturnType())) break;
                this.push(rv);
                break;
            }
            case 5: {
                rv = Reflection.readerOf((Field)value, (Supplier<Object>)((Supplier)this::pop)).get();
                this.push(rv);
                break;
            }
            case 6: {
                rv = this.pop();
                Reflection.writerOf((Field)value, (Supplier<Object>)((Supplier)this::pop)).accept(rv);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return rv;
    }
}

