/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.antifraud;

import androidx.core.util.Consumer;
import com.polygamma.ogm.util.DebugBuild;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;

final class EntropyPool {
    private static final int GOLDEN_RATIO = 1640531527;
    private static final long GOLDEN_RATIO_LONG = 7046029254386353131L;
    private static final int ENTROPY_SIZE_BYTES = 4096;
    private final Consumer<ByteBuffer> consumer;
    private final ByteBuffer current;
    private long entropyBytes;

    EntropyPool(Consumer<ByteBuffer> consumer) {
        this.consumer = DebugBuild.checkNotNull(consumer);
        this.current = ByteBuffer.allocate(4096).order(ByteOrder.LITTLE_ENDIAN);
        ThreadLocalRandom rand = ThreadLocalRandom.current();
        for (int i = 0; i < 2; ++i) {
            this.current.putInt(rand.nextInt() * 1640531527);
        }
    }

    void push(ByteBuffer src) {
        if (!src.hasRemaining()) {
            src = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, 7046029254386353131L);
        } else if (src.order() != ByteOrder.LITTLE_ENDIAN) {
            src = src.duplicate().order(ByteOrder.LITTLE_ENDIAN);
        }
        ByteBuffer dst = this.current;
        do {
            if (!dst.hasRemaining()) {
                this.flush();
            }
            int a = 0;
            int b = 0;
            if (src.remaining() < 8) {
                int p = dst.position();
                dst.put(src).put((byte)0).position(p);
                a = dst.getInt(p);
                b = dst.getInt(p + 4);
            } else {
                a = src.getInt();
                b = src.getInt();
            }
            int c = dst.getInt(0) * 1640531527 ^ dst.getInt(4) * 1640531527;
            a += (b << 4 ^ b >>> 5) + b ^ c + dst.getInt((c & 1) * 4);
            dst.putInt(a).putInt(b += (a << 4 ^ a >>> 5) + a ^ c + dst.getInt((c >>> 11 & 1) * 4));
            this.entropyBytes += 8L;
        } while (src.hasRemaining());
    }

    void push(byte[] src, int off, int len) {
        this.push(ByteBuffer.wrap(src, off, len).order(ByteOrder.LITTLE_ENDIAN));
    }

    void push(byte[] src) {
        this.push(src, 0, src.length);
    }

    void push(String src) {
        this.push(src.getBytes(StandardCharsets.UTF_8));
    }

    void flush() {
        ByteBuffer dst = this.current;
        if (this.entropyBytes == 0L) {
            return;
        }
        dst.flip();
        this.consumer.accept((Object)dst);
        dst.clear();
        for (int i = 0; i < 2; ++i) {
            dst.putInt(dst.getInt(i * 4) * 1640531527);
        }
        this.entropyBytes = 0L;
    }
}

