/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.antifraud;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.util.Consumer;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.io.BaseEncoding;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.polygamma.ogm.antifraud.AntiFraudModule;
import com.polygamma.ogm.antifraud.AsyncIvtStateMachine;
import com.polygamma.ogm.antifraud.Content;
import com.polygamma.ogm.antifraud.ScriptWebView;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.MoreFutures;
import com.polygamma.ogm.util.Reflection;
import com.polygamma.ogm.util.Sync;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

final class ScriptExecutor {
    private static final String TAG = ScriptExecutor.class.getSimpleName();
    private static final long INSTALL_VIEW_ERROR_DELAY_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static final ListenableFuture<?> DESTROYED_FUTURE = Futures.immediateVoidFuture();
    private final AntiFraudModule module;
    private final CurrentActivity currentActivity;
    private final ReadWriteLock lock;
    @VisibleForTesting
    final LinkedTransferQueue<String> pendingScripts;
    @VisibleForTesting
    final AtomicReference<ExecutePendingTask> executePendingTask;
    @Nullable
    private WeakReference<ScriptWebView> viewReference;
    @VisibleForTesting
    @Nullable
    ListenableFuture<?> viewFuture;
    @Nullable
    private AsyncIvtStateMachine asyncStateMachine;

    ScriptExecutor(AntiFraudModule mod) {
        this.module = DebugBuild.checkNotNull(mod);
        this.currentActivity = new CurrentActivity();
        this.lock = Sync.newReadWriteLock();
        this.pendingScripts = new LinkedTransferQueue();
        this.executePendingTask = new AtomicReference();
        try {
            ((Application)mod.sdk().context()).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.currentActivity);
        }
        catch (Throwable err) {
            DebugBuild.log(TAG, "failed to install activity lifecycle callback", err);
        }
    }

    private AsyncIvtStateMachine currentAsyncStateMachine() {
        AsyncIvtStateMachine sm = this.asyncStateMachine;
        if (sm == null) {
            this.asyncStateMachine = sm = new AsyncIvtStateMachine(this.module.sdk());
        }
        return sm;
    }

    private void resetAsyncStateMachine() {
        this.asyncStateMachine = null;
    }

    @VisibleForTesting
    ScriptWebView currentView() {
        WeakReference<ScriptWebView> viewRef = this.viewReference;
        return viewRef == null ? null : (ScriptWebView)((Object)viewRef.get());
    }

    private void schedulePendingExecute(ScriptWebView view) {
        ExecutePendingTask upd;
        ExecutePendingTask exp;
        do {
            if ((exp = this.executePendingTask.get()) == null || exp.view != view) continue;
            return;
        } while (!this.executePendingTask.compareAndSet(exp, upd = new ExecutePendingTask(view)));
        this.module.sdk().foreground().execute((Runnable)upd);
        DebugBuild.log(TAG, "scheduled pending execute on %s", new Object[]{view});
    }

    @VisibleForTesting
    void resetView(ScriptWebView view) {
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            if (view != this.currentView()) {
                return;
            }
            DebugBuild.log(TAG, "reset view %s", new Object[]{view});
            this.viewReference = null;
            view.destroy();
            this.resetAsyncStateMachine();
            this.executePendingTask.set(null);
            if (this.viewFuture == null && !this.pendingScripts.isEmpty()) {
                this.scheduleInstallView(INSTALL_VIEW_ERROR_DELAY_MILLIS);
            }
        }
        finally {
            write.unlock();
        }
    }

    private static JSONObject requestOf(Uri url) throws JSONException {
        String rawReq = url.getQueryParameter("r");
        if (Strings.isNullOrEmpty((String)rawReq)) {
            throw new IllegalArgumentException();
        }
        return new JSONObject(new String(BaseEncoding.base64Url().decode((CharSequence)rawReq), StandardCharsets.UTF_8));
    }

    @WorkerThread
    private JSONObject evaluateStateMachine0(JSONObject req) throws Exception {
        Object val;
        int op;
        block26: {
            block24: {
                block25: {
                    op = req.getInt("op");
                    val = null;
                    if (!req.has("imm")) break block24;
                    Object object = val = req.isNull("imm") ? null : req.get("imm");
                    if (op == 4 || op == 5) break block25;
                    if (op != 6) break block26;
                }
                val = this.module.sdk().background().submit(() -> Reflection.resolverOfMember((String)val).get()).get(30L, TimeUnit.SECONDS);
                break block26;
            }
            if (req.has("opq")) {
                Object object = val = req.isNull("opq") ? null : req.optString("opq");
                if ("cx".equals(val)) {
                    val = AsyncIvtStateMachine.CONTEXT;
                } else if ("ax".equals(val)) {
                    val = this.currentActivity.current.get();
                } else if ("bg".equals(val)) {
                    val = AsyncIvtStateMachine.BACKGROUND_EXECUTOR;
                } else if ("fg".equals(val)) {
                    val = AsyncIvtStateMachine.FOREGROUND_EXECUTOR;
                }
            }
        }
        Object res = null;
        int status = 0;
        try {
            if (op == 0) {
                this.resetAsyncStateMachine();
            } else {
                res = this.currentAsyncStateMachine().apply(op, val);
            }
        }
        catch (Exception err) {
            status = 1;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 PrintStream msg = new PrintStream(out);){
                err.printStackTrace(msg);
                msg.flush();
                res = new String(out.toByteArray(), StandardCharsets.UTF_8);
            }
        }
        return new JSONObject().put("s", status).put("r", op == 1 && (res instanceof Boolean || res instanceof String || res instanceof Number) ? res : null);
    }

    @WorkerThread
    private byte[] evaluateStateMachine(JSONObject req) throws Exception {
        JSONArray arr = req.getJSONArray("ops");
        JSONArray stk = new JSONArray();
        for (int i = 0; i < arr.length(); ++i) {
            JSONObject res = this.evaluateStateMachine0(arr.getJSONObject(i));
            res.put("i", i);
            if (res.getInt("s") != 0) {
                stk.put((Object)res);
                break;
            }
            if (!res.has("r") || res.isNull("r")) continue;
            stk.put((Object)res);
        }
        return stk.toString().getBytes(StandardCharsets.UTF_8);
    }

    @WorkerThread
    @SuppressLint(value={"CheckResult"})
    private byte[] handleRequest(Uri url) {
        String path = Strings.nullToEmpty((String)url.getPath());
        try {
            if ("/entropy".equalsIgnoreCase(path)) {
                return this.module.generateEntropy(true, null);
            }
            if (path.startsWith("/cram")) {
                return Content.query(this.module.sdk().context(), ScriptExecutor.requestOf(url));
            }
            if (path.startsWith("/okayomit")) {
                return this.evaluateStateMachine(ScriptExecutor.requestOf(url));
            }
            return "UNKNOWN".getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception err) {
            throw new RuntimeException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    private void installView() {
        ScriptWebView view = null;
        Activity activity = (Activity)this.currentActivity.current.get();
        try {
            view = ScriptWebView.open(this.module.sdk(), activity, (Consumer<ScriptWebView>)((Consumer)this::resetView), (Function<Uri, byte[]>)((Function)this::handleRequest));
        }
        catch (Throwable err) {
            DebugBuild.log(TAG, "failed to open script web view", err);
            this.currentActivity.current.compareAndSet(activity, null);
        }
        Lock read = this.lock.readLock();
        Lock write = this.lock.writeLock();
        read.lock();
        try {
            if (view == null) {
                if (this.viewFuture != DESTROYED_FUTURE) {
                    this.viewFuture = null;
                    this.scheduleInstallView(INSTALL_VIEW_ERROR_DELAY_MILLIS);
                }
                return;
            }
            if (this.viewFuture == null || this.viewFuture == DESTROYED_FUTURE) {
                this.viewReference = new WeakReference<ScriptWebView>(view);
                return;
            }
        }
        finally {
            read.unlock();
        }
        write.lock();
        try {
            this.viewReference = new WeakReference<ScriptWebView>(view);
            DebugBuild.log(TAG, "installed view %s", new Object[]{view});
            this.schedulePendingExecute(view);
        }
        finally {
            this.viewFuture = null;
            write.unlock();
        }
    }

    private void scheduleInstallView(long delayMillis) {
        if (this.viewFuture == null) {
            this.viewFuture = this.module.sdk().foreground().schedule(this::installView, delayMillis, TimeUnit.MILLISECONDS);
            DebugBuild.log(TAG, "scheduling view install in %dms", delayMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenableFuture<byte[]> submit(String script, int scriptType) {
        if (scriptType == 1) {
            return this.module.sdk().callInBackground(() -> this.handleRequest(Uri.parse((String)script)));
        }
        boolean empty = this.pendingScripts.isEmpty();
        this.pendingScripts.add(script);
        if (!empty) {
            return Futures.immediateFuture(null);
        }
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            ScriptWebView view = this.currentView();
            if (view == null) {
                this.scheduleInstallView(0L);
            } else if (this.executePendingTask.get() == null) {
                this.schedulePendingExecute(view);
            }
        }
        finally {
            write.unlock();
        }
        return Futures.immediateFuture(null);
    }

    void submit(String script) {
        this.submit(script, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    void destroy() {
        ScriptWebView view;
        ListenableFuture<?> fut;
        Lock write = this.lock.writeLock();
        this.executePendingTask.set(null);
        write.lock();
        try {
            fut = this.viewFuture;
            if (fut == DESTROYED_FUTURE) {
                return;
            }
            this.viewFuture = DESTROYED_FUTURE;
        }
        finally {
            write.unlock();
        }
        MoreFutures.cancelAndAwait(fut);
        write.lock();
        try {
            this.pendingScripts.clear();
            view = this.currentView();
            this.viewReference = null;
        }
        finally {
            write.unlock();
        }
        if (view != null) {
            view.destroy();
        }
        this.resetAsyncStateMachine();
    }

    private final class CurrentActivity
    implements Application.ActivityLifecycleCallbacks {
        private final AtomicReference<Activity> current = new AtomicReference();

        private CurrentActivity() {
        }

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle bundle) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
            this.current.set(activity);
        }

        public void onActivityResumed(@NonNull Activity activity) {
            this.onActivityStarted(activity);
        }

        public void onActivityPaused(@NonNull Activity activity) {
            this.onActivityDestroyed(activity);
        }

        public void onActivityStopped(@NonNull Activity activity) {
            this.onActivityDestroyed(activity);
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle bundle) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
            this.current.compareAndSet(activity, null);
            Lock read = ScriptExecutor.this.lock.readLock();
            ScriptWebView swv = ScriptExecutor.this.currentView();
            if (swv != null && swv.activity() == activity) {
                ScriptExecutor.this.resetView(swv);
            }
        }
    }

    private final class ExecutePendingTask
    implements Runnable {
        private final ScriptWebView view;

        ExecutePendingTask(ScriptWebView view) {
            this.view = view;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @UiThread
        public void run() {
            ScriptExecutor exec = ScriptExecutor.this;
            try {
                while (exec.executePendingTask.get() == this && this.view == exec.currentView()) {
                    String script = exec.pendingScripts.poll();
                    if (script == null) {
                        Lock write = exec.lock.writeLock();
                        write.lock();
                        try {
                            if (!exec.pendingScripts.isEmpty()) {
                                continue;
                            }
                            break;
                        }
                        finally {
                            write.unlock();
                            continue;
                        }
                    }
                    this.view.executeScript(script);
                    DebugBuild.log(TAG, "executed script `%s`", script);
                }
            }
            finally {
                exec.executePendingTask.compareAndSet(this, null);
            }
        }
    }
}

