/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.antifraud;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.webkit.WebViewRenderProcess;
import android.webkit.WebViewRenderProcessClient;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.core.util.Consumer;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.Finalizer;
import com.polygamma.ogm.util.NonUiWebChromeClient;
import com.polygamma.ogm.util.Sync;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

final class ScriptWebView
extends WebViewClient {
    private static final String TAG = ScriptWebView.class.getSimpleName();
    private final OriginMobile sdk;
    @Nullable
    private final Activity activity;
    private final Consumer<ScriptWebView> onReset;
    private final Function<Uri, byte[]> handleRequest;
    private final WebView view;
    private final Runnable destroy;

    @UiThread
    static ScriptWebView open(OriginMobile sdk, @Nullable Activity activity, Consumer<ScriptWebView> onReset, Function<Uri, byte[]> handleRequest) {
        ScriptWebView swv = new ScriptWebView(sdk, activity, onReset, handleRequest);
        try {
            swv.prepare();
        }
        catch (Throwable err) {
            swv.destroy();
            throw new RuntimeException("failed to prepare view", err);
        }
        DebugBuild.log(TAG, "opened script web view with sdk=%s, activity=%s", sdk, activity);
        return swv;
    }

    @UiThread
    private ScriptWebView(OriginMobile sdk, @Nullable Activity activity, Consumer<ScriptWebView> onReset, Function<Uri, byte[]> handleRequest) {
        this.sdk = sdk;
        this.activity = activity;
        this.onReset = onReset;
        this.handleRequest = handleRequest;
        this.view = new WebView((Context)(activity != null ? activity : sdk.context()));
        this.destroy = Finalizer.register((Object)this, new DestroyWebView((Executor)sdk.foreground(), this.view));
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void prepare() {
        WebSettings settings = this.view.getSettings();
        settings.setCacheMode(2);
        settings.setDatabaseEnabled(false);
        settings.setDomStorageEnabled(false);
        settings.setJavaScriptCanOpenWindowsAutomatically(false);
        if (Build.VERSION.SDK_INT >= 26) {
            settings.setSafeBrowsingEnabled(false);
        }
        settings.setSupportMultipleWindows(false);
        settings.setSupportZoom(false);
        settings.setJavaScriptEnabled(true);
        settings.setMediaPlaybackRequiresUserGesture(false);
        this.view.setWillNotDraw(true);
        this.view.setWebViewClient((WebViewClient)this);
        this.view.setWebChromeClient((WebChromeClient)new NonUiWebChromeClient(){

            public void onCloseWindow(WebView wv) {
                ScriptWebView.this.onReset.accept((Object)ScriptWebView.this);
            }

            public boolean onConsoleMessage(ConsoleMessage msg) {
                DebugBuild.log(TAG, "script console message: %s", msg.message());
                return true;
            }

            @Override
            public void onGeolocationPermissionsShowPrompt(String origin, GeolocationPermissions.Callback cb) {
                boolean has = false;
                try {
                    has = AndroidContexts.hasAnyPermissions(ScriptWebView.this.sdk.context(), "android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION");
                }
                catch (Throwable e) {
                    DebugBuild.log(TAG, "failed to validate location permissions", e);
                }
                cb.invoke(origin, has, false);
            }
        });
        if (Build.VERSION.SDK_INT >= 29) {
            this.view.setWebViewRenderProcessClient(new WebViewRenderProcessClient(){

                public void onRenderProcessUnresponsive(WebView view, WebViewRenderProcess proc) {
                    ScriptWebView.this.onReset.accept((Object)ScriptWebView.this);
                }

                public void onRenderProcessResponsive(WebView view, WebViewRenderProcess proc) {
                }
            });
        }
        this.view.loadUrl("about:blank");
    }

    @Nullable
    Activity activity() {
        return this.activity;
    }

    void destroy() {
        this.destroy.run();
    }

    @UiThread
    void executeScript(String script) {
        this.view.evaluateJavascript(script, null);
    }

    public void onLoadResource(WebView wv, String url) {
        DebugBuild.log(TAG, "loaded resource %s", url);
        wv.clearHistory();
        super.onLoadResource(wv, url);
    }

    public void onPageFinished(WebView wv, String url) {
        wv.clearHistory();
        super.onPageFinished(wv, url);
    }

    public void onReceivedError(WebView wv, int code, String desc, String url) {
        DebugBuild.log(TAG, "web view error %d at `%s`: %s", code, url, desc);
    }

    @RequiresApi(value=23)
    public void onReceivedError(WebView wv, WebResourceRequest rq, WebResourceError err) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        DebugBuild.log(TAG, "web view error %s: %s", rq.getUrl(), err.getDescription());
    }

    @RequiresApi(value=26)
    public boolean onRenderProcessGone(WebView wv, RenderProcessGoneDetail detail) {
        if (Build.VERSION.SDK_INT < 26) {
            return false;
        }
        this.onReset.accept((Object)this);
        return true;
    }

    @SuppressLint(value={"CheckResult"})
    public WebResourceResponse shouldInterceptRequest(WebView wv, WebResourceRequest rq) {
        byte[] body;
        Uri url = rq.getUrl();
        if (!"GET".equalsIgnoreCase(rq.getMethod()) || !"ogm-sdk-svc".equalsIgnoreCase(url.getHost())) {
            return super.shouldInterceptRequest(wv, rq);
        }
        try {
            if (Strings.nullToEmpty((String)url.getPath()).equalsIgnoreCase("/reset")) {
                this.sdk.background().schedule(() -> this.onReset.accept((Object)this), 50L, TimeUnit.MILLISECONDS);
                body = "OK".getBytes(StandardCharsets.UTF_8);
            } else {
                body = (byte[])this.sdk.background().submit(() -> (byte[])this.handleRequest.apply((Object)url)).get(1L, TimeUnit.MINUTES);
            }
        }
        catch (Exception e) {
            DebugBuild.log(TAG, "failed to handle request", e);
            body = "ERROR".getBytes(StandardCharsets.UTF_8);
        }
        HashMap<String, String> hdrs = new HashMap<String, String>();
        hdrs.put("Access-Control-Allow-Origin", "*");
        hdrs.put("Access-Control-Allow-Methods", "GET, OPTIONS");
        hdrs.put("Access-Control-Max-Age", "600");
        hdrs.put("Access-Control-Allow-Headers", "Accept, Content-Type");
        return new WebResourceResponse("application/octet-stream", "utf-8", body == null ? 204 : 200, "OK", hdrs, (InputStream)new ByteArrayInputStream(body == null ? new byte[]{} : body));
    }

    private static /* synthetic */ void lambda$executeScript$0(String val) {
        DebugBuild.log(TAG, "script exited with `%s`", val);
    }

    private static final class DestroyWebView
    implements Runnable {
        private final Executor foreground;
        @Nullable
        private WebView view;

        DestroyWebView(Executor foreground, WebView view) {
            this.foreground = foreground;
            this.view = view;
        }

        @Override
        public void run() {
            if (!Sync.isMainThread()) {
                this.foreground.execute(this);
                return;
            }
            WebView wv = this.view;
            this.view = null;
            if (wv != null) {
                try {
                    wv.removeAllViews();
                    wv.clearHistory();
                    wv.loadUrl("about:blank");
                    wv.onPause();
                    wv.removeAllViews();
                    wv.destroyDrawingCache();
                }
                finally {
                    wv.destroy();
                }
            }
        }
    }
}

