/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.device;

import android.annotation.SuppressLint;
import android.graphics.Point;
import android.util.Pair;
import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import androidx.annotation.ReturnThis;
import com.google.auto.value.AutoBuilder;
import com.polygamma.ogm.device.AutoBuilder_DeviceDescriptor_Builder;
import com.polygamma.ogm.device.BootDescriptor;
import com.polygamma.ogm.device.BuildDescriptor;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class DeviceDescriptor
implements ProtobufMessage {
    private static final int TAG_TIMESTAMP_SECONDS = 1;
    private static final int TAG_TYPE = 2;
    private static final int TAG_CAPABILITIES = 3;
    private static final int TAG_BUILD = 4;
    private static final int TAG_BOOT = 5;
    private static final int TAG_IDS = 6;
    private static final int TAG_USER_AGENT = 7;
    private static final int TAG_LOCALE = 8;
    private static final int TAG_INPUT_LOCALES = 9;
    private static final int TAG_SCREEN_SIZE_DIPS = 10;
    private static final int TAG_SCREEN_PIXEL_RATIO = 11;
    private static final int TAG_NAME = 12;
    private static final int TAG_UTC_OFFSET_SECONDS = 13;
    private static final int TAG_EXT_CAPABILITIES = 500;
    public static final int CAPABILITY_BLUETOOTH = 0;
    public static final int CAPABILITY_WIFI = 1;
    public static final int CAPABILITY_ACCESSIBILITY = 2;
    public static final int CAPABILITY_AUTO_TIME_ZONE = 3;
    public static final int CAPABILITY_LIMIT_TRACKING = 4;
    public static final int CAPABILITY_FOLDABLE = 5;
    public static final int CAPABILITY_ADB = 100;
    private final long timestampSeconds;
    private final int type;
    private final String name;
    private final BuildDescriptor build;
    private final BootDescriptor boot;
    private final SparseBooleanArray capabilities;
    private final List<Pair<String, String>> ids;
    private final String userAgent;
    private final String locale;
    private final List<String> inputLocales;
    private final Point screenSizeDips;
    private final float screenPixelRatio;
    private final int utcOffsetSeconds;

    public static Builder ofBuilder() {
        return new AutoBuilder_DeviceDescriptor_Builder().timestampSeconds(0L).type(0).boot(BootDescriptor.ofBuilder().build()).build(BuildDescriptor.ofBuilder().build()).name("").capabilities(new SparseBooleanArray(5)).ids(Collections.emptyList()).userAgent("").locale("").inputLocales(Collections.emptyList()).screenSizeDips(new Point()).screenPixelRatio(0.0f).utcOffsetSeconds(0);
    }

    DeviceDescriptor(long timestampSeconds, int type, String name, BuildDescriptor build, BootDescriptor boot, SparseBooleanArray capabilities, List<Pair<String, String>> ids, String userAgent, String locale, List<String> inputLocales, Point screenSizeDips, float screenPixelRatio, int utcOffsetSeconds) {
        this.timestampSeconds = timestampSeconds;
        this.type = type;
        this.name = name;
        this.build = build;
        this.boot = boot;
        this.capabilities = capabilities;
        this.ids = ids;
        this.userAgent = userAgent;
        this.locale = locale;
        this.inputLocales = inputLocales;
        this.screenSizeDips = screenSizeDips;
        this.screenPixelRatio = screenPixelRatio;
        this.utcOffsetSeconds = utcOffsetSeconds;
    }

    public boolean hasCapability(int cap) {
        return this.capabilities.get(cap);
    }

    @Override
    @SuppressLint(value={"WrongConstant"})
    public DeviceDescriptor mergeFrom(ProtobufReader reader) {
        Builder builder = this.toBuilder().capabilities(this.capabilities);
        block15: while (reader.hasRemaining()) {
            int tag = reader.readTag();
            switch (tag) {
                case 1: {
                    builder.timestampSeconds(reader.readFixedLong());
                    break;
                }
                case 2: {
                    builder.type(reader.readUnsignedInt());
                    break;
                }
                case 3: 
                case 500: {
                    SparseBooleanArray caps = builder.capabilities();
                    BitSet set = BitSet.valueOf(reader.readByteBufferView());
                    if (caps == this.capabilities) {
                        caps = new SparseBooleanArray();
                        builder.capabilities(caps);
                    }
                    int i = set.nextSetBit(0);
                    while (i != -1) {
                        builder.capability(tag == 500 ? i + 500 : i, true);
                        i = set.nextSetBit(i + 1);
                    }
                    continue block15;
                }
                case 4: {
                    builder.build(reader.readMessage(this.build));
                    break;
                }
                case 5: {
                    builder.boot(reader.readMessage(this.boot));
                    break;
                }
                case 6: {
                    List<Pair<String, String>> ids = builder.ids();
                    if (ids == this.ids) {
                        ids = new ArrayList<Pair<String, String>>(1);
                        builder.ids(ids);
                    }
                    ids.add(reader.readUtf8Pair());
                    break;
                }
                case 7: {
                    builder.userAgent(reader.readUtf8());
                    break;
                }
                case 8: {
                    builder.locale(reader.readUtf8());
                    break;
                }
                case 9: {
                    List<String> codes = builder.inputLocales();
                    if (codes == this.inputLocales) {
                        codes = new ArrayList<String>(1);
                        builder.inputLocales(codes);
                    }
                    codes.add(reader.readUtf8());
                    break;
                }
                case 10: {
                    long sz = reader.readFixedLong();
                    builder.screenSizeDips(new Point((int)(sz & 0xFFFFFFFFL), (int)(sz >>> 32)));
                    break;
                }
                case 11: {
                    builder.screenPixelRatio(reader.readFixedFloat());
                    break;
                }
                case 12: {
                    builder.name(reader.readUtf8());
                    break;
                }
                case 13: {
                    builder.utcOffsetSeconds(reader.readInt());
                    break;
                }
                default: {
                    reader.readAndDiscard();
                }
            }
        }
        return builder.build();
    }

    @Override
    public void writeTo(ProtobufWriter writer) {
        BitSet stdCaps = new BitSet();
        BitSet extCaps = new BitSet();
        for (int i = 0; i < this.capabilities.size(); ++i) {
            int k = this.capabilities.keyAt(i);
            if (!this.capabilities.valueAt(i)) continue;
            if (k >= 500) {
                extCaps.set(k - 500);
                continue;
            }
            stdCaps.set(k);
        }
        writer.writeFixedLong(1, this.timestampSeconds).writeUnsignedInt(2, this.type).writeByteArray(3, stdCaps.toByteArray()).writeMessage(4, this.build).writeMessage(5, this.boot).writeUtf8(7, this.userAgent).writeUtf8(8, this.locale).writeFixedLong(10, Integer.toUnsignedLong(this.screenSizeDips.x) | Integer.toUnsignedLong(this.screenSizeDips.y) << 32).writeFixedFloat(11, this.screenPixelRatio).writeUtf8(12, this.name).writeInt(13, this.utcOffsetSeconds).writeByteArray(500, extCaps.toByteArray());
        for (Pair<String, String> id : this.ids) {
            writer.writeUtf8Pair(6, id);
        }
        for (String lo : this.inputLocales) {
            writer.writeUtf8(9, lo);
        }
    }

    public Builder toBuilder() {
        return new AutoBuilder_DeviceDescriptor_Builder(this).capabilities(this.capabilities.clone());
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public int type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public BuildDescriptor build() {
        return this.build;
    }

    public BootDescriptor boot() {
        return this.boot;
    }

    public SparseBooleanArray capabilities() {
        return this.capabilities;
    }

    public List<Pair<String, String>> ids() {
        return this.ids;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public String locale() {
        return this.locale;
    }

    public List<String> inputLocales() {
        return this.inputLocales;
    }

    public Point screenSizeDips() {
        return this.screenSizeDips;
    }

    public float screenPixelRatio() {
        return this.screenPixelRatio;
    }

    public int utcOffsetSeconds() {
        return this.utcOffsetSeconds;
    }

    public int hashCode() {
        return Long.hashCode(this.timestampSeconds);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DeviceDescriptor)) {
            return false;
        }
        DeviceDescriptor that = (DeviceDescriptor)other;
        return this.timestampSeconds == that.timestampSeconds && this.type == that.type && Objects.equals(this.name, that.name) && Objects.equals(this.build, that.build) && Objects.equals(this.boot, that.boot) && Objects.equals(this.capabilities, that.capabilities) && Objects.equals(this.ids, that.ids) && Objects.equals(this.userAgent, that.userAgent) && Objects.equals(this.locale, that.locale) && Objects.equals(this.inputLocales, that.inputLocales) && Objects.equals(this.screenSizeDips, that.screenSizeDips) && this.screenPixelRatio == that.screenPixelRatio && this.utcOffsetSeconds == that.utcOffsetSeconds;
    }

    public String toString() {
        return super.toString();
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        @ReturnThis
        public abstract Builder timestampSeconds(long var1);

        @ReturnThis
        public abstract Builder type(int var1);

        @ReturnThis
        public abstract Builder name(String var1);

        @ReturnThis
        public abstract Builder build(BuildDescriptor var1);

        @ReturnThis
        public abstract Builder boot(BootDescriptor var1);

        abstract SparseBooleanArray capabilities();

        abstract Builder capabilities(SparseBooleanArray var1);

        public Builder capability(int cap, boolean has) {
            SparseBooleanArray caps = this.capabilities();
            if (has) {
                caps.put(cap, true);
            } else {
                caps.delete(cap);
            }
            return this;
        }

        public Builder clearCapabilities() {
            this.capabilities().clear();
            return this;
        }

        abstract List<Pair<String, String>> ids();

        @ReturnThis
        public abstract Builder ids(List<Pair<String, String>> var1);

        @ReturnThis
        public abstract Builder userAgent(String var1);

        @ReturnThis
        public abstract Builder locale(String var1);

        abstract List<String> inputLocales();

        @ReturnThis
        public abstract Builder inputLocales(List<String> var1);

        @ReturnThis
        public abstract Builder screenSizeDips(Point var1);

        @ReturnThis
        public abstract Builder screenPixelRatio(float var1);

        @ReturnThis
        public abstract Builder utcOffsetSeconds(int var1);

        abstract DeviceDescriptor autoBuild();

        public DeviceDescriptor build() {
            return this.autoBuild();
        }
    }
}

