/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.device;

import android.content.Context;
import android.util.Pair;
import androidx.annotation.Nullable;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.OriginModule;
import com.polygamma.ogm.device.DeviceDescriptor;
import com.polygamma.ogm.device.IdfaClient;
import com.polygamma.ogm.device.Probe;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.MoreFutures;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class DeviceModule
extends OriginModule {
    private static final String TAG = DeviceModule.class.getSimpleName();
    private static final long DEFAULT_UPDATE_DELAY_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
    private final IdfaClient[] idfaClients;
    private final long updateDelaySeconds;
    @Nullable
    private Future<?> updateFuture;
    @Nullable
    private DeviceDescriptor descriptor;

    public static Provider ofProvider() {
        return new Provider();
    }

    private DeviceModule(OriginMobile sdk, Context ctxt, Provider prov) {
        super("device", sdk);
        IdfaClient[] idfa = prov.idfaClients.values().toArray(new IdfaClient[0]);
        if (idfa.length == 0) {
            try {
                idfa = new IdfaClient[]{IdfaClient.ofGooglePlay(ctxt)};
            }
            catch (UnsupportedOperationException e) {
                DebugBuild.log(TAG, "GMS client not available", e);
            }
        }
        this.idfaClients = idfa;
        this.updateDelaySeconds = prov.updateDelaySeconds;
    }

    public DeviceDescriptor descriptor() {
        return DebugBuild.checkNotNull(this.descriptor);
    }

    private void publishDescriptor(DeviceDescriptor.Builder desc) {
        this.descriptor = desc.timestampSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
        super.publishDescriptor(this.descriptor);
    }

    private void updateIdfa(DeviceDescriptor.Builder dst, Context ctxt) {
        boolean lmt = false;
        ArrayList<Pair<String, String>> ids = new ArrayList<Pair<String, String>>();
        for (IdfaClient client : this.idfaClients) {
            IdfaClient.Response resp = null;
            try {
                resp = client.sendRequest(super.sdk(), ctxt);
            }
            catch (Exception e) {
                DebugBuild.log(TAG, "failed to probe device id", e);
            }
            if (resp == null) continue;
            lmt |= resp.limitTracking();
            if (resp.id().isEmpty()) continue;
            ids.add((Pair<String, String>)new Pair((Object)client.idType(), (Object)resp.id()));
        }
        dst.capability(4, lmt).ids(ids);
        DebugBuild.log(TAG, "updated IDFAs: %s", ids);
    }

    private void update() {
        Context ctxt;
        try {
            ctxt = super.sdk().context();
        }
        catch (IllegalStateException ignored) {
            return;
        }
        DeviceDescriptor.Builder desc = Probe.update(DebugBuild.checkNotNull(this.descriptor), ctxt);
        this.updateIdfa(desc, ctxt);
        this.publishDescriptor(desc);
    }

    @Override
    protected void setup(Context ctxt) {
        DeviceDescriptor.Builder desc = Probe.initial(ctxt);
        this.updateIdfa(desc, ctxt);
        this.publishDescriptor(desc);
        this.updateFuture = super.sdk().schedulePuntingWithFixedDelay(this::update, this.updateDelaySeconds, this.updateDelaySeconds, TimeUnit.SECONDS);
    }

    @Override
    protected void destroy() {
        Future<?> fut = this.updateFuture;
        this.updateFuture = null;
        MoreFutures.cancelAndAwait(fut);
    }

    public static final class Provider
    extends OriginModule.Provider<DeviceModule> {
        private long updateDelaySeconds = DeviceModule.access$000();
        private final HashMap<String, IdfaClient> idfaClients = new HashMap();

        private Provider() {
            super(DeviceModule.class);
        }

        public Provider updateDelay(long delay, TimeUnit unit) {
            Preconditions.checkArgument((delay >= 0L ? 1 : 0) != 0);
            long s = unit.toSeconds(delay);
            if (s == 0L) {
                s = DEFAULT_UPDATE_DELAY_SECONDS;
            }
            this.updateDelaySeconds = s;
            return this;
        }

        public Provider addIdfaClient(IdfaClient client) {
            this.idfaClients.put(client.idType(), client);
            return this;
        }

        @Override
        protected DeviceModule provide(OriginMobile sdk, Context ctxt) {
            return new DeviceModule(sdk, ctxt, this);
        }
    }
}

