/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.device;

import android.content.Context;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.device.IdfaClient;

final class GmsIdfaClient
implements IdfaClient {
    GmsIdfaClient() {
    }

    @Override
    public String idType() {
        return "aaid";
    }

    @Override
    public IdfaClient.Response sendRequest(OriginMobile sdk, Context ctxt) throws Exception {
        GoogleApiAvailabilityLight gms = GoogleApiAvailabilityLight.getInstance();
        Preconditions.checkState((gms.isGooglePlayServicesAvailable(ctxt) == 0 ? 1 : 0) != 0, (Object)"GMS not available");
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)ctxt);
        String idfa = Strings.nullToEmpty((String)info.getId());
        if (idfa.matches("^[-0]+$")) {
            idfa = "";
        }
        return new IdfaClient.Response(idfa, info.isLimitAdTrackingEnabled());
    }
}

