/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.device;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.UiModeManager;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.os.SystemClock;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodInfo;
import android.view.inputmethod.InputMethodManager;
import android.view.inputmethod.InputMethodSubtype;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.polygamma.ogm.device.BootDescriptor;
import com.polygamma.ogm.device.BuildDescriptor;
import com.polygamma.ogm.device.DeviceDescriptor;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.AndroidSettings;
import com.polygamma.ogm.util.DebugBuild;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

class Probe {
    private static final String TAG = Probe.class.getSimpleName();

    @VisibleForTesting
    static BuildDescriptor build(Context ctxt) {
        Function norm = x -> "unknown".equals(Strings.nullToEmpty((String)x)) ? "" : x;
        BuildDescriptor.Builder builder = BuildDescriptor.ofBuilder().make((String)norm.apply((Object)Build.MANUFACTURER)).model((String)norm.apply((Object)Build.MODEL)).operatingSystemVersion((String)norm.apply((Object)Build.VERSION.RELEASE)).supportedAbis(String.join((CharSequence)",", Build.SUPPORTED_ABIS)).logicalProcessors(Runtime.getRuntime().availableProcessors());
        builder.totalMemoryBytes(AndroidContexts.withSystemService(ctxt, ActivityManager.class, "activity", act -> {
            ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
            act.getMemoryInfo(mem);
            return mem.totalMem;
        }, 0L));
        return builder.build();
    }

    @VisibleForTesting
    static BootDescriptor boot(Context ctxt) {
        BootDescriptor.Builder builder = BootDescriptor.ofBuilder().timestampSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - SystemClock.elapsedRealtime())).count(Build.VERSION.SDK_INT < 24 ? -1 : AndroidSettings.getGlobalInt(ctxt.getContentResolver(), "boot_count", -1));
        try {
            File file = new File("/proc/sys/kernel/random/boot_id");
            List<String> lines = Build.VERSION.SDK_INT >= 26 ? Files.readAllLines(file.toPath(), StandardCharsets.UTF_8) : com.google.common.io.Files.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            builder.id(String.join((CharSequence)"", lines).trim());
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "failed to probe boot_id", e);
            builder.id("");
        }
        return builder.build();
    }

    @VisibleForTesting
    static void type(DeviceDescriptor.Builder dst, Context ctxt) {
        int type;
        int n = AndroidContexts.hasSystemFeature(ctxt, "android.hardware.type.watch") || AndroidContexts.hasSystemFeature(ctxt, "android.hardware.type.automotive") ? 6 : (type = AndroidContexts.hasSystemFeature(ctxt, "android.software.leanback") || AndroidContexts.hasSystemFeature(ctxt, "android.hardware.type.television") ? 3 : 0);
        if (type == 0) {
            type = AndroidContexts.withSystemService(ctxt, UiModeManager.class, "uimode", ui -> {
                switch (ui.getCurrentModeType()) {
                    case 5: 
                    case 6: 
                    case 7: {
                        return 6;
                    }
                    case 4: {
                        return 3;
                    }
                }
                return 0;
            }, 0);
        }
        if (type == 0) {
            type = 1;
        }
        dst.type(type);
    }

    @VisibleForTesting
    @SuppressLint(value={"MissingPermission"})
    static void name(DeviceDescriptor.Builder dst, Context ctxt) {
        String name = "";
        if (AndroidContexts.hasPermission(ctxt, "android.permission.BLUETOOTH") && (Build.VERSION.SDK_INT < 31 || AndroidContexts.hasPermission(ctxt, "android.permission.BLUETOOTH_CONNECT"))) {
            if (Build.VERSION.SDK_INT >= 31) {
                name = AndroidContexts.withSystemService(ctxt, BluetoothManager.class, "bluetooth", bt -> bt.getAdapter().getName(), "");
            } else {
                try {
                    name = Strings.nullToEmpty((String)BluetoothAdapter.getDefaultAdapter().getName());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (name.isEmpty() && Build.VERSION.SDK_INT >= 25) {
            name = AndroidSettings.getGlobalString(ctxt.getContentResolver(), "device_name");
        }
        dst.name(name);
    }

    @VisibleForTesting
    static void languages(DeviceDescriptor.Builder dst, Context ctxt) {
        dst.locale(Locale.getDefault().toLanguageTag()).inputLocales(AndroidContexts.withSystemService(ctxt, InputMethodManager.class, "input_method", man -> {
            HashSet<String> set = new HashSet<String>();
            for (InputMethodInfo meth : man.getEnabledInputMethodList()) {
                for (InputMethodSubtype sub : man.getEnabledInputMethodSubtypeList(meth, true)) {
                    String tag = Build.VERSION.SDK_INT >= 24 ? sub.getLanguageTag() : sub.getLocale();
                    if (Strings.isNullOrEmpty((String)tag)) continue;
                    set.add(tag);
                }
            }
            return set.isEmpty() ? Collections.emptyList() : new ArrayList(set);
        }, Collections.emptyList()));
    }

    @VisibleForTesting
    static void settings(DeviceDescriptor.Builder dst, Context ctxt) {
        ContentResolver resv = ctxt.getContentResolver();
        dst.capability(0, AndroidSettings.getGlobalBoolean(resv, "bluetooth_on")).capability(1, AndroidSettings.getGlobalBoolean(resv, "wifi_on")).capability(2, AndroidSettings.getSecureBoolean(resv, "accessibility_enabled")).capability(3, AndroidSettings.getGlobalBoolean(resv, "auto_time_zone")).capability(100, AndroidSettings.getGlobalBoolean(resv, "adb_enabled")).capability(5, Build.VERSION.SDK_INT >= 30 && AndroidContexts.hasSystemFeature(ctxt, "android.hardware.sensor.hinge_angle"));
    }

    @VisibleForTesting
    static void screen(DeviceDescriptor.Builder dst, Context ctxt) {
        dst.screenPixelRatio(ctxt.getResources().getDisplayMetrics().density).screenSizeDips(AndroidContexts.withSystemService(ctxt, WindowManager.class, "window", wm -> {
            Point size = new Point();
            wm.getDefaultDisplay().getRealSize(size);
            return size;
        }, new Point()));
    }

    static DeviceDescriptor.Builder initial(Context ctxt) {
        DeviceDescriptor.Builder dst = DeviceDescriptor.ofBuilder().build(Probe.build(ctxt)).boot(Probe.boot(ctxt));
        Probe.type(dst, ctxt);
        Probe.name(dst, ctxt);
        Probe.languages(dst, ctxt);
        Probe.settings(dst, ctxt);
        Probe.screen(dst, ctxt);
        return dst;
    }

    static DeviceDescriptor.Builder update(DeviceDescriptor src, Context ctxt) {
        DeviceDescriptor.Builder dst = src.toBuilder();
        Probe.type(dst, ctxt);
        Probe.name(dst, ctxt);
        Probe.languages(dst, ctxt);
        Probe.settings(dst, ctxt);
        Probe.screen(dst, ctxt);
        return dst;
    }

    private Probe() {
    }
}

