/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.location;

import android.location.Location;
import android.os.Build;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.util.concurrent.TimeUnit;

public final class LocationDescriptor
implements ProtobufMessage {
    private static final int TAG_TIMESTAMP_SECONDS = 1;
    private static final int TAG_LATITUDE_DEGREES = 2;
    private static final int TAG_LONGITUDE_DEGREES = 3;
    private static final int TAG_ALTITUDE_METERS = 4;
    private static final int TAG_SPEED_METERS_PER_SECOND = 5;
    private static final int TAG_HORIZONTAL_ACCURACY_METERS = 6;
    private static final int TAG_VERTICAL_ACCURACY_METERS = 7;
    private static final int TAG_SPEED_ACCURACY_METERS_PER_SECOND = 8;
    private final long timestampSeconds;
    private final double latitudeDegrees;
    private final double longitudeDegrees;
    private final double altitudeMeters;
    private final float speedMetersPerSecond;
    private final float horizontalAccuracyMeters;
    private final float verticalAccuracyMeters;
    private final float speedAccuracyMetersPerSecond;

    public static LocationDescriptor of() {
        return new LocationDescriptor(0L, Double.NaN, Double.NaN, Double.NaN, Float.NaN, Float.NaN, Float.NaN, Float.NaN);
    }

    public static LocationDescriptor ofLocation(Location loc) {
        long now = System.currentTimeMillis();
        long age = 0L;
        if (Build.VERSION.SDK_INT >= 33) {
            long nowRt = SystemClock.elapsedRealtime();
            age = loc.getElapsedRealtimeAgeMillis(nowRt);
        } else {
            age = TimeUnit.NANOSECONDS.toMillis(SystemClock.elapsedRealtimeNanos() - loc.getElapsedRealtimeNanos());
        }
        return new LocationDescriptor(TimeUnit.MILLISECONDS.toSeconds(now - age), loc.getLatitude(), loc.getLongitude(), loc.hasAltitude() ? loc.getAltitude() : Double.NaN, loc.hasSpeed() ? loc.getSpeed() : Float.NaN, loc.hasAccuracy() ? loc.getAccuracy() : Float.NaN, Build.VERSION.SDK_INT >= 26 && loc.hasVerticalAccuracy() ? loc.getVerticalAccuracyMeters() : Float.NaN, Build.VERSION.SDK_INT >= 26 && loc.hasSpeedAccuracy() ? loc.getSpeedAccuracyMetersPerSecond() : Float.NaN);
    }

    LocationDescriptor(long timestampSeconds, double latitudeDegrees, double longitudeDegrees, double altitudeMeters, float speedMetersPerSecond, float horizontalAccuracyMeters, float verticalAccuracyMeters, float speedAccuracyMetersPerSecond) {
        this.timestampSeconds = timestampSeconds;
        this.latitudeDegrees = latitudeDegrees;
        this.longitudeDegrees = longitudeDegrees;
        this.altitudeMeters = altitudeMeters;
        this.speedMetersPerSecond = speedMetersPerSecond;
        this.horizontalAccuracyMeters = horizontalAccuracyMeters;
        this.verticalAccuracyMeters = verticalAccuracyMeters;
        this.speedAccuracyMetersPerSecond = speedAccuracyMetersPerSecond;
    }

    @Override
    public LocationDescriptor mergeFrom(ProtobufReader reader) {
        long ts = this.timestampSeconds;
        double lat = this.latitudeDegrees;
        double lon = this.longitudeDegrees;
        double alt = this.altitudeMeters;
        float speed = this.speedMetersPerSecond;
        float acc = this.horizontalAccuracyMeters;
        float aacc = this.verticalAccuracyMeters;
        float sacc = this.speedAccuracyMetersPerSecond;
        block10: while (reader.hasRemaining()) {
            switch (reader.readTag()) {
                case 1: {
                    ts = reader.readFixedLong();
                    continue block10;
                }
                case 2: {
                    lat = reader.readFixedDouble();
                    continue block10;
                }
                case 3: {
                    lon = reader.readFixedDouble();
                    continue block10;
                }
                case 4: {
                    alt = reader.readFixedDouble();
                    continue block10;
                }
                case 5: {
                    speed = reader.readFixedFloat();
                    continue block10;
                }
                case 6: {
                    acc = reader.readFixedFloat();
                    continue block10;
                }
                case 7: {
                    aacc = reader.readFixedFloat();
                    continue block10;
                }
                case 8: {
                    sacc = reader.readFixedFloat();
                    continue block10;
                }
            }
            reader.readAndDiscard();
        }
        return new LocationDescriptor(ts, lat, lon, alt, speed, acc, aacc, sacc);
    }

    @Override
    public void writeTo(ProtobufWriter writer) {
        writer.writeFixedLong(1, this.timestampSeconds).writeFixedDouble(2, this.latitudeDegrees).writeFixedDouble(3, this.longitudeDegrees).writeFixedDouble(4, this.altitudeMeters).writeFixedFloat(5, this.speedMetersPerSecond).writeFixedFloat(6, this.horizontalAccuracyMeters).writeFixedFloat(7, this.verticalAccuracyMeters).writeFixedFloat(8, this.speedAccuracyMetersPerSecond);
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public double latitudeDegrees() {
        return this.latitudeDegrees;
    }

    public double longitudeDegrees() {
        return this.longitudeDegrees;
    }

    public boolean hasHorizontal() {
        return !Double.isNaN(this.latitudeDegrees) && !Double.isNaN(this.longitudeDegrees);
    }

    public double altitudeMeters() {
        return this.altitudeMeters;
    }

    public boolean hasVertical() {
        return !Double.isNaN(this.altitudeMeters);
    }

    public float horizontalAccuracyMeters() {
        return this.horizontalAccuracyMeters;
    }

    public boolean hasHorizontalAccuracy() {
        return !Float.isNaN(this.horizontalAccuracyMeters);
    }

    public float verticalAccuracyMeters() {
        return this.verticalAccuracyMeters;
    }

    public boolean hasVerticalAccuracy() {
        return !Float.isNaN(this.verticalAccuracyMeters);
    }

    public float speedMetersPerSecond() {
        return this.speedMetersPerSecond;
    }

    public boolean hasSpeed() {
        return !Float.isNaN(this.speedMetersPerSecond);
    }

    public float speedAccuracyMetersPerSecond() {
        return this.speedAccuracyMetersPerSecond;
    }

    public boolean hasSpeedAccuracy() {
        return !Float.isNaN(this.speedAccuracyMetersPerSecond);
    }

    public boolean isEmpty() {
        return this.equals(LocationDescriptor.of());
    }

    public int hashCode() {
        return Long.hashCode(this.timestampSeconds);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LocationDescriptor)) {
            return false;
        }
        LocationDescriptor that = (LocationDescriptor)other;
        return this.timestampSeconds == that.timestampSeconds && Double.doubleToLongBits(this.latitudeDegrees) == Double.doubleToLongBits(that.latitudeDegrees) && Double.doubleToLongBits(this.longitudeDegrees) == Double.doubleToLongBits(that.longitudeDegrees) && Double.doubleToLongBits(this.altitudeMeters) == Double.doubleToLongBits(that.altitudeMeters) && Float.floatToIntBits(this.speedMetersPerSecond) == Float.floatToIntBits(that.speedMetersPerSecond) && Float.floatToIntBits(this.horizontalAccuracyMeters) == Float.floatToIntBits(that.horizontalAccuracyMeters) && Float.floatToIntBits(this.verticalAccuracyMeters) == Float.floatToIntBits(that.verticalAccuracyMeters) && Float.floatToIntBits(this.speedAccuracyMetersPerSecond) == Float.floatToIntBits(that.speedAccuracyMetersPerSecond);
    }

    public String toString() {
        return super.toString();
    }
}

