/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.location;

import androidx.annotation.Nullable;
import com.polygamma.ogm.location.LocationDescriptor;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.util.Objects;

public final class LocationsDescriptor
implements ProtobufMessage {
    private static final int TAG_TIMESTAMP_SECONDS = 1;
    private static final int TAG_GPS = 2;
    private static final int TAG_NETWORK = 3;
    private long timestampSeconds;
    private LocationDescriptor gps;
    private LocationDescriptor network;

    public LocationsDescriptor(long ts, LocationDescriptor gps, LocationDescriptor net) {
        this.timestampSeconds = ts;
        this.gps = gps;
        this.network = net;
    }

    @Override
    public LocationsDescriptor mergeFrom(ProtobufReader reader) {
        long ts = this.timestampSeconds;
        LocationDescriptor gps = this.gps;
        LocationDescriptor net = this.network;
        block5: while (reader.hasRemaining()) {
            switch (reader.readTag()) {
                case 1: {
                    ts = reader.readFixedLong();
                    continue block5;
                }
                case 2: {
                    gps = reader.readMessage(this.gps);
                    continue block5;
                }
                case 3: {
                    net = reader.readMessage(this.network);
                    continue block5;
                }
            }
            reader.readAndDiscard();
        }
        return new LocationsDescriptor(ts, gps, net);
    }

    @Override
    public void writeTo(ProtobufWriter writer) {
        writer.writeFixedLong(1, this.timestampSeconds);
        if (!this.gps.isEmpty()) {
            writer.writeMessage(2, this.gps);
        }
        if (!this.network.isEmpty()) {
            writer.writeMessage(3, this.network);
        }
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public LocationDescriptor gps() {
        return this.gps;
    }

    public LocationDescriptor network() {
        return this.network;
    }

    public int hashCode() {
        return Long.hashCode(this.timestampSeconds);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof LocationsDescriptor)) {
            return false;
        }
        LocationsDescriptor that = (LocationsDescriptor)other;
        return this.timestampSeconds == that.timestampSeconds && Objects.equals(this.gps, that.gps) && Objects.equals(this.network, that.network);
    }

    public String toString() {
        return super.toString();
    }
}

