/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.location;

import android.annotation.SuppressLint;
import android.content.Context;
import android.location.Location;
import android.location.LocationManager;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.OriginModule;
import com.polygamma.ogm.location.LocationDescriptor;
import com.polygamma.ogm.location.LocationsDescriptor;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.MoreFutures;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class LocationsModule
extends OriginModule {
    private static final String TAG = LocationsModule.class.getSimpleName();
    private static final long DEFAULT_UPDATE_DELAY_MILLIS = TimeUnit.MINUTES.toMillis(30L);
    @Nullable
    private final LocationManager manager;
    private final long updateDelayMillis;
    @VisibleForTesting
    @Nullable
    Future<?> updateFuture;
    private LocationsDescriptor descriptor;

    public static Provider ofProvider() {
        return new Provider();
    }

    private LocationsModule(OriginMobile sdk, Context ctxt, Provider prov) {
        super("locations", sdk);
        this.manager = prov.disable ? null : AndroidContexts.systemServiceOf(ctxt, LocationManager.class, "location");
        this.updateDelayMillis = prov.updateDelayMillis;
    }

    public LocationsDescriptor descriptor() {
        return DebugBuild.checkNotNull(this.descriptor);
    }

    private void publishDescriptor(LocationDescriptor gps, LocationDescriptor net) {
        long now = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
        LocationsDescriptor curr = this.descriptor;
        if (curr != null) {
            if (Long.compareUnsigned(gps.timestampSeconds(), curr.gps().timestampSeconds()) < 0) {
                gps = curr.gps();
            }
            if (Long.compareUnsigned(net.timestampSeconds(), curr.network().timestampSeconds()) < 0) {
                net = curr.network();
            }
        }
        this.descriptor = new LocationsDescriptor(now, gps, net);
        super.publishDescriptor(this.descriptor);
    }

    @SuppressLint(value={"MissingPermission"})
    private void updateLocationsWithLastKnown() {
        LocationManager mgr = this.manager;
        if (mgr == null) {
            DebugBuild.log(TAG, "last known location unavailable");
            this.publishDescriptor(LocationDescriptor.of(), LocationDescriptor.of());
            return;
        }
        String[] provs = new String[]{"gps", "network"};
        LocationDescriptor[] descs = new LocationDescriptor[provs.length];
        for (int i = 0; i < provs.length; ++i) {
            LocationDescriptor desc = null;
            try {
                Location loc;
                if (mgr.isProviderEnabled(provs[i]) && (loc = mgr.getLastKnownLocation(provs[i])) != null) {
                    desc = LocationDescriptor.ofLocation(loc);
                }
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to probe last known location from %s", provs[i], e);
            }
            descs[i] = desc == null ? LocationDescriptor.of() : desc;
        }
        this.publishDescriptor(descs[0], descs[1]);
    }

    @Override
    protected void setup(Context ctxt) {
        this.updateLocationsWithLastKnown();
        if (this.manager != null) {
            this.updateFuture = super.sdk().background().scheduleWithFixedDelay(this::updateLocationsWithLastKnown, this.updateDelayMillis, this.updateDelayMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    protected void destroy() {
        Future<?> updFut = this.updateFuture;
        this.updateFuture = null;
        MoreFutures.cancelAndAwait(updFut);
    }

    public static final class Provider
    extends OriginModule.Provider<LocationsModule> {
        private boolean disable;
        private long updateDelayMillis = LocationsModule.access$000();

        private Provider() {
            super(LocationsModule.class);
        }

        public Provider disable() {
            this.disable = true;
            return this;
        }

        public Provider updateDelay(long delay, TimeUnit unit) {
            Preconditions.checkArgument((delay >= 0L ? 1 : 0) != 0);
            long ms = unit.toMillis(delay);
            this.updateDelayMillis = ms == 0L ? DEFAULT_UPDATE_DELAY_MILLIS : ms;
            return this;
        }

        @Override
        protected LocationsModule provide(OriginMobile sdk, Context ctxt) {
            return new LocationsModule(sdk, ctxt, this);
        }
    }
}

