/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import androidx.annotation.Nullable;
import androidx.annotation.ReturnThis;
import com.google.auto.value.AutoBuilder;
import com.google.common.base.Preconditions;
import com.polygamma.ogm.net.AutoBuilder_ConnectivityDescriptor_Builder;
import com.polygamma.ogm.net.NetworkDescriptor;
import com.polygamma.ogm.net.SubscriptionDescriptor;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ConnectivityDescriptor
implements ProtobufMessage {
    private static final int TAG_TIMESTAMP_SECONDS = 1;
    private static final int TAG_NETWORKS = 2;
    private static final int TAG_ACTIVE_NETWORK_INDEX = 3;
    private static final int TAG_SUBSCRIPTIONS = 4;
    private static final int TAG_ACTIVE_SUBSCRIPTION_INDEX = 5;
    private static final int TAG_MMS_USER_AGENT = 6;
    private final long timestampSeconds;
    private final List<NetworkDescriptor> networks;
    private final int activeNetworkIndex;
    private final List<SubscriptionDescriptor> subscriptions;
    private final int activeSubscriptionIndex;
    private final String mmsUserAgent;

    public static Builder ofBuilder() {
        return new AutoBuilder_ConnectivityDescriptor_Builder().timestampSeconds(0L).networks(Collections.emptyList()).activeNetworkIndex(-1).subscriptions(Collections.emptyList()).activeSubscriptionIndex(-1).mmsUserAgent("");
    }

    ConnectivityDescriptor(long timestampSeconds, List<NetworkDescriptor> networks, int activeNetworkIndex, List<SubscriptionDescriptor> subscriptions, int activeSubscriptionIndex, String mmsUserAgent) {
        this.timestampSeconds = timestampSeconds;
        this.networks = networks;
        this.activeNetworkIndex = activeNetworkIndex;
        this.subscriptions = subscriptions;
        this.activeSubscriptionIndex = activeSubscriptionIndex;
        this.mmsUserAgent = mmsUserAgent;
    }

    @Override
    public ConnectivityDescriptor mergeFrom(ProtobufReader reader) {
        Builder builder = this.toBuilder();
        block8: while (reader.hasRemaining()) {
            switch (reader.readTag()) {
                case 1: {
                    builder.timestampSeconds(reader.readFixedLong());
                    continue block8;
                }
                case 2: {
                    builder.networks(reader.readRepeatedMessage(builder.networks(), this.networks, NetworkDescriptor.ofBuilder().build()));
                    continue block8;
                }
                case 3: {
                    builder.activeNetworkIndex(reader.readInt());
                    continue block8;
                }
                case 4: {
                    builder.subscriptions(reader.readRepeatedMessage(builder.subscriptions(), this.subscriptions, SubscriptionDescriptor.ofBuilder().build()));
                    continue block8;
                }
                case 5: {
                    builder.activeSubscriptionIndex(reader.readInt());
                    continue block8;
                }
                case 6: {
                    builder.mmsUserAgent(reader.readUtf8());
                    continue block8;
                }
            }
            reader.readAndDiscard();
        }
        return builder.build();
    }

    @Override
    public void writeTo(ProtobufWriter writer) {
        writer.writeFixedLong(1, this.timestampSeconds).writeRepeatedMessage(2, this.networks).writeInt(3, this.activeNetworkIndex).writeRepeatedMessage(4, this.subscriptions).writeInt(5, this.activeSubscriptionIndex).writeUtf8(6, this.mmsUserAgent);
    }

    public Builder toBuilder() {
        return new AutoBuilder_ConnectivityDescriptor_Builder(this);
    }

    public long timestampSeconds() {
        return this.timestampSeconds;
    }

    public List<NetworkDescriptor> networks() {
        return this.networks;
    }

    public int activeNetworkIndex() {
        return this.activeNetworkIndex;
    }

    @Nullable
    public NetworkDescriptor activeNetwork() {
        int idx = this.activeNetworkIndex;
        return idx == -1 ? null : this.networks.get(idx);
    }

    public List<SubscriptionDescriptor> subscriptions() {
        return this.subscriptions;
    }

    public int activeSubscriptionIndex() {
        return this.activeSubscriptionIndex;
    }

    @Nullable
    public SubscriptionDescriptor activeSubscription() {
        int idx = this.activeSubscriptionIndex;
        return idx == -1 ? null : this.subscriptions.get(idx);
    }

    public String mmsUserAgent() {
        return this.mmsUserAgent;
    }

    public int hashCode() {
        return Objects.hash(this.timestampSeconds, this.networks, this.activeNetworkIndex, this.subscriptions, this.activeSubscriptionIndex, this.mmsUserAgent);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof ConnectivityDescriptor)) {
            return false;
        }
        ConnectivityDescriptor that = (ConnectivityDescriptor)other;
        return this.timestampSeconds == that.timestampSeconds && Objects.equals(this.networks, that.networks) && this.activeNetworkIndex == that.activeNetworkIndex && Objects.equals(this.subscriptions, that.subscriptions) && this.activeSubscriptionIndex == that.activeSubscriptionIndex && Objects.equals(this.mmsUserAgent, that.mmsUserAgent);
    }

    public String toString() {
        return super.toString();
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        @ReturnThis
        public abstract Builder timestampSeconds(long var1);

        abstract List<NetworkDescriptor> networks();

        @ReturnThis
        public abstract Builder networks(List<NetworkDescriptor> var1);

        abstract int activeNetworkIndex();

        @ReturnThis
        public abstract Builder activeNetworkIndex(int var1);

        abstract List<SubscriptionDescriptor> subscriptions();

        @ReturnThis
        public abstract Builder subscriptions(List<SubscriptionDescriptor> var1);

        abstract int activeSubscriptionIndex();

        @ReturnThis
        public abstract Builder activeSubscriptionIndex(int var1);

        @ReturnThis
        public abstract Builder mmsUserAgent(String var1);

        abstract ConnectivityDescriptor autoBuild();

        public ConnectivityDescriptor build() {
            int anidx = this.activeNetworkIndex();
            int asidx = this.activeSubscriptionIndex();
            Preconditions.checkState(((anidx == -1 || anidx >= 0 && anidx < this.networks().size()) && (asidx == -1 || asidx >= 0 && asidx < this.subscriptions().size()) ? 1 : 0) != 0);
            return this.autoBuild();
        }
    }
}

