/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.OriginModule;
import com.polygamma.ogm.net.ConnectivityDescriptor;
import com.polygamma.ogm.net.DescriptorUpdater;
import com.polygamma.ogm.net.NetworksUpdater;
import com.polygamma.ogm.net.NetworksUpdaterN;
import com.polygamma.ogm.net.SubscriptionsUpdater;
import com.polygamma.ogm.net.SubscriptionsUpdaterLollipopMr1;
import com.polygamma.ogm.net.SubscriptionsUpdaterS;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.MoreFutures;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public final class ConnectivityModule
extends OriginModule {
    private static final String TAG = ConnectivityModule.class.getSimpleName();
    private static final long DEFAULT_POLL_DELAY_SECONDS = 30L;
    private final long pollDelaySeconds;
    @Nullable
    private final ConnectivityManager connectivity;
    @Nullable
    private final TelephonyManager telephony;
    private final IdentityHashMap<DescriptorUpdater, Boolean> pollingUpdaters;
    @VisibleForTesting
    final LinkedHashMap<DescriptorUpdater, Boolean> pendingUpdaters;
    @VisibleForTesting
    @Nullable
    DescriptorUpdater[] updaters;
    @Nullable
    private ConnectivityDescriptor descriptor;
    @VisibleForTesting
    @Nullable
    Future<?> updateFuture;
    @VisibleForTesting
    @Nullable
    Future<?> pollingFuture;

    public static Provider ofProvider() {
        return new Provider();
    }

    private ConnectivityModule(OriginMobile sdk, Context ctxt, Provider prov) {
        super("connectivity", sdk);
        this.pollDelaySeconds = prov.pollDelaySeconds;
        this.connectivity = AndroidContexts.systemServiceOf(ctxt, ConnectivityManager.class, "connectivity");
        this.telephony = AndroidContexts.hasSystemFeature(ctxt, "android.hardware.telephony") ? AndroidContexts.systemServiceOf(ctxt, TelephonyManager.class, "phone") : null;
        this.pollingUpdaters = new IdentityHashMap();
        this.pendingUpdaters = new LinkedHashMap();
    }

    ConnectivityManager connectivity() {
        DebugBuild.checkState(this.connectivity != null);
        return this.connectivity;
    }

    TelephonyManager telephony() {
        DebugBuild.checkState(this.telephony != null);
        return this.telephony;
    }

    public ConnectivityDescriptor descriptor() {
        return DebugBuild.checkNotNull(this.descriptor);
    }

    private void publishDescriptor(ConnectivityDescriptor.Builder desc) {
        this.descriptor = desc.timestampSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
        super.publishDescriptor(this.descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOneUpdate(ConnectivityDescriptor.Builder dst, Context ctxt, DescriptorUpdater updater, boolean polling) {
        boolean async = false;
        DebugBuild.log(TAG, "applying updater %s", updater);
        try {
            async = updater.update(dst, ctxt);
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)"descriptor updater failed", (Throwable)e);
        }
        if (polling && async) {
            ConnectivityModule connectivityModule = this;
            synchronized (connectivityModule) {
                this.pollingUpdaters.remove(updater);
            }
            DebugBuild.log(TAG, "promoted updater %s to async", updater);
        } else if (!polling && !async) {
            ConnectivityModule connectivityModule = this;
            synchronized (connectivityModule) {
                this.pollingUpdaters.put(updater, true);
            }
            DebugBuild.log(TAG, "demoted updater %s to polling", updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Context ctxt) {
        ConnectivityDescriptor.Builder builder = DebugBuild.checkNotNull(this.descriptor).toBuilder();
        while (true) {
            DescriptorUpdater updater;
            boolean polling = false;
            ConnectivityModule connectivityModule = this;
            synchronized (connectivityModule) {
                if (this.updateFuture == null) {
                    break;
                }
                Iterator<DescriptorUpdater> iter = this.pendingUpdaters.keySet().iterator();
                if (!iter.hasNext()) {
                    break;
                }
                updater = iter.next();
                this.pendingUpdaters.remove(updater);
                polling = this.pollingUpdaters.containsKey(updater);
            }
            this.doOneUpdate(builder, ctxt, updater, polling);
        }
        this.publishDescriptor(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update() {
        if (this.descriptor == null) {
            ConnectivityModule connectivityModule = this;
            synchronized (connectivityModule) {
                Future<?> fut = this.updateFuture;
                if (fut != null) {
                    this.updateFuture = super.sdk().background().schedule(this::update, 10L, TimeUnit.MILLISECONDS);
                    DebugBuild.log(TAG, "rescheduled update");
                } else {
                    DebugBuild.log(TAG, "update cancelled");
                }
            }
            return;
        }
        try {
            Context ctxt;
            try {
                ctxt = super.sdk().context();
            }
            catch (IllegalStateException ignored) {
                this.updateFuture = null;
                return;
            }
            this.doUpdate(ctxt);
        }
        catch (Throwable e) {
            Log.w((String)TAG, (String)"descriptor update failed", (Throwable)e);
        }
        finally {
            this.updateFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void poll() {
        ConnectivityModule connectivityModule = this;
        synchronized (connectivityModule) {
            for (DescriptorUpdater upd : this.pollingUpdaters.keySet()) {
                DebugBuild.log(TAG, "scheduling %s for polling update", upd);
                this.updateAvailable(upd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateAvailable(DescriptorUpdater updater) {
        ConnectivityModule connectivityModule = this;
        synchronized (connectivityModule) {
            if (this.updaters == null) {
                return;
            }
            Boolean has = this.pendingUpdaters.put(updater, true);
            if (has == null) {
                DebugBuild.log(TAG, "scheduling %s for update", updater);
            }
            if (this.updateFuture != null) {
                return;
            }
            try {
                this.updateFuture = super.sdk().runPunting(this::update);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void setup(Context ctxt) {
        ArrayList<DescriptorUpdater> upds = new ArrayList<DescriptorUpdater>();
        if (this.connectivity != null) {
            upds.add(Build.VERSION.SDK_INT >= 24 ? new NetworksUpdaterN(this) : new NetworksUpdater(this));
        }
        if (this.telephony != null) {
            upds.add(Build.VERSION.SDK_INT >= 31 ? new SubscriptionsUpdaterS(this, ctxt) : (Build.VERSION.SDK_INT >= 22 ? new SubscriptionsUpdaterLollipopMr1(this, ctxt) : new SubscriptionsUpdater(this)));
        }
        for (DescriptorUpdater upd : upds) {
            DebugBuild.log(TAG, "installed updater %s", upd);
        }
        this.updaters = upds.toArray(new DescriptorUpdater[0]);
        ConnectivityDescriptor.Builder desc = ConnectivityDescriptor.ofBuilder();
        for (DescriptorUpdater upd : this.updaters) {
            this.doOneUpdate(desc, ctxt, upd, false);
        }
        if (this.telephony != null && AndroidContexts.hasPermission(ctxt, "android.permission.READ_PHONE_STATE")) {
            desc.mmsUserAgent(Strings.nullToEmpty((String)this.telephony.getMmsUserAgent()));
        }
        this.publishDescriptor(desc);
        this.pollingFuture = super.sdk().background().scheduleWithFixedDelay(this::poll, this.pollDelaySeconds, this.pollDelaySeconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroy() {
        ArrayList futs = new ArrayList(2);
        DescriptorUpdater[] descriptorUpdaterArray = this;
        synchronized (this) {
            DescriptorUpdater[] updaters = this.updaters;
            this.pollingUpdaters.clear();
            this.pendingUpdaters.clear();
            this.updaters = null;
            if (this.updateFuture != null) {
                futs.add(this.updateFuture);
                this.updateFuture = null;
            }
            if (this.pollingFuture != null) {
                futs.add(this.pollingFuture);
                this.pollingFuture = null;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            MoreFutures.cancelAndAwaitAll(futs);
            if (updaters != null) {
                for (DescriptorUpdater upd : updaters) {
                    try {
                        upd.close();
                    }
                    catch (Exception e) {
                        Log.w((String)TAG, (String)"failed to close updater", (Throwable)e);
                    }
                }
            }
            return;
        }
    }

    public static final class Provider
    extends OriginModule.Provider<ConnectivityModule> {
        private long pollDelaySeconds = 30L;

        private Provider() {
            super(ConnectivityModule.class);
        }

        public Provider pollDelay(long delay, TimeUnit unit) {
            Preconditions.checkArgument((delay >= 0L ? 1 : 0) != 0);
            long secs = unit.toSeconds(delay);
            if (secs == 0L) {
                secs = 30L;
            }
            this.pollDelaySeconds = secs;
            return this;
        }

        @Override
        protected ConnectivityModule provide(OriginMobile sdk, Context ctxt) {
            return new ConnectivityModule(sdk, ctxt, this);
        }
    }
}

