/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.util.SparseBooleanArray;
import androidx.annotation.Nullable;
import androidx.annotation.ReturnThis;
import com.google.auto.value.AutoBuilder;
import com.polygamma.ogm.net.AutoBuilder_NetworkDescriptor_Builder;
import com.polygamma.ogm.util.Bits;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class NetworkDescriptor
implements ProtobufMessage {
    private static final int TAG_CONNECTION_TYPES = 1;
    private static final int TAG_CAPABILITIES = 2;
    private static final int TAG_DOWNSTREAM_KBPS = 3;
    private static final int TAG_UPSTREAM_KBPS = 4;
    private static final int TAG_LINK_NAMES = 5;
    private static final int TAG_HTTP_PROXY_HOST = 6;
    private static final int TAG_BSSID = 7;
    private static final int TAG_INTERFACE_NAME = 8;
    private static final int TAG_INTERFACE_ADDRESS = 9;
    public static final int CAPABILITY_VALIDATED = 0;
    public static final int CAPABILITY_INTERNET = 1;
    public static final int CAPABILITY_MMS = 2;
    public static final int CAPABILITY_NOT_ROAMING = 3;
    public static final int CAPABILITY_UNMETERED = 4;
    private final SparseBooleanArray connectionTypes;
    private final byte capabilities;
    private final int downstreamKbps;
    private final int upstreamKbps;
    private final List<InetAddress> linkNames;
    private final String httpProxyHost;
    private final String bssid;
    private final String interfaceName;
    private final String interfaceAddress;

    public static Builder ofBuilder() {
        return new AutoBuilder_NetworkDescriptor_Builder().connectionTypes(new SparseBooleanArray()).capabilities((byte)0).downstreamKbps(0).upstreamKbps(0).linkNames(Collections.emptyList()).httpProxyHost("").bssid("").interfaceName("").interfaceAddress("");
    }

    NetworkDescriptor(SparseBooleanArray connectionTypes, byte capabilities, int downstreamKbps, int upstreamKbps, List<InetAddress> linkNames, String httpProxyHost, String bssid, String interfaceName, String interfaceAddress) {
        this.connectionTypes = connectionTypes;
        this.capabilities = capabilities;
        this.downstreamKbps = downstreamKbps;
        this.upstreamKbps = upstreamKbps;
        this.linkNames = linkNames;
        this.httpProxyHost = httpProxyHost;
        this.bssid = bssid;
        this.interfaceName = interfaceName;
        this.interfaceAddress = interfaceAddress;
    }

    @Override
    public NetworkDescriptor mergeFrom(ProtobufReader reader) {
        Builder builder = this.toBuilder().connectionTypes(this.connectionTypes);
        block13: while (reader.hasRemaining()) {
            switch (reader.readTag()) {
                case 1: {
                    SparseBooleanArray types = builder.connectionTypes();
                    if (types == this.connectionTypes) {
                        types = new SparseBooleanArray(1);
                        builder.connectionTypes(types);
                    }
                    types.put(reader.readUnsignedInt(), true);
                    continue block13;
                }
                case 2: {
                    builder.capabilities(reader.readByteBufferView().get());
                    continue block13;
                }
                case 3: {
                    builder.downstreamKbps(reader.readUnsignedInt());
                    continue block13;
                }
                case 4: {
                    builder.upstreamKbps(reader.readUnsignedInt());
                    continue block13;
                }
                case 5: {
                    List<InetAddress> names = builder.linkNames();
                    if (names == this.linkNames) {
                        names = new ArrayList<InetAddress>(1);
                        builder.linkNames(names);
                    }
                    byte[] name = reader.readByteArray();
                    try {
                        names.add(InetAddress.getByAddress(name));
                        continue block13;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("malformed name", e);
                    }
                }
                case 6: {
                    builder.httpProxyHost(reader.readUtf8());
                    continue block13;
                }
                case 7: {
                    builder.bssid(reader.readUtf8());
                    continue block13;
                }
                case 8: {
                    builder.interfaceName(reader.readUtf8());
                    continue block13;
                }
                case 9: {
                    builder.interfaceAddress(reader.readUtf8());
                    continue block13;
                }
            }
            reader.readAndDiscard();
        }
        return builder.build();
    }

    @Override
    public void writeTo(ProtobufWriter writer) {
        writer.writeUnsignedInt(3, this.downstreamKbps).writeUnsignedInt(4, this.upstreamKbps).writeUtf8(6, this.httpProxyHost).writeUtf8(7, this.bssid).writeUtf8(8, this.interfaceName).writeUtf8(9, this.interfaceAddress);
        for (int i = 0; i < this.connectionTypes.size(); ++i) {
            if (!this.connectionTypes.valueAt(i)) continue;
            writer.writeUnsignedInt(1, this.connectionTypes.keyAt(i));
        }
        if (this.capabilities != 0) {
            writer.writeByteArray(2, new byte[]{this.capabilities});
        }
        for (InetAddress name : this.linkNames) {
            writer.writeByteArray(5, name.getAddress());
        }
    }

    public Builder toBuilder() {
        return new AutoBuilder_NetworkDescriptor_Builder(this).connectionTypes(this.connectionTypes.clone());
    }

    public SparseBooleanArray connectionTypes() {
        return this.connectionTypes;
    }

    public boolean hasConnectionType(int type) {
        return this.connectionTypes.get(type);
    }

    public byte capabilities() {
        return this.capabilities;
    }

    public boolean hasCapability(int cap) {
        return (this.capabilities & Bits.intMaskOf(cap)) != 0;
    }

    public int downstreamKbps() {
        return this.downstreamKbps;
    }

    public int upstreamKbps() {
        return this.upstreamKbps;
    }

    public List<InetAddress> linkNames() {
        return this.linkNames;
    }

    public String httpProxyHost() {
        return this.httpProxyHost;
    }

    public String bssid() {
        return this.bssid;
    }

    public String interfaceName() {
        return this.interfaceName;
    }

    public String interfaceAddress() {
        return this.interfaceAddress;
    }

    public int hashCode() {
        return Objects.hash(this.connectionTypes, this.capabilities, this.downstreamKbps, this.upstreamKbps, this.linkNames, this.httpProxyHost, this.bssid, this.interfaceName, this.interfaceAddress);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof NetworkDescriptor)) {
            return false;
        }
        NetworkDescriptor that = (NetworkDescriptor)other;
        return Objects.equals(this.connectionTypes, that.connectionTypes) && this.capabilities == that.capabilities && this.downstreamKbps == that.downstreamKbps && this.upstreamKbps == that.upstreamKbps && Objects.equals(this.linkNames, that.linkNames) && Objects.equals(this.httpProxyHost, that.httpProxyHost) && Objects.equals(this.bssid, that.bssid) && Objects.equals(this.interfaceName, that.interfaceName) && Objects.equals(this.interfaceAddress, that.interfaceAddress);
    }

    public String toString() {
        return super.toString();
    }

    @AutoBuilder
    public static abstract class Builder {
        Builder() {
        }

        Builder(NetworkDescriptor src) {
        }

        abstract SparseBooleanArray connectionTypes();

        @ReturnThis
        abstract Builder connectionTypes(SparseBooleanArray var1);

        public Builder connectionType(int type, boolean has) {
            SparseBooleanArray types = this.connectionTypes();
            if (has) {
                types.put(type, true);
            } else {
                types.delete(type);
            }
            return this;
        }

        public Builder clearConnectionTypes() {
            this.connectionTypes().clear();
            return this;
        }

        abstract byte capabilities();

        @ReturnThis
        abstract Builder capabilities(byte var1);

        public Builder capability(int cap, boolean has) {
            int caps = this.capabilities() & 0xFF;
            int mask = Bits.intMaskOf(cap);
            return this.capabilities((byte)(has ? caps | mask : caps & ~mask));
        }

        public Builder clearCapabilities() {
            return this.capabilities((byte)0);
        }

        @ReturnThis
        public abstract Builder downstreamKbps(int var1);

        @ReturnThis
        public abstract Builder upstreamKbps(int var1);

        abstract List<InetAddress> linkNames();

        @ReturnThis
        public abstract Builder linkNames(List<InetAddress> var1);

        @ReturnThis
        public abstract Builder httpProxyHost(String var1);

        @ReturnThis
        public abstract Builder bssid(String var1);

        @ReturnThis
        public abstract Builder interfaceName(String var1);

        @ReturnThis
        public abstract Builder interfaceAddress(String var1);

        public abstract NetworkDescriptor build();
    }
}

