/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.ProxyInfo;
import android.net.TransportInfo;
import android.net.wifi.WifiInfo;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.polygamma.ogm.net.ConnectionTypes;
import com.polygamma.ogm.net.ConnectivityDescriptor;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.DescriptorUpdater;
import com.polygamma.ogm.net.NetworkDescriptor;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

class NetworksUpdater
implements DescriptorUpdater {
    private static final String TAG = NetworksUpdater.class.getSimpleName();
    final ConnectivityModule module;

    static void probeCapabilities(NetworkDescriptor.Builder dst, NetworkCapabilities src) {
        TransportInfo ti;
        dst.capability(1, src.hasCapability(12)).capability(2, src.hasCapability(0)).capability(3, Build.VERSION.SDK_INT >= 28 && src.hasCapability(18)).capability(0, Build.VERSION.SDK_INT >= 23 && src.hasCapability(16)).capability(4, src.hasCapability(11));
        dst.connectionType(3, src.hasTransport(0)).connectionType(1, src.hasTransport(3)).connectionType(2, src.hasTransport(1)).connectionType(501, Build.VERSION.SDK_INT >= 26 && src.hasTransport(5)).connectionType(500, src.hasTransport(4));
        dst.downstreamKbps(src.getLinkDownstreamBandwidthKbps()).upstreamKbps(src.getLinkUpstreamBandwidthKbps());
        if (Build.VERSION.SDK_INT >= 29 && (ti = src.getTransportInfo()) instanceof WifiInfo) {
            WifiInfo wi = (WifiInfo)ti;
            try {
                String bssid = (String)MoreObjects.firstNonNull((Object)wi.getBSSID(), (Object)"02:00:00:00:00:00");
                if (!bssid.equals("02:00:00:00:00:00")) {
                    dst.bssid(bssid);
                }
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to resolve WiFi BSSID", e);
            }
            try {
                String mac = (String)MoreObjects.firstNonNull((Object)wi.getMacAddress(), (Object)"02:00:00:00:00:00");
                if (!mac.equals("02:00:00:00:00:00")) {
                    dst.interfaceAddress(mac);
                }
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "failed to resolve MAC address", e);
            }
        }
    }

    static void probeLink(NetworkDescriptor.Builder dst, LinkProperties src) {
        ProxyInfo proxy;
        ArrayList names = new ArrayList();
        for (LinkAddress name : Objects.requireNonNullElse(src.getLinkAddresses(), Collections.emptyList())) {
            names.add(name.getAddress());
        }
        dst.linkNames(names.isEmpty() ? Collections.emptyList() : names);
        if (!Strings.isNullOrEmpty((String)src.getInterfaceName())) {
            dst.interfaceName(src.getInterfaceName());
        }
        if ((proxy = src.getHttpProxy()) != null && !Strings.isNullOrEmpty((String)proxy.getHost())) {
            String host = proxy.getHost();
            if (proxy.getPort() > 0) {
                host = String.format("%s:%s", host, proxy.getPort());
            }
            dst.httpProxyHost(host);
        }
    }

    NetworksUpdater(ConnectivityModule module) {
        ConnectivityManager ignored = module.connectivity();
        this.module = module;
    }

    @RequiresApi(api=23)
    @Nullable
    private NetworkDescriptor updateActiveM(Context ctxt) {
        ConnectivityManager conn = this.module.connectivity();
        Network act = conn.getActiveNetwork();
        if (act == null) {
            return null;
        }
        NetworkCapabilities caps = conn.getNetworkCapabilities(act);
        LinkProperties link = conn.getLinkProperties(act);
        if (caps == null && link == null) {
            return null;
        }
        NetworkDescriptor.Builder desc = NetworkDescriptor.ofBuilder();
        if (caps != null) {
            NetworksUpdater.probeCapabilities(desc, caps);
        }
        if (link != null) {
            NetworksUpdater.probeLink(desc, link);
        }
        return desc.build();
    }

    @Nullable
    private NetworkDescriptor updateActive(Context ctxt) {
        NetworkInfo act = this.module.connectivity().getActiveNetworkInfo();
        if (act == null) {
            return null;
        }
        NetworkDescriptor.Builder desc = NetworkDescriptor.ofBuilder();
        int type = ConnectionTypes.ofTelephony(act.getSubtype());
        if (type == 0) {
            type = ConnectionTypes.ofConnectivity(act.getType());
        }
        if (type != 0) {
            desc.connectionType(type, true);
        }
        return desc.capability(1, act.isAvailable()).capability(0, act.isConnectedOrConnecting()).build();
    }

    @Override
    public boolean update(ConnectivityDescriptor.Builder dst, Context ctxt) {
        NetworkDescriptor desc;
        NetworkDescriptor networkDescriptor = !AndroidContexts.hasPermission(ctxt, "android.permission.ACCESS_NETWORK_STATE") ? null : (desc = Build.VERSION.SDK_INT >= 23 ? this.updateActiveM(ctxt) : this.updateActive(ctxt));
        if (desc == null) {
            dst.networks(Collections.emptyList()).activeNetworkIndex(-1);
        } else {
            dst.networks(Collections.singletonList(desc)).activeNetworkIndex(0);
        }
        return false;
    }

    @Override
    public void close() {
    }
}

