/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkRequest;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.polygamma.ogm.net.ConnectivityDescriptor;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.NetworkDescriptor;
import com.polygamma.ogm.net.NetworksUpdater;
import com.polygamma.ogm.util.AndroidContexts;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.Sync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

@RequiresApi(api=24)
class NetworksUpdaterN
extends NetworksUpdater {
    private static final String TAG = NetworksUpdaterN.class.getSimpleName();
    private final ReadWriteLock updateLock = Sync.newReadWriteLock();
    private final HashMap<Network, NetworkDescriptor> descriptors = new HashMap();
    private HashMap<Network, LinkProperties> pendingLinkUpdates = new HashMap();
    private HashMap<Network, NetworkCapabilities> pendingCapabilitiesUpdates = new HashMap();
    private HashSet<Network> pendingRemovalUpdates = new HashSet();
    @Nullable
    private Network activeNetwork;
    @VisibleForTesting
    @Nullable
    OnAvailable[] callbacks;

    NetworksUpdaterN(ConnectivityModule module) {
        super(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyPendingUpdates() {
        HashSet<Network> removals;
        HashMap<Network, NetworkCapabilities> caps;
        HashMap<Network, LinkProperties> links;
        Lock read = this.updateLock.readLock();
        read.lock();
        try {
            links = this.pendingLinkUpdates;
            caps = this.pendingCapabilitiesUpdates;
            removals = this.pendingRemovalUpdates;
            this.pendingLinkUpdates = new HashMap();
            this.pendingCapabilitiesUpdates = new HashMap();
            this.pendingRemovalUpdates = new HashSet();
        }
        finally {
            read.unlock();
        }
        HashMap<Network, NetworkDescriptor> descs = this.descriptors;
        for (Network net : removals) {
            descs.remove(net);
        }
        ArrayList<Network> worklist = new ArrayList<Network>(links.size());
        worklist.addAll(links.keySet());
        worklist.addAll(caps.keySet());
        for (Network net : worklist) {
            NetworkDescriptor desc = descs.get(net);
            NetworkDescriptor.Builder builder = desc == null ? NetworkDescriptor.ofBuilder() : desc.toBuilder();
            LinkProperties link = links.get(net);
            NetworkCapabilities cap = caps.get(net);
            if (link != null) {
                NetworksUpdaterN.probeLink(builder, link);
            }
            if (cap != null) {
                NetworksUpdaterN.probeCapabilities(builder, cap);
            }
            descs.put(net, builder.build());
        }
    }

    private void publish(ConnectivityDescriptor.Builder dst) {
        ArrayList<NetworkDescriptor> descs = new ArrayList<NetworkDescriptor>(this.descriptors.size());
        Network active = this.activeNetwork;
        int activeIdx = -1;
        for (Map.Entry<Network, NetworkDescriptor> en : this.descriptors.entrySet()) {
            if (active != null && en.getKey().equals((Object)active)) {
                activeIdx = descs.size();
            }
            descs.add(en.getValue());
        }
        dst.networks(descs).activeNetworkIndex(activeIdx);
    }

    @Override
    public boolean update(ConnectivityDescriptor.Builder dst, Context ctxt) {
        OnAvailable available;
        OnActive active;
        if (this.callbacks != null) {
            this.applyPendingUpdates();
            this.publish(dst);
            return true;
        }
        super.update(dst, ctxt);
        if (!AndroidContexts.hasPermission(ctxt, "android.permission.ACCESS_NETWORK_STATE")) {
            return false;
        }
        ConnectivityManager conn = this.module.connectivity();
        if (Build.VERSION.SDK_INT >= 31 && AndroidContexts.hasPermission(ctxt, "android.permission.ACCESS_FINE_LOCATION")) {
            active = new OnActive(1);
            available = new OnAvailable(1);
        } else {
            active = new OnActive();
            available = new OnAvailable();
        }
        try {
            conn.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)active);
        }
        catch (Throwable ignored) {
            return false;
        }
        try {
            NetworkRequest.Builder req = new NetworkRequest.Builder();
            req.addTransportType(0).addTransportType(1).addTransportType(3).addTransportType(4);
            if (Build.VERSION.SDK_INT >= 26) {
                req.addTransportType(5);
            }
            conn.registerNetworkCallback(req.build(), (ConnectivityManager.NetworkCallback)available);
        }
        catch (Throwable ignored) {
            conn.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)active);
            return false;
        }
        this.callbacks = new OnAvailable[]{active, available};
        DebugBuild.log(TAG, "registered callbacks");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        OnAvailable[] cbs = this.callbacks;
        try {
            if (cbs != null) {
                for (OnAvailable cb : cbs) {
                    this.module.connectivity().unregisterNetworkCallback((ConnectivityManager.NetworkCallback)cb);
                }
            }
        }
        finally {
            this.callbacks = null;
            super.close();
        }
    }

    private class OnAvailable
    extends ConnectivityManager.NetworkCallback {
        @RequiresApi(api=31)
        private OnAvailable(int flags) {
            super(flags);
        }

        private OnAvailable() {
        }

        public void onAvailable(Network net) {
            Lock write = NetworksUpdaterN.this.updateLock.writeLock();
            write.lock();
            try {
                NetworksUpdaterN.this.pendingRemovalUpdates.remove(net);
            }
            finally {
                write.unlock();
            }
            NetworksUpdaterN.this.module.updateAvailable(NetworksUpdaterN.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCapabilitiesChanged(Network net, NetworkCapabilities caps) {
            Lock write = NetworksUpdaterN.this.updateLock.writeLock();
            write.lock();
            try {
                NetworksUpdaterN.this.pendingCapabilitiesUpdates.put(net, caps);
            }
            finally {
                write.unlock();
            }
            NetworksUpdaterN.this.module.updateAvailable(NetworksUpdaterN.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onLinkPropertiesChanged(Network net, LinkProperties props) {
            Lock write = NetworksUpdaterN.this.updateLock.writeLock();
            write.lock();
            try {
                NetworksUpdaterN.this.pendingLinkUpdates.put(net, props);
            }
            finally {
                write.unlock();
            }
            NetworksUpdaterN.this.module.updateAvailable(NetworksUpdaterN.this);
        }

        public void onLost(Network net) {
            Lock write = NetworksUpdaterN.this.updateLock.writeLock();
            write.lock();
            try {
                NetworksUpdaterN.this.pendingRemovalUpdates.add(net);
            }
            finally {
                write.unlock();
            }
            NetworksUpdaterN.this.module.updateAvailable(NetworksUpdaterN.this);
        }
    }

    private final class OnActive
    extends OnAvailable {
        @RequiresApi(api=31)
        private OnActive(int flags) {
            super(flags);
        }

        private OnActive() {
        }

        @Override
        public void onAvailable(Network net) {
            Lock write = NetworksUpdaterN.this.updateLock.writeLock();
            write.lock();
            try {
                NetworksUpdaterN.this.pendingRemovalUpdates.remove(net);
                NetworksUpdaterN.this.activeNetwork = net;
            }
            finally {
                write.unlock();
            }
            NetworksUpdaterN.this.module.updateAvailable(NetworksUpdaterN.this);
        }

        public void onUnavailable() {
            Lock write = NetworksUpdaterN.this.updateLock.writeLock();
            write.lock();
            try {
                Network act = NetworksUpdaterN.this.activeNetwork;
                if (act != null) {
                    NetworksUpdaterN.this.pendingRemovalUpdates.add(act);
                    NetworksUpdaterN.this.activeNetwork = null;
                }
            }
            finally {
                write.unlock();
            }
            NetworksUpdaterN.this.module.updateAvailable(NetworksUpdaterN.this);
        }
    }
}

