/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import androidx.annotation.Nullable;
import com.google.common.util.concurrent.SettableFuture;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.Gzip;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

final class RemoteServiceExchange {
    private static final String TAG = RemoteServiceExchange.class.getSimpleName();
    private final SettableFuture<Object> future;
    private final boolean compress;
    private final long opcode;
    @Nullable
    private final Object requestBody;
    @Nullable
    private final ProtobufMessage baseResponseBody;

    RemoteServiceExchange(boolean compress, long opcode, @Nullable Object requestBody, @Nullable ProtobufMessage baseResponseBody) {
        this.compress = compress;
        this.future = SettableFuture.create();
        this.opcode = opcode;
        this.requestBody = requestBody;
        this.baseResponseBody = baseResponseBody;
    }

    SettableFuture<?> future() {
        return this.future;
    }

    int service() {
        return (int)(this.opcode >>> 32);
    }

    void beginExchange(ProtobufWriter writer) {
        ByteBuffer body;
        writer.writeFixedLong(1, this.opcode);
        if (this.requestBody instanceof ByteBuffer) {
            body = ((ByteBuffer)this.requestBody).duplicate();
        } else if (this.requestBody instanceof ProtobufMessage) {
            ProtobufWriter w = new ProtobufWriter();
            ((ProtobufMessage)this.requestBody).writeTo(w);
            body = w.finish();
        } else {
            return;
        }
        if (this.compress) {
            try {
                body = Gzip.compress(body.duplicate());
                writer.writeBoolean(3, true);
            }
            catch (IOException e) {
                DebugBuild.log(TAG, "Failed to compress body", e);
            }
        }
        writer.writeByteBuffer(2, body);
    }

    void endExchange(ProtobufReader reader) {
        int status = -1;
        ByteBuffer body = null;
        try {
            block8: while (reader.hasRemaining()) {
                switch (reader.readTag()) {
                    case 1: {
                        status = reader.readUnsignedInt();
                        continue block8;
                    }
                    case 2: {
                        body = reader.readByteBufferView();
                        continue block8;
                    }
                }
                reader.readAndDiscard();
            }
        }
        catch (Throwable e) {
            this.future.setException(e);
            return;
        }
        if (status == -1) {
            this.future.setException((Throwable)new IllegalStateException("expected status"));
            return;
        }
        if (body == null) {
            body = ByteBuffer.allocate(0);
        }
        if (status == 0) {
            try {
                this.future.set(this.baseResponseBody == null ? body : this.baseResponseBody.mergeFrom(new ProtobufReader(body)));
            }
            catch (Throwable e) {
                this.future.setException(e);
            }
        } else {
            this.future.setException((Throwable)new IllegalStateException(String.format("request failed: %s", StandardCharsets.UTF_8.decode(body).toString())));
        }
    }
}

