/*
 * Decompiled with CFR 0.152.
 */
package com.polygamma.ogm.net;

import android.content.Context;
import android.net.http.ConnectionMigrationOptions;
import android.net.http.DnsOptions;
import android.net.http.HttpEngine;
import android.os.Build;
import android.util.Pair;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Consumer;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.polygamma.ogm.OriginMobile;
import com.polygamma.ogm.OriginModule;
import com.polygamma.ogm.net.ConnectivityModule;
import com.polygamma.ogm.net.RemoteServiceExchange;
import com.polygamma.ogm.net.SubscriptionDescriptor;
import com.polygamma.ogm.util.DebugBuild;
import com.polygamma.ogm.util.ProtobufMessage;
import com.polygamma.ogm.util.ProtobufReader;
import com.polygamma.ogm.util.ProtobufWriter;
import com.polygamma.ogm.util.Sync;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.json.JSONObject;

public class RemoteServiceModule
extends OriginModule {
    private static final String TAG = RemoteServiceModule.class.getSimpleName();
    private static final String DEFAULT_SERVICE_HOST = "ogsvc.pgoriginad.com";
    private static final String DEFAULT_CN_SERVICE_HOST = "ogsvc.pg-adtech.cn";
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_READ_TIMEOUT_MILLIS = (int)TimeUnit.SECONDS.toMillis(30L);
    private static final int DEFAULT_POST_RETRY_DELAY_MILLIS = (int)TimeUnit.SECONDS.toMillis(15L);
    private static final int DEFAULT_EXCHANGE_BATCH_SIZE = 64;
    private static final String CACHED_SETTINGS = "ogm_remotesvc";
    private static final String ROOT_SERVICE_HOST_SETTING = "0";
    private static final String SERVICE_HOSTS_SETTING = "1";
    private static final String COMPRESS_BODY_SETTING = "2";
    private final ConnectivityModule connectivity;
    private final boolean autoConfigureRootServiceHost;
    private final int connectTimeoutMillis;
    private final int readTimeoutMillis;
    private final int postRetryDelayMillis;
    private final int exchangeBatchSize;
    private final ReadWriteLock lock;
    @VisibleForTesting
    @Nullable
    String rootServiceHost;
    @VisibleForTesting
    final SparseArray<String> serviceHosts;
    @VisibleForTesting
    final LinkedTransferQueue<RemoteServiceExchange> pending;
    @VisibleForTesting
    @Nullable
    Future<?> postPendingFuture;
    private boolean destroyed;
    private boolean sentInitialHelo;
    private boolean compressBody;

    public static Provider ofProvider() {
        return new Provider();
    }

    private RemoteServiceModule(OriginMobile sdk, Provider prov) {
        super("remote-service", sdk);
        this.connectivity = sdk.getOrLoadModuleSync(ConnectivityModule.class);
        this.autoConfigureRootServiceHost = prov.rootServiceHost == null;
        this.connectTimeoutMillis = prov.connectTimeoutMillis;
        this.readTimeoutMillis = prov.readTimeoutMillis;
        this.postRetryDelayMillis = prov.postRetryDelayMillis;
        this.exchangeBatchSize = prov.exchangeBatchSize;
        this.lock = Sync.newReadWriteLock();
        this.rootServiceHost = prov.rootServiceHost;
        this.serviceHosts = new SparseArray();
        this.pending = new LinkedTransferQueue();
    }

    HttpURLConnection openConnection(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(this.connectTimeoutMillis);
        conn.setReadTimeout(this.readTimeoutMillis);
        return conn;
    }

    private HttpURLConnection prepareConnection(String host) throws IOException {
        URL ep = new URL(String.format("%s://%s", "https", host));
        HttpURLConnection conn = this.openConnection(ep);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        conn.setRequestMethod("POST");
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        conn.setRequestProperty("Host", ep.getHost());
        conn.setRequestProperty("x-ogm-sid", super.sdk().startupId().toString());
        conn.setRequestProperty("x-ogm-sdy", "com.polygamma.ogm");
        conn.setRequestProperty("x-ogm-svr", OriginMobile.VERSION);
        conn.setRequestProperty("x-ogm-app", super.sdk().app().bundle());
        conn.setRequestProperty("x-ogm-os", "Android");
        conn.setRequestProperty("x-requested-with", super.sdk().app().bundle());
        return conn;
    }

    private Pair<List<RemoteServiceExchange>, ByteBuffer> beginExchanges(List<RemoteServiceExchange> xchgs) {
        ArrayList<RemoteServiceExchange> began = new ArrayList<RemoteServiceExchange>(xchgs.size());
        ProtobufWriter writer = new ProtobufWriter();
        for (int i = 0; i < xchgs.size(); ++i) {
            RemoteServiceExchange xchg = xchgs.get(i);
            if (xchg.future().isDone()) continue;
            began.add(xchg);
            writer.writeMessage(i + 1, (Consumer<ProtobufWriter>)((Consumer)xchgs.get(i)::beginExchange));
        }
        return new Pair(began, (Object)writer.finish());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPost(String host, List<RemoteServiceExchange> xchgs) throws IOException {
        Pair<List<RemoteServiceExchange>, ByteBuffer> began = this.beginExchanges(xchgs);
        xchgs = (List)began.first;
        if (xchgs.isEmpty()) {
            return;
        }
        HttpURLConnection conn = this.prepareConnection(host);
        try {
            ByteBuffer msg;
            try (OutputStream out = conn.getOutputStream();){
                msg = (ByteBuffer)began.second;
                out.write(msg.array(), msg.arrayOffset() + msg.position(), msg.remaining());
                DebugBuild.log(TAG, "posted %d/%d bytes/requests to %s", msg.remaining(), xchgs.size(), host);
            }
            if (conn.getResponseCode() != 200) {
                throw new IOException(String.format(Locale.ROOT, "invalid response code %d: %s", conn.getResponseCode(), conn.getResponseMessage()));
            }
            try (InputStream in = conn.getInputStream();){
                msg = ByteBuffer.wrap(Build.VERSION.SDK_INT >= 33 ? in.readAllBytes() : ByteStreams.toByteArray((InputStream)in));
                ProtobufReader reader = new ProtobufReader(msg);
                DebugBuild.log(TAG, "received %d bytes from %s", msg.remaining(), host);
                while (reader.hasRemaining()) {
                    ((RemoteServiceExchange)xchgs.get(reader.readTag() - 1)).endExchange(new ProtobufReader(reader.readByteBufferView()));
                }
            }
        }
        finally {
            conn.disconnect();
        }
    }

    private boolean post(String host, List<RemoteServiceExchange> xchgs) {
        try {
            this.doPost(host, xchgs);
        }
        catch (IOException e) {
            for (RemoteServiceExchange xchg : xchgs) {
                this.addPending(xchg);
            }
            return true;
        }
        catch (Throwable e) {
            for (RemoteServiceExchange xchg : xchgs) {
                xchg.future().setException(e);
            }
        }
        return false;
    }

    private ArrayList<String> initialRootServiceHosts() {
        ArrayList<String> hosts = new ArrayList<String>(3);
        SubscriptionDescriptor sub = this.connectivity.descriptor().activeSubscription();
        if (!this.autoConfigureRootServiceHost) {
            hosts.add(DebugBuild.checkNotNull(this.rootServiceHost));
        } else if (sub != null && ("cn".equalsIgnoreCase(sub.networkCountryCode()) || "cn".equalsIgnoreCase(sub.countryCode()))) {
            hosts.add(DEFAULT_SERVICE_HOST);
            hosts.add(DEFAULT_CN_SERVICE_HOST);
        } else {
            hosts.add(DEFAULT_CN_SERVICE_HOST);
            hosts.add(DEFAULT_SERVICE_HOST);
        }
        return hosts;
    }

    private String queryRootServiceHost(String host) throws Exception {
        RemoteServiceExchange xchg = new RemoteServiceExchange(false, 1869374824L, null, null);
        this.doPost(host, Collections.singletonList(xchg));
        ProtobufReader resp = new ProtobufReader((ByteBuffer)Futures.getUnchecked(xchg.future()));
        String root = host;
        SparseArray<String> svcs = this.serviceHosts;
        svcs.clear();
        this.compressBody = false;
        block9: while (resp.hasRemaining()) {
            switch (resp.readTag()) {
                case 1: {
                    root = resp.readUtf8();
                    if (!root.isEmpty()) continue block9;
                    root = host;
                    continue block9;
                }
                case 2: {
                    ProtobufReader svch = new ProtobufReader(resp.readByteBufferView());
                    int svc = -1;
                    String svcHost = "";
                    block10: while (svch.hasRemaining()) {
                        switch (svch.readTag()) {
                            case 1: {
                                svc = svch.readUnsignedInt();
                                continue block10;
                            }
                            case 2: {
                                svcHost = svch.readUtf8();
                                continue block10;
                            }
                        }
                        svch.readAndDiscard();
                    }
                    svcs.put(svc, (Object)svcHost);
                    continue block9;
                }
                case 3: {
                    this.compressBody = resp.readBoolean();
                    continue block9;
                }
            }
            resp.readAndDiscard();
        }
        return root;
    }

    private boolean findRootServiceHost() {
        ArrayList<String> roots = this.initialRootServiceHosts();
        while (!roots.isEmpty()) {
            String root = roots.remove(roots.size() - 1);
            try {
                String newRoot = this.queryRootServiceHost(root);
                if (newRoot.equals(root)) {
                    if (this.autoConfigureRootServiceHost) {
                        this.rootServiceHost = root;
                    } else if (!root.equals(this.rootServiceHost)) {
                        this.serviceHosts.put(0, (Object)root);
                    }
                    this.sentInitialHelo = true;
                    this.saveRootServiceHost();
                    DebugBuild.log(TAG, "new root service host: %s", root);
                    return true;
                }
                roots.add(newRoot);
            }
            catch (IOException e) {
                DebugBuild.log(TAG, "root service host probe for %s encountered network issue", root, e);
            }
            catch (Throwable e) {
                DebugBuild.log(TAG, "root service host probe for %s encountered non-network issue", root, e);
            }
        }
        DebugBuild.log(TAG, "failed to find new root service host");
        this.serviceHosts.clear();
        this.sentInitialHelo = false;
        if (this.autoConfigureRootServiceHost) {
            this.rootServiceHost = null;
        }
        return false;
    }

    private List<Pair<String, ArrayList<RemoteServiceExchange>>> pollPending() {
        RemoteServiceExchange xchg;
        SparseArray xchgs = new SparseArray();
        for (int i = 0; i < this.exchangeBatchSize && (xchg = this.pending.poll()) != null; ++i) {
            ArrayList<RemoteServiceExchange> svc = (ArrayList<RemoteServiceExchange>)xchgs.get(xchg.service());
            if (svc == null) {
                svc = new ArrayList<RemoteServiceExchange>();
                xchgs.put(xchg.service(), svc);
            }
            svc.add(xchg);
        }
        ArrayList<Pair<String, ArrayList<RemoteServiceExchange>>> pend = new ArrayList<Pair<String, ArrayList<RemoteServiceExchange>>>(xchgs.size());
        String root = (String)this.serviceHosts.get(0, (Object)this.rootServiceHost);
        if (Strings.isNullOrEmpty((String)root)) {
            root = this.rootServiceHost;
        }
        for (int i = 0; i < xchgs.size(); ++i) {
            pend.add((Pair<String, ArrayList<RemoteServiceExchange>>)new Pair((Object)((String)this.serviceHosts.get(xchgs.keyAt(i), (Object)root)), (Object)((ArrayList)xchgs.valueAt(i))));
        }
        return pend;
    }

    private void scheduleRetryPostPending() {
        this.postPendingFuture = super.sdk().background().schedule(this::postPending, (long)this.postRetryDelayMillis, TimeUnit.MILLISECONDS);
        DebugBuild.log(TAG, "scheduled post retry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String canPostPending(@Nullable String currRootSvcHost) {
        Lock read = this.lock.readLock();
        read.lock();
        try {
            if (this.destroyed) {
                this.postPendingFuture = null;
                String string = null;
                return string;
            }
            if (currRootSvcHost == null && !this.findRootServiceHost()) {
                DebugBuild.checkState(this.postPendingFuture != null);
                this.scheduleRetryPostPending();
                String string = null;
                return string;
            }
            String string = this.rootServiceHost;
            return string;
        }
        finally {
            read.unlock();
        }
    }

    private boolean canEndPostPending() {
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            if (this.destroyed || this.pending.isEmpty()) {
                this.postPendingFuture = null;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            write.unlock();
        }
    }

    private void postPending() {
        List<Pair<String, ArrayList<RemoteServiceExchange>>> pending;
        String rootSvcHost = this.sentInitialHelo ? this.rootServiceHost : null;
        ArrayList<ListenableFuture> subFuts = new ArrayList<ListenableFuture>();
        while (!((rootSvcHost = this.canPostPending(rootSvcHost)) == null || (pending = this.pollPending()).isEmpty() && this.canEndPostPending())) {
            int i;
            for (i = pending.size() - 1; i >= 1; --i) {
                Pair<String, ArrayList<RemoteServiceExchange>> pair = pending.get(i);
                try {
                    subFuts.add(super.sdk().background().submit(() -> this.post((String)pair.first, (List)pair.second)));
                }
                catch (RejectedExecutionException ignored) {
                    break;
                }
                pending.remove(i);
            }
            for (i = 0; i < pending.size(); ++i) {
                Pair<String, ArrayList<RemoteServiceExchange>> pair = pending.get(i);
                if (!this.post((String)pair.first, (List)pair.second)) continue;
                rootSvcHost = null;
                for (int j = i + 1; j < pending.size(); ++j) {
                    this.pending.addAll((Collection)pending.get((int)j).second);
                }
                break;
            }
            for (Future future : subFuts) {
                try {
                    Futures.getUnchecked((Future)future);
                }
                catch (Throwable throwable) {}
            }
            if (rootSvcHost != null) continue;
            this.scheduleRetryPostPending();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPending(RemoteServiceExchange xchg) {
        if (xchg.future().isDone()) {
            return;
        }
        Lock read = this.lock.readLock();
        read.lock();
        try {
            if (this.destroyed) {
                xchg.future().setException((Throwable)new IllegalStateException("module destroyed"));
                return;
            }
            this.pending.add(xchg);
            if (this.postPendingFuture != null) {
                return;
            }
        }
        finally {
            read.unlock();
        }
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            if (!this.destroyed && this.postPendingFuture == null) {
                try {
                    this.postPendingFuture = super.sdk().background().submit(this::postPending);
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    // empty catch block
                }
            }
        }
        finally {
            write.unlock();
        }
    }

    private ListenableFuture<?> doSendRequest(long opcode, @Nullable Object request, @Nullable ProtobufMessage responseBase) {
        RemoteServiceExchange xchg = new RemoteServiceExchange(this.compressBody, opcode, request, responseBase);
        this.addPending(xchg);
        return xchg.future();
    }

    public <T extends ProtobufMessage> ListenableFuture<T> sendRequest(long opcode, @Nullable ProtobufMessage request, T responseBase) {
        return this.doSendRequest(opcode, request, DebugBuild.checkNotNull(responseBase));
    }

    public ListenableFuture<ByteBuffer> sendRequest(long opcode, @Nullable ProtobufMessage request) {
        return this.doSendRequest(opcode, request, null);
    }

    public ListenableFuture<ByteBuffer> sendRequest(long opcode, @Nullable ByteBuffer request) {
        return this.doSendRequest(opcode, request, null);
    }

    public ListenableFuture<ByteBuffer> sendRequest(long opcode) {
        return this.doSendRequest(opcode, null, null);
    }

    private void doSaveRootServiceHost() throws Exception {
        if (this.rootServiceHost == null) {
            return;
        }
        JSONObject cached = new JSONObject();
        JSONObject svcHosts = new JSONObject();
        for (int i = 0; i < this.serviceHosts.size(); ++i) {
            svcHosts.put(Integer.toString(this.serviceHosts.keyAt(i)), this.serviceHosts.valueAt(i));
        }
        cached.put(ROOT_SERVICE_HOST_SETTING, (Object)this.rootServiceHost).put(SERVICE_HOSTS_SETTING, (Object)svcHosts).put(COMPRESS_BODY_SETTING, this.compressBody);
        super.sdk().putJsonObjectSetting(CACHED_SETTINGS, cached);
        DebugBuild.log(TAG, String.format("Saved settings: %s", cached));
    }

    private void saveRootServiceHost() {
        try {
            this.doSaveRootServiceHost();
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "Failed to save service host settings", e);
        }
    }

    private boolean doLoadRootServiceHost() throws Exception {
        JSONObject cached = super.sdk().getJsonObjectSetting(CACHED_SETTINGS, new JSONObject());
        String rootSvcHost = cached.optString(ROOT_SERVICE_HOST_SETTING, "");
        JSONObject svcHosts = cached.optJSONObject(SERVICE_HOSTS_SETTING);
        if (rootSvcHost.isEmpty() || svcHosts == null || !this.autoConfigureRootServiceHost && !rootSvcHost.equals(this.rootServiceHost)) {
            return false;
        }
        Iterator svcs = svcHosts.keys();
        while (svcs.hasNext()) {
            String svc = (String)svcs.next();
            this.serviceHosts.put(Integer.parseInt(svc), (Object)svcHosts.getString(svc));
        }
        this.rootServiceHost = rootSvcHost;
        this.compressBody = cached.optBoolean(COMPRESS_BODY_SETTING, false);
        DebugBuild.log(TAG, String.format("Loaded settings: %s", cached));
        return true;
    }

    private boolean loadRootServiceHost() {
        try {
            return this.doLoadRootServiceHost();
        }
        catch (Throwable e) {
            DebugBuild.log(TAG, "Failed to load service host settings", e);
            return false;
        }
    }

    @Override
    protected void setup(Context ctxt) {
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            this.sentInitialHelo = this.loadRootServiceHost();
        }
        finally {
            write.unlock();
        }
    }

    @Override
    protected void destroy() {
        RemoteServiceExchange xchg;
        Future<?> postPendingFut;
        Lock write = this.lock.writeLock();
        write.lock();
        try {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            postPendingFut = this.postPendingFuture;
        }
        finally {
            write.unlock();
        }
        if (postPendingFut != null) {
            try {
                postPendingFut.get(30L, TimeUnit.SECONDS);
            }
            catch (Throwable ignored) {
                postPendingFut.cancel(false);
            }
        }
        while ((xchg = this.pending.poll()) != null) {
            xchg.future().setException((Throwable)new IllegalStateException("module destroyed"));
        }
    }

    public static final class Provider
    extends OriginModule.Provider<RemoteServiceModule> {
        private int connectTimeoutMillis = RemoteServiceModule.access$000();
        private int readTimeoutMillis = RemoteServiceModule.access$100();
        private int postRetryDelayMillis = RemoteServiceModule.access$200();
        private int exchangeBatchSize = 64;
        @Nullable
        private String rootServiceHost;

        private Provider() {
            super(RemoteServiceModule.class);
        }

        private static int millisOf(long x, TimeUnit u, int dfl) {
            Preconditions.checkArgument((x >= 0L ? 1 : 0) != 0);
            long ms = u.toMillis(x);
            int msi = ms >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ms;
            return msi == 0 ? dfl : msi;
        }

        public Provider connectTimeout(long timeout, TimeUnit unit) {
            this.connectTimeoutMillis = Provider.millisOf(timeout, unit, DEFAULT_CONNECT_TIMEOUT_MILLIS);
            return this;
        }

        public Provider readTimeout(long timeout, TimeUnit unit) {
            this.readTimeoutMillis = Provider.millisOf(timeout, unit, DEFAULT_READ_TIMEOUT_MILLIS);
            return this;
        }

        public Provider postRetryDelay(long delay, TimeUnit unit) {
            this.postRetryDelayMillis = Provider.millisOf(delay, unit, DEFAULT_POST_RETRY_DELAY_MILLIS);
            return this;
        }

        public Provider exchangeBatchSize(int size) {
            Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
            this.exchangeBatchSize = size == 0 ? 64 : size;
            return this;
        }

        public Provider rootServiceHost(@Nullable String host) {
            this.rootServiceHost = host;
            return this;
        }

        @Override
        protected RemoteServiceModule provide(OriginMobile sdk, Context ctxt) {
            if (Build.VERSION.SDK_INT >= 34) {
                try {
                    return new UpsideDownCake(sdk, ctxt, this);
                }
                catch (Throwable err) {
                    DebugBuild.log(TAG, "failed to create HTTP engine based service", err);
                }
            }
            return new RemoteServiceModule(sdk, this);
        }
    }

    @RequiresApi(value=34)
    private static final class UpsideDownCake
    extends RemoteServiceModule {
        private final HttpEngine http;

        private UpsideDownCake(OriginMobile sdk, Context ctxt, Provider prov) {
            super(sdk, prov);
            this.http = new HttpEngine.Builder(ctxt).setEnableHttp2(true).setEnableQuic(true).setEnableHttpCache(0, 0L).setDnsOptions(new DnsOptions.Builder().setStaleDns(2).setUseHttpStackDnsResolver(1).build()).setConnectionMigrationOptions(new ConnectionMigrationOptions.Builder().setAllowNonDefaultNetworkUsage(1).setDefaultNetworkMigration(1).setPathDegradationMigration(1).build()).build();
        }

        @Override
        HttpURLConnection openConnection(URL url) throws IOException {
            DebugBuild.log(TAG, String.format("opening HTTP engine based connection to %s", url));
            HttpURLConnection conn = (HttpURLConnection)this.http.openConnection(url);
            conn.setReadTimeout(((RemoteServiceModule)this).readTimeoutMillis);
            return conn;
        }
    }
}

